/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ui.collectors;

import com.ez.common.ui.listselection.ImageObj4Wizard;
import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.mainframe.data.utils.Utils;
import com.ez.report.application.model.AAutoJob;
import com.ez.report.application.model.AAutoNetwork;
import com.ez.report.application.ui.collectors.BridgeResourcesCollectorAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AAutoJobCollector
extends BridgeResourcesCollectorAdapter<AAutoJob> {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(AAutoJobCollector.class);
    private static final String ALL_AAUTO_JOBS_QUERY = "select JobId, JobName from AAUTOJobs";
    private List<Integer> networkIds = null;

    private static final String getSelective_AAuto_Jobs_Query(EZSourceConnection conn) {
        return "select AAUTOJobs.JobId, AAUTOJobs.JobName from AAUTOJobs inner join AAUTONetworkJobs on AAUTONetworkJobs.JobId = AAUTOJobs.JobID where NetworkID IN (select * from  " + Utils.getTempTableName((EZSourceConnection)conn, (String)"numeric_param_temp") + ")";
    }

    @Override
    public List<AAutoJob> collect(boolean useFilters, Set<String> apps, EZSourceConnection conn) {
        ArrayList<AAutoJob> jobsList = null;
        try {
            String[][] results = null;
            if (this.networkIds == null) {
                results = conn.executeSQL(ALL_AAUTO_JOBS_QUERY);
            } else {
                List<EZSourceDataType> types = Arrays.asList(new EZSourceDataType[this.networkIds.size()]);
                Collections.fill(types, EZSourceDataType.Integer);
                results = conn.executeSQL(AAutoJobCollector.getSelective_AAuto_Jobs_Query(conn), types, this.networkIds);
            }
            if (results != null && results.length > 0) {
                jobsList = new ArrayList<AAutoJob>();
                String[][] stringArray = results;
                int n = results.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] result = stringArray[n2];
                    Integer jobid = Integer.valueOf(result[0]);
                    String jobName = result[1];
                    AAutoJob job = new AAutoJob(jobid, jobName);
                    jobsList.add(job);
                    ++n2;
                }
            }
        }
        catch (EZSourceConnectionException e) {
            L.error("connection error", (Throwable)e);
        }
        return jobsList;
    }

    public void setNetworkIds(List<AAutoNetwork> selectedNetworks) {
        if (selectedNetworks == null) {
            this.networkIds = null;
        } else {
            this.networkIds = new ArrayList<Integer>();
            for (AAutoNetwork net : selectedNetworks) {
                this.networkIds.add(net.getNetwkId());
            }
        }
    }

    @Override
    public List<ImageObj4Wizard> getAvailableImages() {
        return null;
    }
}

