/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ui;

import com.ez.mainframe.gui.internal.Messages;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.model.StmtGroup;
import com.ez.mainframe.model.StmtType;
import com.ez.mainframe.selection.Manager;
import com.ez.report.application.ui.StmtTreeObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StmtTreeViewContentProvider
implements IStructuredContentProvider,
ITreeContentProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(StmtTreeViewContentProvider.class);

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    public Object[] getElements(Object parent) {
        return this.getChildren(parent);
    }

    public Object getParent(Object child) {
        if (child instanceof StmtTreeObject) {
            return ((StmtTreeObject)child).getParent();
        }
        return null;
    }

    public Object[] getChildren(Object parent) {
        if (parent instanceof StmtTreeObject) {
            return ((StmtTreeObject)parent).getChildren();
        }
        return new Object[0];
    }

    public boolean hasChildren(Object parent) {
        if (parent instanceof StmtTreeObject) {
            return ((StmtTreeObject)parent).hasChildren();
        }
        return false;
    }

    public static StmtTreeObject createStmtTreeModel(List<ProjectInfo> prjs, List<StmtGroup> allGroupsList, Map<String, StmtGroup> groups) {
        StmtTreeObject root = null;
        StmtGroup allGroup = null;
        HashMap<Integer, StmtTreeObject> stmtTreeObjects = new HashMap<Integer, StmtTreeObject>();
        if (allGroupsList != null && allGroupsList.size() > 0) {
            allGroup = allGroupsList.get(0);
            root = new StmtTreeObject("");
            int k = 0;
            while (k < allGroupsList.size()) {
                StmtGroup gr = allGroupsList.get(k);
                if (gr != null) {
                    boolean isAvailable = false;
                    if (prjs != null) {
                        for (ProjectInfo pi : prjs) {
                            Map pInfo = pi.getInfo();
                            isAvailable = Manager.getInstance().checkAvailability(pInfo, "stmtType", new Integer(k).toString());
                            if (isAvailable) break;
                        }
                    }
                    if (k != 0 && !isAvailable) {
                        Set notAvailable = gr.getTypes();
                        Set allTypes = allGroup.getTypes();
                        if (notAvailable != null) {
                            L.debug("group not available: {}", (Object)gr);
                        } else {
                            Set subgroups = gr.getSubgroups();
                            if (subgroups != null) {
                                for (Integer subgroupID : subgroups) {
                                    StmtGroup subgroup = allGroupsList.get(subgroupID);
                                    Set types = subgroup.getTypes();
                                    if (types == null || types.size() <= 0) continue;
                                    allTypes.removeAll(types);
                                }
                            }
                        }
                    } else {
                        String grDisplayName = Messages.getString(StmtTreeViewContentProvider.class, gr.getName());
                        gr.setDisplayName(grDisplayName);
                        StmtTreeObject to = new StmtTreeObject(grDisplayName);
                        to.setStmtId(gr.getName());
                        if (k == 0) {
                            allGroup = gr;
                            root.addChild(to);
                            to.setParent(root);
                            stmtTreeObjects.put(gr.getId(), to);
                            allGroup.getTypes().clear();
                        } else {
                            String parentString = gr.getParent();
                            Integer parentId = new Integer(parentString);
                            StmtTreeObject parentTreeObject = (StmtTreeObject)stmtTreeObjects.get(parentId);
                            StmtGroup parentGroup = allGroupsList.get(parentId);
                            if (parentTreeObject != null) {
                                to.setParent(parentTreeObject);
                                parentTreeObject.addChild(to);
                            }
                            if (parentGroup != null && gr.getTypes() != null) {
                                Set typesSet = gr.getTypes();
                                for (StmtType stmtType : typesSet) {
                                    parentGroup.addType(stmtType);
                                }
                            }
                        }
                        stmtTreeObjects.put(gr.getId(), to);
                        groups.put(gr.getName(), gr);
                        allGroup.getTypes().addAll(gr.getTypes());
                    }
                }
                ++k;
            }
        }
        return root;
    }
}

