/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ui;

import java.util.ArrayList;

public class StmtTreeObject {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private String name;
    private StmtTreeObject parent;
    private ArrayList children;
    private String stmtId;

    public StmtTreeObject(String name) {
        this.name = name;
        this.children = new ArrayList();
    }

    public String getName() {
        return this.name;
    }

    public void setParent(StmtTreeObject parent) {
        this.parent = parent;
    }

    public StmtTreeObject getParent() {
        return this.parent;
    }

    public void addChild(StmtTreeObject child) {
        this.children.add(child);
        child.setParent(this);
    }

    public void removeChild(StmtTreeObject child) {
        this.children.remove(child);
        child.setParent(null);
    }

    public StmtTreeObject[] getChildren() {
        return this.children.toArray(new StmtTreeObject[this.children.size()]);
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public String toString() {
        return this.getName();
    }

    public void setStmtId(String stmtId) {
        this.stmtId = stmtId;
    }

    public String getStmtId() {
        return this.stmtId;
    }
}

