/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ui;

import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.gui.internal.Activator;
import com.ez.mainframe.gui.internal.Messages;
import com.ez.report.application.ui.PluginImageDescriptorsStore;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginImages {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(PluginImages.class);
    public static final IPath ICONS_PATH = new Path("icons");
    private static ImageRegistry fgImageRegistry = null;
    private static HashMap fgAvoidSWTErrorMap = null;
    private static final String COBOL = Messages.getString(PluginImages.class, "programType.1");
    private static final String PL1 = Messages.getString(PluginImages.class, "programType.2");
    private static final String NATURAL = Messages.getString(PluginImages.class, "programType.3");
    private static final String SMART_DB_IO_MODULE = Messages.getString(PluginImages.class, "programType.4");
    private static final String SMART_SCREEN_IO_MODULE = Messages.getString(PluginImages.class, "programType.5");
    private static final String SMART_SMART_SUBROUTINE = Messages.getString(PluginImages.class, "programType.6");
    private static final String CL = Messages.getString(PluginImages.class, "programType.7");
    private static final String ASSEMBLER = Messages.getString(PluginImages.class, "programType.8");
    private static final String ENTRY = Messages.getString(PluginImages.class, "programType.16");
    private static final String CSECT = Messages.getString(PluginImages.class, "programType.15");
    private static final String REXX = Messages.getString(PluginImages.class, "programType.9");
    private static final String ADS_PROCESS = Messages.getString(PluginImages.class, "programType.10");
    private static final String ADS_DIALOG = Messages.getString(PluginImages.class, "programType.11");
    private static final String ADS_Screen = Messages.getString(PluginImages.class, "programType.18");
    private static final String BMS_Screen = Messages.getString(PluginImages.class, "programType.19");
    private static final String NATURAL_MAP = Messages.getString(PluginImages.class, "programType.20");
    private static final String IMS_MAP = Messages.getString(PluginImages.class, "programType.21");
    private static final String SCL = Messages.getString(PluginImages.class, "programType.13");
    private static final String DDCL = Messages.getString(PluginImages.class, "programType.14");
    private static final String PRG = Messages.getString(PluginImages.class, "mf.resType.21");
    private static final String JCL_JOB = Messages.getString(PluginImages.class, "mf.resType.22");
    private static final String CICS_TRANSACTION = Messages.getString(PluginImages.class, "mf.resType.23");
    public static final String CA7_SCHEDULED = "ca7 scheduled";
    public static final String CA7_START = "ca7 start";
    public static final String CA7_END = "ca7 end";
    public static final String CA7_MIDDLE = "ca7 middle";
    public static final ImageDescriptor DESC_CA7_END = PluginImages.createFromKey("", "/wizard/JCLJob_End.png", "ca7 end");
    public static final ImageDescriptor DESC_CA7_START = PluginImages.createFromKey("", "/wizard/JCLJob_Start.png", "ca7 start");
    public static final ImageDescriptor DESC_CA7_MIDDLE = PluginImages.createFromKey("", "/wizard/JCLJob_Middle.png", "ca7 middle");
    public static final ImageDescriptor DESC_CA7_SCHEDULED = PluginImages.createFromKey("", "/wizard/JCLJob_Scheduled.png", "ca7 scheduled");
    public static final ImageDescriptor DESC_COBOL = PluginImages.createFromKey("", "/wizard/Co.png", COBOL);
    public static final ImageDescriptor DESC_PL1 = PluginImages.createFromKey("", "/wizard/Pl1.png", PL1);
    public static final ImageDescriptor DESC_NATURAL = PluginImages.createFromKey("", "/wizard/Nat.png", NATURAL);
    public static final ImageDescriptor DESC_SMART_DB_IO_MODULE = PluginImages.createFromKey("", "/wizard/Dio.png", SMART_DB_IO_MODULE);
    public static final ImageDescriptor DESC_SMART_SCREEN_IO_MODULE = PluginImages.createFromKey("", "/wizard/Sio.png", SMART_SCREEN_IO_MODULE);
    public static final ImageDescriptor DESC_SMART_SMART_SUBROUTINE = PluginImages.createFromKey("", "/wizard/Subr.png", SMART_SMART_SUBROUTINE);
    public static final ImageDescriptor DESC_CL = PluginImages.createFromKey("", "/wizard/CL.png", CL);
    public static final ImageDescriptor DESC_ASSEMBLER = PluginImages.createFromKey("", "/wizard/As.png", ASSEMBLER);
    public static final ImageDescriptor DESC_ASM_ENTRY = PluginImages.createFromKey("", "/wizard/Entry.png", ENTRY);
    public static final ImageDescriptor DESC_ASM_CSECT = PluginImages.createFromKey("", "/wizard/Csect.png", CSECT);
    public static final ImageDescriptor DESC_REXX = PluginImages.createFromKey("", "/wizard/Rex.png", REXX);
    public static final ImageDescriptor DESC_ADS_PROCESS = PluginImages.createFromKey("", "/wizard/AP.png", ADS_PROCESS);
    public static final ImageDescriptor DESC_ADS_DIALOG = PluginImages.createFromKey("", "/wizard/AD.png", ADS_DIALOG);
    public static final ImageDescriptor DESC_SCL = PluginImages.createFromKey("", "/wizard/Scl.png", SCL);
    public static final ImageDescriptor DESC_DDCL = PluginImages.createFromKey("", "/wizard/Ddcl.png", DDCL);
    public static final ImageDescriptor DESC_UNDEF = PluginImages.createFromKey("", "/wizard/ND.png", "UNDEF");
    public static final ImageDescriptor DESC_PDS = PluginImages.createFromKey("", "/wizard/PM.png", "PDS(MVS)");
    public static final ImageDescriptor DESC_ENDEVOR = PluginImages.createFromKey("", "/wizard/En.png", "Endevor");
    public static final ImageDescriptor DESC_PDS_CONTROLM = PluginImages.createFromKey("", "/wizard/CM.png", "PDS(MVS)_CONTROLM");
    public static final ImageDescriptor DESC_NATURAL_LIB = PluginImages.createFromKey("", "/wizard/NaL.png", "NATURAL");
    public static final ImageDescriptor DESC_LIBRARIAN = PluginImages.createFromKey("", "/wizard/lib.png", "LIBRARIAN");
    public static final ImageDescriptor DESC_ADS = PluginImages.createFromKey("", "/wizard/ADs.png", ADS_Screen);
    public static final ImageDescriptor DESC_BMS = PluginImages.createFromKey("", "/wizard/bms.png", BMS_Screen);
    public static final ImageDescriptor DESC_NATURAL_MAP = PluginImages.createFromKey("", "/wizard/Nat.png", NATURAL_MAP);
    public static final ImageDescriptor DESC_IMS_MAP = PluginImages.createFromKey("", "/wizard/imsdb_map.png", IMS_MAP);
    public static final ImageDescriptor DESC_PRG = PluginImages.createFromKey("", "/wizard/Prg.png", PRG);
    public static final ImageDescriptor DESC_JCL_JOB = PluginImages.createFromKey("", "/wizard/Jcl.png", JCL_JOB);
    public static final ImageDescriptor DESC_CICS_TRANSACTION = PluginImages.createFromKey("", "/wizard/Cics.png", CICS_TRANSACTION);
    public static final String IMS_DATABASE = Messages.getString(PluginImages.class, "ims.resType.18");
    public static final String IMS_TERMINAL = Messages.getString(PluginImages.class, "ims.resType.19");
    public static final String IMS_TRANSCATION = Messages.getString(PluginImages.class, "ims.resType.20");
    public static final String GENERIC_TRANSCATION = Messages.getString(PluginImages.class, "genTran.resType.219");
    public static final String GENERIC_MAP = Messages.getString(PluginImages.class, "genMap.resType.220");
    public static final ImageDescriptor DESC_IMS_DATABASE = PluginImages.createFromKey("", "/wizard/db.png", IMS_DATABASE);
    public static final ImageDescriptor DESC_IMS_TERMINAL = PluginImages.createFromKey("", "/wizard/trm.png", IMS_TERMINAL);
    public static final ImageDescriptor DESC_IMS_TRANSACTION = PluginImages.createFromKey("", "/wizard/TerTrans.png", IMS_TRANSCATION);
    public static final ImageDescriptor DESC_GEN_TRANSACTION = PluginImages.createFromKey("", "/wizard/TransactionGeneric.png", GENERIC_TRANSCATION);
    static final ImageDescriptor DESC_DDCL_APPLICATION = PluginImages.createFromKey("", "/wizard/Application.png", Utils.getExternalizedType4DDCLComponent((Integer)25));
    static final ImageDescriptor DESC_DDCL_COMPONENT = PluginImages.createFromKey("", "/wizard/Component.png", Utils.getExternalizedType4DDCLComponent((Integer)11));
    static final ImageDescriptor DESC_DDCL_EXCHANGE = PluginImages.createFromKey("", "/wizard/Exchange.png", Utils.getExternalizedType4DDCLComponent((Integer)16));
    static final ImageDescriptor DESC_DDCL_DIALOGUE = PluginImages.createFromKey("", "/wizard/Dialogue.png", Utils.getExternalizedType4DDCLComponent((Integer)26));
    static final ImageDescriptor DESC_DDCL_REPORT_PROGRAM = PluginImages.createFromKey("", "/wizard/ReportProgram.png", Utils.getExternalizedType4DDCLComponent((Integer)27));
    static final ImageDescriptor DESC_DDCL_BATCH_PROGRAM = PluginImages.createFromKey("", "/wizard/BatchProgram.png", Utils.getExternalizedType4DDCLComponent((Integer)28));
    static final ImageDescriptor DESC_DDCL_FILE = PluginImages.createFromKey("", "/wizard/File.png", Utils.getExternalizedType4DDCLComponent((Integer)12));
    static final ImageDescriptor DESC_DDCL_MODULE = PluginImages.createFromKey("", "/wizard/Module.png", Utils.getExternalizedType4DDCLComponent((Integer)4));
    static final ImageDescriptor DESC_DDCL_RECORD = PluginImages.createFromKey("", "/wizard/Record.png", Utils.getExternalizedType4DDCLComponent((Integer)3));
    static final ImageDescriptor DESC_DDCL_RECORD_GROUP = PluginImages.createFromKey("", "/wizard/Group.png", Utils.getExternalizedType4DDCLComponent((Integer)29));
    static final ImageDescriptor DESC_DDCL_SET = PluginImages.createFromKey("", "/wizard/Set.png", Utils.getExternalizedType4DDCLComponent((Integer)10));
    static final ImageDescriptor DESC_DDCL_TPSERVICE = PluginImages.createFromKey("", "/wizard/TPService.png", Utils.getExternalizedType4DDCLComponent((Integer)24));
    static final ImageDescriptor DESC_DDCL_SCREEN = PluginImages.createFromKey("", "/wizard/Screen.png", Utils.getExternalizedType4DDCLComponent((Integer)14));
    public static final String TRANSACTION = Messages.getString(PluginImages.class, "transaction.resType");
    static final ImageDescriptor DESC_TRANSACTION = PluginImages.createFromKey("", "/wizard/Transaction.png", TRANSACTION);
    public static final String SAPIENS_FORM = "SAPIENS_Form";
    public static final String SAPIENS_RULESET = "SAPIENS_Ruleset";
    public static final String SAPIENS_PROGRAM = "SAPIENS_Program";
    public static final String SAPIENS_PHYSICAL_DB_TABLE = "SAPIENS_PhysicalDBTable";
    public static final String SAPIENS_QUERY = "SAPIENS_Query";
    public static final String SAPIENS_OUTPUT_FORM = "SAPIENS_OutputForm";
    public static final String SAPIENS_OPERATION = "SAPIENS_Operation";
    public static final String SAPIENS_MENU_OPTION = "SAPIENS_MenuOption";
    public static final String SAPIENS_CLASS = "SAPIENS_Class";
    static final ImageDescriptor DESC_SAPIENS_FORM = PluginImages.createFromKey("", "/wizard/SAPIENS_Form.png", "SAPIENS_Form");
    static final ImageDescriptor DESC_SAPIENS_CLASS = PluginImages.createFromKey("", "/wizard/SAPIENS_Class.png", "SAPIENS_Class");
    static final ImageDescriptor DESC_SAPIENS_MENUOPTION = PluginImages.createFromKey("", "/wizard/SAPIENS_MenuOptions.png", "SAPIENS_MenuOption");
    static final ImageDescriptor DESC_SAPIENS_OPERATION = PluginImages.createFromKey("", "/wizard/SAPIENS_Operation.png", "SAPIENS_Operation");
    static final ImageDescriptor DESC_SAPIENS_OUTPUTFORM = PluginImages.createFromKey("", "/wizard/SAPIENS_OutputForm.png", "SAPIENS_OutputForm");
    static final ImageDescriptor DESC_SAPIENS_QUERY = PluginImages.createFromKey("", "/wizard/SAPIENS_Query.png", "SAPIENS_Query");
    static final ImageDescriptor DESC_SAPIENS_Table = PluginImages.createFromKey("", "/wizard/SAPIENS_PhysicalDBTable.png", "SAPIENS_PhysicalDBTable");
    static final ImageDescriptor DESC_SAPIENS_PROGRAM = PluginImages.createFromKey("", "/wizard/SAPIENS_Program.png", "SAPIENS_Program");
    static final ImageDescriptor DESC_SAPIENS_RULESET = PluginImages.createFromKey("", "/wizard/SAPIENS_Ruleset.png", "SAPIENS_Ruleset");
    public static final String IMS_DATABASE_UNKNOWN = Messages.getString(PluginImages.class, "ims.dbType.0");
    public static final String IMS_DATABASE_FULL_FUNCTION = Messages.getString(PluginImages.class, "ims.dbType.1");
    public static final String IMS_DATABASE_FAST_PATH = Messages.getString(PluginImages.class, "ims.dbType.2");
    public static final String IMS_DATABASE_FILE_ACCESS = Messages.getString(PluginImages.class, "ims.dbType.3");
    public static final String IMS_DATABASE_LOGIC = Messages.getString(PluginImages.class, "ims.dbType.4");
    public static final ImageDescriptor DESC_IMS_DATABASE_FULL_FUNCTION = PluginImages.createFromKey("", "/wizard/imsDB2.png", IMS_DATABASE_FULL_FUNCTION);
    public static final ImageDescriptor DESC_IMS_DATABASE_FAST_PATH = PluginImages.createFromKey("", "/wizard/imsDB1.png", IMS_DATABASE_FAST_PATH);
    public static final ImageDescriptor DESC_IMS_DATABASE_FILE_ACCESS = PluginImages.createFromKey("", "/wizard/imsDB4.png", IMS_DATABASE_FILE_ACCESS);
    public static final ImageDescriptor DESC_IMS_DATABASE_LOGIC = PluginImages.createFromKey("", "/wizard/imsDB3.png", IMS_DATABASE_LOGIC);
    public static final ImageDescriptor DESC_IMS_DATABASE_UNKNOWN = PluginImages.createFromKey("", "/wizard/imsDB5.png", IMS_DATABASE_UNKNOWN);

    public static ImageDescriptor getDescriptor(int kind) {
        return PluginImages.getDescriptor(kind, false);
    }

    public static ImageDescriptor getDescriptor(int kind, boolean notConsiderChildren) {
        if (notConsiderChildren && (kind == 15 || kind == 16)) {
            kind = 8;
        }
        ImageDescriptor desc = (ImageDescriptor)PluginImageDescriptorsStore.getPluginImagesStore().getObject(kind);
        return desc;
    }

    public static ImageDescriptor getDescriptor4Library(Integer type) {
        ImageDescriptor desc = (ImageDescriptor)PluginImageDescriptorsStore.getPluginImagesStore().getObject(type, "LIBRARY_TYPE");
        if (desc == null) {
            L.warn("search for a librarian type in generic! type={}", (Object)type);
            desc = PluginImages.getDescriptor(type);
        }
        return desc;
    }

    private static ImageDescriptor create(String prefix, String name, boolean useMissingImageDescriptor) {
        IPath path = ICONS_PATH.append(prefix).append(name);
        return PluginImages.createImageDescriptor(Activator.getDefault().getBundle(), path, useMissingImageDescriptor);
    }

    private static ImageDescriptor createFromKey(String prefix, String name, String key) {
        ImageDescriptor result = PluginImages.create(prefix, name, true);
        if (fgAvoidSWTErrorMap == null) {
            fgAvoidSWTErrorMap = new HashMap();
        }
        fgAvoidSWTErrorMap.put(key, result);
        if (fgImageRegistry != null) {
            L.info("Image registry already defined");
        }
        return result;
    }

    public static ImageDescriptor createImageDescriptor(Bundle bundle, IPath path, boolean useMissingImageDescriptor) {
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        if (url != null) {
            return ImageDescriptor.createFromURL((URL)url);
        }
        if (useMissingImageDescriptor) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
        return null;
    }

    public static ImageDescriptor getDescriptor(String key) {
        if (fgImageRegistry == null) {
            return (ImageDescriptor)fgAvoidSWTErrorMap.get(key);
        }
        return PluginImages.getImageRegistry().getDescriptor(key);
    }

    public static ImageRegistry getImageRegistry() {
        if (fgImageRegistry == null) {
            fgImageRegistry = new ImageRegistry(Display.getDefault());
            for (String key : fgAvoidSWTErrorMap.keySet()) {
                fgImageRegistry.put(key, (ImageDescriptor)fgAvoidSWTErrorMap.get(key));
            }
            fgAvoidSWTErrorMap = null;
        }
        return fgImageRegistry;
    }

    public static Image get(String key) {
        return PluginImages.getImageRegistry().get(key);
    }

    public static String getKindLikeString(int kind) {
        return null;
    }

    public static ImageDescriptor getDescriptor4IMS(Integer type) {
        ImageDescriptor desc = (ImageDescriptor)PluginImageDescriptorsStore.getPluginImagesStore().getObject(type, "IMS_TYPE");
        if (desc == null) {
            L.warn("search for a IMS unknown type: {}", (Object)type);
            PluginImageDescriptorsStore.getPluginImagesStore().getObject(-1, "IMS_TYPE");
        }
        return desc;
    }

    public static ImageDescriptor getDescriptor4Transaction(Integer type) {
        ImageDescriptor desc = (ImageDescriptor)PluginImageDescriptorsStore.getPluginImagesStore().getObject(type, "TRANSACTION_TYPE");
        if (desc == null) {
            L.warn("search for a IMS unknown type: {}", (Object)type);
            desc = (ImageDescriptor)PluginImageDescriptorsStore.getPluginImagesStore().getObject(-1, "TRANSACTION_TYPE");
        }
        return desc;
    }

    public static ImageDescriptor getImageDescType4DDCLElements(Integer type) {
        ImageDescriptor desc = (ImageDescriptor)PluginImageDescriptorsStore.getPluginImagesStore().getObject(type, "DDCL_ELEMENTS");
        return desc;
    }

    public static ImageDescriptor getDescriptor4IMSDatabase(Integer type) {
        ImageDescriptor desc = (ImageDescriptor)PluginImageDescriptorsStore.getPluginImagesStore().getObject(type, "IMS_DATABASE_TYPE");
        if (desc == null) {
            L.warn("search for a IMS unknown type: {}", (Object)type);
            PluginImageDescriptorsStore.getPluginImagesStore().getObject(-1, "IMS_DATABASE_TYPE");
        }
        return desc;
    }
}

