/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.ui;

import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.widgets.Table;

public final class ColumnResizer
extends ControlAdapter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private int _lastWidth;
    private final int[] _cols;
    private final Table _table;

    public ColumnResizer(Table t) {
        this._table = t;
        this._cols = new int[this._table.getColumnCount()];
        int i = 0;
        while (i < this._cols.length) {
            this._cols[i] = 0;
            ++i;
        }
    }

    public ColumnResizer(Table t, int[] cols) {
        if (cols.length != t.getColumnCount()) {
            throw new IllegalArgumentException("mismatched column counts");
        }
        this._table = t;
        this._cols = cols;
    }

    public void controlResized(ControlEvent e) {
        int width = this._table.getBounds().width;
        if (width == this._lastWidth) {
            return;
        }
        int autoWidth = this.autoWidth(width);
        boolean allAutos = true;
        int i = 0;
        while (i < this._cols.length) {
            this._table.getColumn(i);
            int reqColWidth = this._cols[i];
            int colWidth = reqColWidth == 0 ? autoWidth : reqColWidth;
            this._table.getColumn(i).setWidth(colWidth);
            allAutos = allAutos && reqColWidth == 0;
            ++i;
        }
        if (allAutos) {
            this._table.getHorizontalBar().setVisible(false);
        }
        this._lastWidth = width;
    }

    private int autoWidth(int available) {
        int required = 0;
        int nAutos = 0;
        int i = 0;
        while (i < this._cols.length) {
            if (this._cols[i] == 0) {
                ++nAutos;
            }
            required += this._cols[i];
            ++i;
        }
        return Math.max(0, available - required) / nAutos;
    }
}

