/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.filters;

import com.ez.internal.analysis.config.inputs.EZSourceProjectInputType;
import com.ez.mainframe.filters.MultipleMainframeProjectFilter;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.report.application.utils.SharedResourcesUtils;
import java.util.Collection;

public class SharedResourcesAnalysesFilter
extends MultipleMainframeProjectFilter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    public boolean checkAnalysisAvailability(Collection inputs) {
        boolean ret = false;
        int projectCount = this.countProjects(inputs);
        if (projectCount == 1 && projectCount == inputs.size() && SharedResourcesUtils.useApplications().booleanValue()) {
            ret = this.checkProjectsDefinition(inputs);
            if (ret) {
                ret = this.checkParameters(inputs);
            }
        } else if (projectCount > 1 && projectCount == inputs.size()) {
            boolean hasVMEPrj = false;
            boolean hasZOSPrj = false;
            for (EZSourceProjectInputType inputProject : inputs) {
                ProjectInfo ezsourceProjectInfo = (ProjectInfo)inputProject.getProperty("PROJECT_INFO");
                if (ezsourceProjectInfo.isVME()) {
                    hasVMEPrj = true;
                }
                if (ezsourceProjectInfo.isZOS()) {
                    hasZOSPrj = true;
                }
                if (hasVMEPrj && hasZOSPrj) break;
            }
            ret = !hasVMEPrj || !hasZOSPrj;
        }
        return ret;
    }
}

