/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.application.event;

import com.ez.report.application.event.ErrorEvent;
import com.ez.report.application.event.ErrorEventListener;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;

public class ErrorMessage {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private Label errLbl;
    protected Display display = Display.getDefault();
    protected final Color redColor = new Color((Device)this.display, 255, 0, 0);
    ErrorEventListener listener;
    private Set messSet = new HashSet();
    public static final String NO_ERROR_MESSAGE = "";
    private String lastMsg = null;

    public ErrorMessage(Composite parent, int style) {
        this.errLbl = new Label(parent, style);
        this.errLbl.setForeground(this.redColor);
        this.errLbl.setText(NO_ERROR_MESSAGE);
        this.messSet.add(NO_ERROR_MESSAGE);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.errLbl.setLayoutData((Object)data);
        this.errLbl.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ErrorMessage.this.widgetDisposed(e);
            }
        });
    }

    void widgetDisposed(DisposeEvent e) {
        this.redColor.dispose();
    }

    public void notify(String msg) {
        if (!this.messSet.contains(msg)) {
            this.messSet.add(msg);
        }
        this.lastMsg = msg;
        this.errLbl.setText(msg);
        ErrorEvent errev = new ErrorEvent(this, msg);
        if (this.listener != null) {
            this.listener.errorEventHappend(errev);
        }
    }

    public void remove(String mes) {
        if (this.messSet.contains(mes)) {
            this.messSet.remove(mes);
        }
        if (this.messSet.size() > 1) {
            for (String msg : this.messSet) {
                if (msg.equalsIgnoreCase(NO_ERROR_MESSAGE)) continue;
                this.lastMsg = msg;
                this.errLbl.setText(msg);
                ErrorEvent errev = new ErrorEvent(this, msg);
                if (this.listener != null) {
                    this.listener.errorEventHappend(errev);
                }
                break;
            }
        } else {
            this.lastMsg = NO_ERROR_MESSAGE;
            this.errLbl.setText(NO_ERROR_MESSAGE);
            ErrorEvent errev = new ErrorEvent(this, NO_ERROR_MESSAGE);
            if (this.listener != null) {
                this.listener.errorEventHappend(errev);
            }
        }
    }

    public void addErrorListener(ErrorEventListener listener) {
        this.listener = listener;
    }

    public void removeErrorListener() {
        this.listener = null;
    }

    public String getMessage() {
        return this.lastMsg;
    }
}

