/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.gui.wizard;

import com.ez.common.ui.listselection.Listable;
import com.ez.mainframe.gui.internal.Messages;
import com.ez.mainframe.gui.utils.Utils;
import com.ez.mainframe.model.Direction;
import com.ez.report.application.ui.wizard.SelectProgramsPage;
import com.ez.workspace.preferences.WorkspacePrefUtils;
import java.util.HashMap;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class InputsWithSettingsPage<T extends Listable>
extends SelectProgramsPage<Listable> {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2024.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private boolean showSelectDirection = true;
    private boolean showLimitCg = true;
    private boolean showLimitResources = false;
    protected Button backwardButton;
    protected Button forwardButton;
    private Button bothButton;
    private Button limitCheckboxButton;
    private Button limitResourcesButton;
    private Text thresholdLimit;
    private static final String errorMsg = Messages.getString(InputsWithSettingsPage.class, "level.thresold.error");
    private String limitGroupText = null;
    private String limitButtonText = null;
    private String directionGroupText = null;

    public InputsWithSettingsPage(String pageName, boolean showSelectDirection, boolean showLimitCg) {
        super(pageName);
        this.showSelectDirection = showSelectDirection;
        this.showLimitCg = showLimitCg;
        this.useFilters = true;
    }

    public InputsWithSettingsPage(String pageName, boolean showSelectDirection, boolean showLimitCg, boolean showLimitResources) {
        this(pageName, showSelectDirection, showLimitCg);
        this.showLimitResources = showLimitResources;
    }

    @Override
    protected void createContent(Composite composite) {
        super.createContent(composite);
        ChoiceSelection cs = new ChoiceSelection();
        Composite fakeParent = new Composite(composite, composite.getStyle());
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1024;
        fakeParent.setLayoutData((Object)data);
        GridLayout gl = new GridLayout(2, false);
        gl.marginRight = 10;
        gl.marginLeft = 50;
        fakeParent.setLayout((Layout)gl);
        Composite fakeParent2 = new Composite(fakeParent, fakeParent.getStyle());
        GridData data2 = new GridData();
        data2.verticalAlignment = 1024;
        fakeParent2.setLayoutData((Object)data2);
        GridLayout gl2 = new GridLayout();
        gl2.verticalSpacing = 20;
        fakeParent2.setLayout((Layout)gl2);
        this.createAllowProgramsGroup(fakeParent2, cs);
        if (this.showSelectDirection || this.showLimitCg) {
            this.createDirectionGroup(fakeParent2, cs);
        }
        if (this.showLimitResources) {
            this.createRestrictionsGroup(fakeParent, cs);
        }
        composite.getShell().setMinimumSize(700, 500);
    }

    protected void createAllowProgramsGroup(Composite fakeParent, ChoiceSelection cs) {
    }

    protected void createRestrictionsGroup(Composite parent, ChoiceSelection cs) {
        Group limitGroup = new Group(parent, parent.getStyle());
        if (this.limitGroupText != null) {
            limitGroup.setText(this.limitGroupText);
        } else {
            limitGroup.setText(Messages.getString(InputsWithSettingsPage.class, "limit.group.txt"));
        }
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 131072;
        data.verticalAlignment = 128;
        data.minimumWidth = 120;
        limitGroup.setLayoutData((Object)data);
        FormLayout fl = new FormLayout();
        limitGroup.setLayout((Layout)fl);
        IPreferenceStore store = WorkspacePrefUtils.getPreferenceStore();
        boolean value = store.getBoolean("callgraphWithoutResources");
        this.limitResourcesButton = new Button((Composite)limitGroup, 32);
        if (this.limitButtonText != null) {
            this.limitResourcesButton.setText(this.limitButtonText);
        } else {
            this.limitResourcesButton.setText(Messages.getString(InputsWithSettingsPage.class, "limit.resources.btn.txt"));
        }
        FormData fdata2 = new FormData();
        fdata2.top = new FormAttachment((Control)this.limitCheckboxButton, 15, 16384);
        this.limitResourcesButton.setLayoutData((Object)fdata2);
        this.limitResourcesButton.addSelectionListener((SelectionListener)cs);
        this.limitResourcesButton.setSelection(value);
        this.wizard.set("graph without resources", value);
        final Group resGroup = new Group((Composite)limitGroup, 0);
        GridLayout gl = new GridLayout(4, false);
        resGroup.setLayout((Layout)gl);
        resGroup.setText("Resources");
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.limitResourcesButton, 5);
        resGroup.setLayoutData((Object)fd);
        resGroup.setEnabled(!value);
        for (final String lbl : Utils.resourceTypesLbl.keySet()) {
            Button button = new Button((Composite)resGroup, 32);
            button.setText(lbl);
            boolean isChecked = store.getBoolean(lbl);
            this.addResStateToWizard(lbl, isChecked);
            button.setSelection(isChecked);
            button.setEnabled(!value);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Button sourceBtn = (Button)e.getSource();
                    InputsWithSettingsPage.this.addResStateToWizard(lbl, sourceBtn.getSelection());
                }
            });
        }
        this.limitResourcesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                resGroup.setEnabled(!InputsWithSettingsPage.this.limitResourcesButton.getSelection());
                Control[] controlArray = resGroup.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control c = controlArray[n2];
                    c.setEnabled(!InputsWithSettingsPage.this.limitResourcesButton.getSelection());
                    ++n2;
                }
            }
        });
    }

    private void addResStateToWizard(String btnLbl, boolean btnState) {
        HashMap<String, Boolean> states = this.wizard.getMap("graph resources checked or not");
        if (states == null) {
            states = new HashMap<String, Boolean>();
            this.wizard.set("graph resources checked or not", states);
        }
        states.put(btnLbl, btnState);
    }

    protected void createLimitGroup(Composite comp, ChoiceSelection cs) {
        Label sep = null;
        if (this.showSelectDirection) {
            sep = new Label(comp, 258);
            sep.setAlignment(16384);
            FormData fdata = new FormData();
            fdata.left = new FormAttachment(0, 0);
            fdata.right = new FormAttachment(100, 0);
            fdata.top = new FormAttachment((Control)comp, 10);
            sep.setLayoutData((Object)fdata);
        }
        IPreferenceStore store = WorkspacePrefUtils.getPreferenceStore();
        int levelLimit = store.getInt("callgraphLimitExceed");
        boolean isLimited = store.getBoolean("callgraphLevelsLimitedPreference");
        this.limitCheckboxButton = new Button(comp, 32);
        if (this.limitButtonText != null) {
            this.limitCheckboxButton.setText(this.limitButtonText);
        } else {
            this.limitCheckboxButton.setText(Messages.getString(InputsWithSettingsPage.class, "limit.cg.btn.txt"));
        }
        FormData fdata = new FormData();
        fdata.top = new FormAttachment((Control)(sep != null ? sep : comp), 15);
        this.limitCheckboxButton.setLayoutData((Object)fdata);
        this.limitCheckboxButton.addSelectionListener((SelectionListener)cs);
        this.limitCheckboxButton.setSelection(isLimited);
        this.wizard.set("is graph limited", isLimited);
        this.thresholdLimit = new Text(comp, 2048);
        this.thresholdLimit.setText("" + levelLimit);
        this.wizard.set("limit number for graph levels", isLimited ? Integer.valueOf(levelLimit) : null);
        fdata = new FormData();
        fdata.top = new FormAttachment((Control)(sep != null ? sep : comp), 15);
        fdata.left = new FormAttachment((Control)this.limitCheckboxButton, 5);
        fdata.width = 280;
        this.thresholdLimit.setLayoutData((Object)fdata);
        this.thresholdLimit.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputsWithSettingsPage.this.catchThresholdLimit();
                InputsWithSettingsPage.this.setPageComplete(InputsWithSettingsPage.this.isPageComplete());
            }
        });
        this.thresholdLimit.setEnabled(isLimited);
    }

    protected void createDirectionGroup(Composite parent, ChoiceSelection cs) {
        Group directionGroup = new Group(parent, parent.getStyle());
        if (this.directionGroupText != null) {
            directionGroup.setText(this.directionGroupText);
        } else {
            directionGroup.setText(Messages.getString(InputsWithSettingsPage.class, "direction.group.txt"));
        }
        GridData data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.horizontalAlignment = 16384;
        data.verticalAlignment = 1024;
        directionGroup.setLayoutData((Object)data);
        GridLayout gl = new GridLayout(3, true);
        gl.horizontalSpacing = 20;
        directionGroup.setLayout((Layout)gl);
        if (this.showSelectDirection) {
            this.forwardButton = new Button((Composite)directionGroup, 16);
            this.forwardButton.setText(Messages.getString(InputsWithSettingsPage.class, "forward.btn.txt"));
            data = new GridData();
            data.grabExcessHorizontalSpace = true;
            data.grabExcessVerticalSpace = true;
            data.verticalAlignment = 1024;
            data.minimumWidth = 120;
            this.forwardButton.setLayoutData((Object)data);
            this.forwardButton.addSelectionListener((SelectionListener)cs);
            this.forwardButton.setData((Object)Direction.FORWARD);
            this.forwardButton.setSelection(true);
            this.wizard.set("graph direction: forward or backward or both", Direction.FORWARD);
            this.backwardButton = new Button((Composite)directionGroup, 16);
            this.backwardButton.setText(Messages.getString(InputsWithSettingsPage.class, "backward.btn.txt"));
            data = new GridData();
            data.grabExcessHorizontalSpace = true;
            data.verticalAlignment = 1024;
            data.minimumWidth = 120;
            this.backwardButton.setLayoutData((Object)data);
            this.backwardButton.addSelectionListener((SelectionListener)cs);
            this.backwardButton.setData((Object)Direction.BACKWARD);
            this.backwardButton.setSelection(false);
            this.bothButton = new Button((Composite)directionGroup, 16);
            this.bothButton.setText(Messages.getString(InputsWithSettingsPage.class, "both.btn.txt"));
            data = new GridData();
            data.grabExcessHorizontalSpace = true;
            data.verticalAlignment = 1024;
            data.minimumWidth = 120;
            this.bothButton.setLayoutData((Object)data);
            this.bothButton.addSelectionListener((SelectionListener)cs);
            this.bothButton.setData((Object)Direction.BOTH);
            this.bothButton.setSelection(false);
        }
        if (this.showLimitCg) {
            Composite fakeGr = new Composite((Composite)directionGroup, parent.getStyle());
            data = new GridData();
            data.grabExcessHorizontalSpace = true;
            data.grabExcessVerticalSpace = true;
            data.horizontalSpan = 3;
            fakeGr.setLayoutData((Object)data);
            FormLayout fl = new FormLayout();
            fakeGr.setLayout((Layout)fl);
            this.createLimitGroup(fakeGr, cs);
        }
    }

    @Override
    public boolean isPageComplete() {
        boolean ret = super.isPageComplete();
        if (ret) {
            if (this.showSelectDirection && this.wizard.getValue("graph direction: forward or backward or both") == null) {
                ret = false;
            }
            if (ret && this.showLimitCg && Boolean.TRUE.equals(this.wizard.getValue("is graph limited")) && this.wizard.getValue("limit number for graph levels") == null) {
                ret = false;
            }
        }
        return ret;
    }

    public void setLimitGraphText(String limitGroupButtonText, String limitGraphLblText) {
        this.limitGroupText = limitGroupButtonText;
        this.limitButtonText = limitGraphLblText;
    }

    public void setDirectionGroupText(String directionGroupText) {
        this.directionGroupText = directionGroupText;
    }

    private void catchThresholdLimit() {
        block6: {
            String text = this.thresholdLimit.getText();
            Integer threshold = null;
            try {
                try {
                    threshold = Integer.valueOf(text);
                    if (threshold < 0) {
                        this.setErrorMessage(errorMsg);
                        break block6;
                    }
                    this.setErrorMessage(null);
                }
                catch (NumberFormatException numberFormatException) {
                    this.setErrorMessage(errorMsg);
                    this.wizard.set("limit number for graph levels", threshold);
                }
            }
            finally {
                this.wizard.set("limit number for graph levels", threshold);
            }
        }
    }

    protected class ChoiceSelection
    implements SelectionListener {
        protected ChoiceSelection() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Button b = (Button)e.getSource();
            if ((b.equals(InputsWithSettingsPage.this.backwardButton) || b.equals(InputsWithSettingsPage.this.forwardButton) || b.equals(InputsWithSettingsPage.this.bothButton)) && b.getSelection()) {
                Direction direction = (Direction)b.getData();
                InputsWithSettingsPage.this.wizard.set("graph direction: forward or backward or both", direction);
            }
            if (b.equals(InputsWithSettingsPage.this.limitCheckboxButton) && InputsWithSettingsPage.this.showLimitCg) {
                boolean isCgLimited = InputsWithSettingsPage.this.limitCheckboxButton.getSelection();
                InputsWithSettingsPage.this.wizard.set("is graph limited", isCgLimited);
                InputsWithSettingsPage.this.thresholdLimit.setEnabled(isCgLimited);
                if (isCgLimited) {
                    InputsWithSettingsPage.this.catchThresholdLimit();
                } else {
                    InputsWithSettingsPage.this.wizard.set("limit number for graph levels", null);
                    InputsWithSettingsPage.this.setErrorMessage(null);
                }
            }
            if (b.equals(InputsWithSettingsPage.this.limitResourcesButton)) {
                boolean isResourcesLimited = InputsWithSettingsPage.this.limitResourcesButton.getSelection();
                InputsWithSettingsPage.this.wizard.set("graph without resources", isResourcesLimited);
            }
            InputsWithSettingsPage.this.setPageComplete(InputsWithSettingsPage.this.isPageComplete());
        }
    }
}

