/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.gui.utils;

import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.LockType;
import com.ez.internal.analysis.config.context.AnalysisBrowserContext;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.analysis.config.inputs.EZSourceProjectInputType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.internal.utils.LogUtil;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.data.utils.CanceledException;
import com.ez.mainframe.editors.ContentEditorInput;
import com.ez.mainframe.editors.EZEditorUtil;
import com.ez.mainframe.editors.IEZSourceViewer;
import com.ez.mainframe.editors.IEditorMetadata;
import com.ez.mainframe.editors.aauto.AAutoEditor;
import com.ez.mainframe.editors.adsd.ADSDEditor;
import com.ez.mainframe.editors.adsmap.ADSMapEditor;
import com.ez.mainframe.editors.adsp.ADSProcessEditor;
import com.ez.mainframe.editors.assembler.AssemblerEditor;
import com.ez.mainframe.editors.bms.BMSEditor;
import com.ez.mainframe.editors.cobol.CobolEditor;
import com.ez.mainframe.editors.ddcl.DDCLEditor;
import com.ez.mainframe.editors.jcl.JCLEditor;
import com.ez.mainframe.editors.natural.NaturalEditor;
import com.ez.mainframe.editors.naturalmap.NaturalMapEditor;
import com.ez.mainframe.editors.pl1.PL1Editor;
import com.ez.mainframe.editors.scl.SCLEditor;
import com.ez.mainframe.gui.internal.Activator;
import com.ez.mainframe.gui.internal.Messages;
import com.ez.mainframe.gui.rdz.HookUtils;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.report.application.model.ApplicationInput;
import com.ez.report.application.ui.PluginImages;
import com.ez.workspace.analysis.EZAnalysisType;
import com.ez.workspace.analysis.EZInputFilter;
import com.ez.workspace.gotosource.IGoToSourceService;
import com.ez.workspace.gotosource.ReceiveContentCallback;
import com.ez.workspace.model.EZWorkspace;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.ibm.ad.oauth2.fileservice.FileAuthUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2024.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(Utils.class);
    @Deprecated
    public static String applicationsQuery = "select * from Applications order by ApplicationName";
    public static final String TRAN_TYPE = "TranUsageInfo";
    public static final String FILE_TYPE = "FileUsageInfo";
    public static final String SQL_TYPE = "SQLUsageInfo";
    public static final String MQM_TYPE = "MQManUsageInfo";
    public static final String MQ_TYPE = "MQQUsageInfo";
    public static final String IMSS_TYPE = "IMSSegmentUsageInfo";
    public static final String IMST_TYPE = "IMSTerminalUsageInfo";
    public static final String IMSTR_TYPE = "IMSTransactionUsageInfo";
    public static final String IMSMQ_TYPE = "IMSMqUsageInfo";
    public static final String IMSM_TYPE = "IMSMODUsageInfo";
    public static final String SCREEN_TYPE = "ScreenUsageInfo";
    public static final String ADABAS_TYPE = "AdabasFileUsageInfo";
    public static final String DATACOM_TYPE = "DatacomUsageInfo";
    public static final String DAL_TYPE = "DALUsageInfo";
    public static final String DBI_TYPE = "DBIUsageInfo";
    public static final String IDMSREC_TYPE = "IDMSRecordUsageInfo";
    public static final String IDMSSET_TYPE = "IDMSSetUsageInfo";
    public static Map<String, List<String>> resourceTypesLbl = new LinkedHashMap<String, List<String>>(){
        {
            this.put("SQL Table", new ArrayList<String>(){
                {
                    this.add(Utils.SQL_TYPE);
                }
            });
            this.put("CICS Transaction", new ArrayList<String>(){
                {
                    this.add(Utils.TRAN_TYPE);
                }
            });
            this.put("File", new ArrayList<String>(){
                {
                    this.add(Utils.FILE_TYPE);
                }
            });
            this.put("Map", new ArrayList<String>(){
                {
                    this.add(Utils.SCREEN_TYPE);
                }
            });
            this.put("MQ", new ArrayList<String>(){
                {
                    this.add(Utils.MQM_TYPE);
                    this.add(Utils.MQ_TYPE);
                }
            });
            this.put("IMS", new ArrayList<String>(){
                {
                    this.add(Utils.IMSS_TYPE);
                    this.add(Utils.IMST_TYPE);
                    this.add(Utils.IMSTR_TYPE);
                    this.add(Utils.IMSMQ_TYPE);
                    this.add(Utils.IMSM_TYPE);
                }
            });
            this.put("Adabas", new ArrayList<String>(){
                {
                    this.add(Utils.ADABAS_TYPE);
                }
            });
            this.put("Datacom", new ArrayList<String>(){
                {
                    this.add(Utils.DATACOM_TYPE);
                }
            });
            this.put("DAL", new ArrayList<String>(){
                {
                    this.add(Utils.DAL_TYPE);
                }
            });
            this.put("DBI Table", new ArrayList<String>(){
                {
                    this.add(Utils.DBI_TYPE);
                }
            });
            this.put("IDMS", new ArrayList<String>(){
                {
                    this.add(Utils.IDMSREC_TYPE);
                    this.add(Utils.IDMSSET_TYPE);
                }
            });
        }
    };

    public static IEditorPart openEditor(String resourcePath, int[] bounds, String editorId, String project) {
        return Utils.openEditor(resourcePath, bounds, null, editorId, project);
    }

    public static IEditorPart openEditor(final String resourcePath, final int[] bounds, int[] offsets, final String editorId, final String project) {
        L.debug("trying to open file from path: {} with editorId={}", (Object)resourcePath, (Object)editorId);
        if (resourcePath.isEmpty()) {
            String msg = Messages.getString(Utils.class, "dialog.nofile.msg");
            Utils.displayErrorMsg(msg, bounds, resourcePath);
            return null;
        }
        IEditorPart edPart = null;
        final IWorkbenchPage activePage = PlatformUI.getWorkbench().getWorkbenchWindows()[0].getActivePage();
        try {
            String toOpenEditor;
            String msg;
            block19: {
                IEditorDescriptor edDesc = IDE.getEditorDescriptor((String)resourcePath, (boolean)true);
                L.debug("editor descriptor for: {} is {}", (Object)resourcePath, (Object)edDesc);
                L.debug("bounds for {}: {}", (Object)resourcePath, (Object)Arrays.toString(bounds));
                msg = null;
                toOpenEditor = null;
                if (editorId != null && ("org.eclipse.ui.DefaultTextEditor".equals(edDesc.getId()) || "com.ibm.ftt.lpex.systemz.SystemzLpex".equals(edDesc.getId()) || "org.eclipse.ui.systemExternalEditor".equals(edDesc.getId()) || edDesc.getId().equals(editorId))) {
                    L.trace("trying to open file with an editor having editorId={}", (Object)editorId);
                    Collection viewSrcContributors = EZWorkspace.getInstance().getViewSourceContributors();
                    boolean notOpen = true;
                    if (viewSrcContributors != null) {
                        for (final IGoToSourceService goToService : viewSrcContributors) {
                            HashMap<String, Properties> map = new HashMap<String, Properties>();
                            map.put(resourcePath, new Properties());
                            if (!goToService.isEnableGoToSource(map)) continue;
                            notOpen = false;
                            String queryforVersion = goToService.getQueryForVersion();
                            if (queryforVersion != null) {
                                Utils.getFilesVersion(project, queryforVersion, map);
                            }
                            ReceiveContentCallback rc = new ReceiveContentCallback(){

                                public void receiveContent(String pathStr, IFile file, StringBuilder sb) {
                                    if (sb != null) {
                                        ContentEditorInput editorInput = new ContentEditorInput(sb.toString());
                                        String[] info = new String[]{project, resourcePath, FilenameUtils.getName((String)resourcePath), goToService.getFileDetails(resourcePath)};
                                        ((IEditorMetadata)editorInput).setInfo(info);
                                        Display.getDefault().syncExec(new Runnable((IEditorInput)editorInput, editorId, bounds){
                                            private final /* synthetic */ IEditorInput val$editorInput;
                                            private final /* synthetic */ String val$editorId;
                                            private final /* synthetic */ int[] val$bounds;
                                            {
                                                this.val$editorInput = iEditorInput;
                                                this.val$editorId = string;
                                                this.val$bounds = nArray;
                                            }

                                            @Override
                                            public void run() {
                                                try {
                                                    IEditorPart edPart = IDE.openEditor((IWorkbenchPage)activePage, (IEditorInput)this.val$editorInput, (String)this.val$editorId);
                                                    EZEditorUtil.jumpTo((IEditorPart)edPart, (int[])this.val$bounds);
                                                }
                                                catch (PartInitException e) {
                                                    L.error("exception at open editor when ReceiveContentCallback is used ", (Throwable)e);
                                                }
                                            }
                                        });
                                    }
                                }

                                public void onErrorOrCancel() {
                                    L.debug("exception when try to download source for editor");
                                }
                            };
                            goToService.openSource(rc, null);
                        }
                    }
                    if (notOpen) {
                        if (HookUtils.isRdzAdditionsAvailable() && HookUtils.isValitRemotePath(resourcePath)) {
                            try {
                                L.debug("opening remote editor");
                                if (bounds == null || bounds.length < 4) {
                                    if (bounds != null && bounds.length > 0) {
                                        HookUtils.openRemoteEditor((IProgressMonitor)new NullProgressMonitor(), project, resourcePath, bounds[0], 0, 0);
                                    } else {
                                        HookUtils.openRemoteEditor((IProgressMonitor)new NullProgressMonitor(), project, resourcePath);
                                    }
                                    break block19;
                                }
                                HookUtils.openRemoteEditor((IProgressMonitor)new NullProgressMonitor(), project, resourcePath, bounds[0], bounds[1], bounds[3]);
                            }
                            catch (CanceledException canceledException) {
                                L.info("Job canceled");
                            }
                        } else {
                            msg = Messages.getString(Utils.class, "openADeditor.jobname");
                            toOpenEditor = editorId;
                            L.debug("opening with AD  - {} editor", (Object)toOpenEditor);
                        }
                    }
                } else if (edDesc.getId() != null && edDesc.getId().startsWith("com.ibm.systemz.")) {
                    msg = Messages.getString(Utils.class, "openADeditor.jobname");
                    toOpenEditor = editorId;
                    L.debug("opening with AD {} editor (overwrite com.ibm.systemz editor {}  because source is not from mainframe)", (Object)toOpenEditor, (Object)edDesc.getId());
                } else {
                    msg = Messages.getString(Utils.class, "openDefaultEditor.jobname");
                    toOpenEditor = edDesc.getId();
                    L.debug("opening with {} editor", (Object)toOpenEditor);
                }
            }
            if (toOpenEditor != null) {
                String[] info = new String[]{project, resourcePath, FilenameUtils.getName((String)resourcePath), resourcePath};
                new OpenEditorJob(msg, resourcePath, info, bounds, offsets, toOpenEditor, activePage).schedule();
            }
        }
        catch (PartInitException e) {
            L.error("exception at open editor", (Throwable)e);
        }
        return edPart;
    }

    public static void getFilesVersion(String projectName, final String queryToRun, final Map<String, Properties> propMap) {
        IMFConnectionService service = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
        IMFProjectHandler ph = service.getProjectHandler(projectName, null);
        try {
            ph.executeWithLock(ph, new IMFRunnable(){

                public void run(EZSourceConnection conn, IProgressMonitor pmonitor) {
                    List<EZSourceDataType> ltypes = Arrays.asList(new EZSourceDataType[propMap.size()]);
                    Collections.fill(ltypes, EZSourceDataType.String);
                    String[][] results = conn.execNonTransactionalStoredProc(queryToRun, new String[0], ltypes, new ArrayList(propMap.keySet()));
                    if (results != null && results.length > 0) {
                        String[][] stringArray = results;
                        int n = results.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String[] result = stringArray[n2];
                            Properties prop = (Properties)propMap.get(result[0]);
                            prop.put("elm_version", String.format("%02d", Integer.valueOf(result[1])));
                            prop.put("elm_level", String.format("%02d", Integer.valueOf(result[2])));
                            ++n2;
                        }
                    }
                }
            }, LockType.Shared, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (InterruptedException | ExecutionException exception) {
            L.error("error when do query for version");
        }
    }

    private static void displayErrorMsg(String msg, int[] bounds, String resPath) {
        String dialogTitle = Messages.getString(Utils.class, "dialog.notfile.title");
        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)dialogTitle, (String)msg);
        L.error("Try to open a not existing file {} (bounds: {})", (Object)resPath, (Object)Arrays.toString(bounds));
    }

    public static String getEditorId(String editorType) {
        String edId = "ezeditor.id";
        if (editorType == null) {
            return edId;
        }
        int typeId = -1;
        try {
            typeId = Integer.parseInt(editorType);
        }
        catch (NumberFormatException nfe) {
            L.error("wrong format for editor type: {}", (Object)editorType, (Object)nfe);
        }
        if (typeId == 1) {
            edId = CobolEditor.COBOL_EDITOR_ID;
        } else if (typeId == 2) {
            edId = PL1Editor.PL1_EDITOR_ID;
        } else if (typeId == 3) {
            edId = NaturalEditor.NATURAL_EDITOR_ID;
        } else if (typeId == 22) {
            edId = JCLEditor.JCL_EDITOR_ID;
        } else if (typeId == 13 || typeId == 19) {
            edId = SCLEditor.SCL_EDITOR_ID;
        } else if (typeId == 14) {
            edId = DDCLEditor.DDCL_EDITOR_ID;
        } else if (typeId == 8 || typeId == 15 || typeId == 16) {
            edId = AssemblerEditor.ASSEMBLER_EDITOR_ID;
        } else if (typeId == 10) {
            edId = ADSProcessEditor.ADSP_EDITOR_ID;
        } else if (typeId == 11) {
            edId = ADSDEditor.ADSD_EDITOR_ID;
        } else if (typeId == 10095) {
            edId = ADSMapEditor.ADSMAP_EDITOR_ID;
        } else if (typeId == 10061) {
            edId = NaturalMapEditor.NATURALMAP_EDITOR_ID;
        } else if (typeId == 10006) {
            edId = BMSEditor.BMS_EDITOR_ID;
        } else if (typeId == 300 || typeId == 301) {
            edId = AAutoEditor.AAUTO_EDITOR_ID;
        }
        return edId;
    }

    public static ImageDescriptor getImageDescType(Integer type) {
        return Utils.getImageDescType(type, false);
    }

    public static ImageDescriptor getImageDescType(Integer type, boolean notConsiderChildren) {
        ImageDescriptor image_desc = PluginImages.getDescriptor(type, notConsiderChildren);
        return image_desc;
    }

    public static ImageDescriptor getImageDescType4IMS(Integer type) {
        ImageDescriptor image_desc = PluginImages.getDescriptor4IMS(type);
        return image_desc;
    }

    public static ImageDescriptor getImageDescType4Transaction(Integer resourceType) {
        ImageDescriptor image_desc = PluginImages.getDescriptor4Transaction(resourceType);
        return image_desc;
    }

    public static String getExternalizedType4Transaction(Integer type) {
        String desc = null;
        switch (type) {
            case 20: {
                desc = PluginImages.IMS_TRANSCATION;
                break;
            }
            case 219: {
                desc = PluginImages.GENERIC_TRANSCATION;
                break;
            }
            default: {
                desc = PluginImages.TRANSACTION;
            }
        }
        return desc;
    }

    public static ImageDescriptor getImageDescType4DDCLElements(Integer type) {
        ImageDescriptor imageDesc = PluginImages.getImageDescType4DDCLElements(type);
        return imageDesc;
    }

    public static String getExternalizedType4IMS(Integer type) {
        String desc = null;
        switch (type) {
            case 18: {
                desc = PluginImages.IMS_DATABASE;
                break;
            }
            case 19: {
                desc = PluginImages.IMS_TERMINAL;
                break;
            }
            default: {
                L.warn("search for a IMS unknown type: {}", (Object)type);
                desc = Messages.getString(Utils.class, "imsdb.generictype");
            }
        }
        return desc;
    }

    public static List<ApplicationInput> getAvailableApplications(EZSourceConnection bridge) {
        ArrayList<ApplicationInput> availableApps = new ArrayList<ApplicationInput>();
        String[][] applications = bridge.executeSQL(applicationsQuery);
        if (applications != null) {
            ApplicationInput inpt = null;
            int i = 0;
            while (i < applications.length) {
                inpt = new ApplicationInput(applications[i][0]);
                inpt.setListableName(applications[i][1]);
                availableApps.add(inpt);
                L.debug("{}", (Object)applications[i][0]);
                ++i;
            }
        }
        return availableApps;
    }

    public static List<ProjectInfo> computeInputProjectList(List<EZObjectType> objTypes) {
        ArrayList<ProjectInfo> inputProjects = null;
        if (objTypes != null) {
            inputProjects = new ArrayList<ProjectInfo>();
            for (EZObjectType objType : objTypes) {
                ProjectInfo pi;
                EZSourceProjectIDSg prjIdSg = (EZSourceProjectIDSg)objType.getEntID().getSegment(EZSourceProjectIDSg.class);
                if (prjIdSg == null || inputProjects.contains(pi = prjIdSg.getProjectInfo())) continue;
                inputProjects.add(pi);
            }
        }
        return inputProjects;
    }

    public static ImageDescriptor getImageDescType4IMSDatabase(Integer mappedType) {
        ImageDescriptor image_desc = PluginImages.getDescriptor4IMSDatabase(mappedType);
        return image_desc;
    }

    public static String getExternalizedType4IMSDatabase(Integer mappedType) {
        String desc = null;
        switch (mappedType) {
            case 4: {
                desc = PluginImages.IMS_DATABASE_LOGIC;
                break;
            }
            case 2: {
                desc = PluginImages.IMS_DATABASE_FAST_PATH;
                break;
            }
            case 3: {
                desc = PluginImages.IMS_DATABASE_FILE_ACCESS;
                break;
            }
            case 1: {
                desc = PluginImages.IMS_DATABASE_FULL_FUNCTION;
                break;
            }
            default: {
                L.info("search for a IMS unknown database type: {}", (Object)mappedType);
                desc = PluginImages.IMS_DATABASE_UNKNOWN;
            }
        }
        return desc;
    }

    public static int getMappedType4IMSDatabase(Integer dbType) {
        int desc = 0;
        switch (dbType) {
            case 13: {
                desc = 4;
                break;
            }
            case 5: 
            case 6: {
                desc = 2;
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                desc = 3;
                break;
            }
            case 0: {
                desc = 0;
                break;
            }
            default: {
                desc = 1;
            }
        }
        return desc;
    }

    public static String escapeMetaCharacters(String in) {
        if (in == null || in.indexOf(38) < 0) {
            return in;
        }
        int length = in.length();
        StringBuffer out = new StringBuffer(length + 1);
        int i = 0;
        while (i < length) {
            char c = in.charAt(i);
            if (c == '&') {
                out.append("&&");
            } else {
                out.append(c);
            }
            ++i;
        }
        return out.toString();
    }

    public static List<ProjectInfo> filterProjects(List<ProjectInfo> allProjects, EZAnalysisType analysisType) {
        ArrayList<ProjectInfo> filteredProjects = new ArrayList<ProjectInfo>();
        if (allProjects != null) {
            for (ProjectInfo pi : allProjects) {
                if (pi == null || pi.isEclipse()) continue;
                boolean canHandle = false;
                EZSourceProjectInputType prjInputType = new EZSourceProjectInputType();
                EZEntityID entity = new EZEntityID();
                prjInputType.setEntID(entity);
                entity.addSegment((EZSegment)new EZSourceProjectIDSg(pi));
                prjInputType.setName(pi.getName());
                prjInputType.addProperty("PROJECT_INFO", (Object)pi);
                prjInputType.setContext(AnalysisBrowserContext.class);
                ArrayList<EZSourceProjectInputType> list = new ArrayList<EZSourceProjectInputType>();
                list.add(prjInputType);
                if (analysisType.acceptsInputTypes(list)) {
                    EZInputFilter filter = analysisType.getInputFilterInstance();
                    canHandle = filter != null ? filter.checkAnalysisAvailability(list) : true;
                }
                if (!canHandle) continue;
                filteredProjects.add(pi);
            }
        }
        return filteredProjects;
    }

    private static class OpenEditorJob
    extends Job {
        String filePath = null;
        String[] info = null;
        int[] bounds = null;
        int[] offsets = null;
        String editorID = null;
        IWorkbenchPage activePage = null;

        public OpenEditorJob(String name, String resPath, String[] info, int[] bounds, int[] offsets, String editorId, IWorkbenchPage page) {
            super(name);
            this.filePath = resPath;
            this.info = info;
            this.bounds = bounds;
            this.offsets = offsets;
            this.editorID = editorId;
            this.activePage = page;
        }

        protected IStatus run(IProgressMonitor monitor) {
            FileAuthUtils.FileExtraContentConsumer consumer = null;
            try {
                consumer = (FileAuthUtils.FileExtraContentConsumer)FileAuthUtils.getFileContent((String)this.filePath, (boolean)true);
            }
            catch (Exception e) {
                String msg = Messages.getString(Utils.class, "openfile.error.message", new String[]{this.filePath});
                LogUtil.displayErrorMessage((Throwable)e, (String)msg, (Plugin)Activator.getDefault(), (boolean)true);
            }
            if (consumer != null && consumer.getContent() != null) {
                ContentEditorInput editorInput = new ContentEditorInput(consumer.getContent());
                if (this.info != null) {
                    ((IEditorMetadata)editorInput).setInfo(this.info);
                }
                ((IEditorMetadata)editorInput).hasExpanded(consumer.isExpanded());
                Display.getDefault().asyncExec(new Runnable((IEditorInput)editorInput){
                    private final /* synthetic */ IEditorInput val$editorInput;
                    {
                        this.val$editorInput = iEditorInput;
                    }

                    @Override
                    public void run() {
                        try {
                            IEditorPart edPart = IDE.openEditor((IWorkbenchPage)activePage, (IEditorInput)this.val$editorInput, (String)editorID);
                            if (bounds != null) {
                                EZEditorUtil.jumpTo((IEditorPart)edPart, (int[])bounds);
                            }
                            if (offsets != null && offsets.length > 1) {
                                if (edPart instanceof AbstractTextEditor) {
                                    ((AbstractTextEditor)edPart).selectAndReveal(offsets[0], offsets[1] - offsets[0]);
                                } else if (edPart instanceof IEZSourceViewer) {
                                    ((IEZSourceViewer)edPart).jumpTo(offsets[0]);
                                }
                            }
                        }
                        catch (PartInitException e) {
                            L.error("exception at open editor when ReceiveContentCallback is used ", (Throwable)e);
                        }
                    }
                });
                return Status.OK_STATUS;
            }
            L.info("no content received from FileService for file {}", (Object)this.filePath);
            String msg = Messages.getString(Utils.class, "openfile.nocontent.message", new String[]{this.filePath});
            LogUtil.displayErrorMessage(null, (String)msg, (Plugin)Activator.getDefault(), (boolean)false);
            return Status.CANCEL_STATUS;
        }
    }
}

