/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.gui.utils;

import com.ez.mainframe.data.utils.TextSelectionInFile;
import com.ez.mainframe.gui.internal.Messages;
import java.util.Collection;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.dialogs.SelectionDialog;

public class SelectGoToSourceInputDialog
extends SelectionDialog {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private Collection<TextSelectionInFile> inputs = null;
    private TableViewer viewer = null;
    private LinesComparator comparator = null;
    private String okButtonTxt = null;

    public SelectGoToSourceInputDialog(Shell parentShell, Collection<TextSelectionInFile> inputs, String dialogTitle, String dialogOkButton) {
        super(parentShell);
        this.inputs = inputs;
        this.okButtonTxt = dialogOkButton;
        SelectGoToSourceInputDialog.setDialogHelpAvailable((boolean)false);
        this.setHelpAvailable(false);
        if (dialogTitle == null || dialogTitle.isEmpty()) {
            dialogTitle = Messages.getString(SelectGoToSourceInputDialog.class, "page.title");
        }
        this.setTitle(dialogTitle);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        int w = 500;
        int h = 300;
        shell.setSize(w, h);
        Rectangle b = shell.getDisplay().getBounds();
        shell.setLocation((b.width - w) / 2, (b.height - h) / 2);
    }

    protected Control createDialogArea(Composite parent) {
        FormData fd = null;
        TableViewerColumn col = null;
        this.comparator = new LinesComparator();
        Composite area = new Composite(parent, 0);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        area.setLayoutData((Object)data);
        FormLayout fl = new FormLayout();
        fl.spacing = 5;
        area.setLayout((Layout)fl);
        Label info = new Label(area, 16384);
        info.setText(Messages.getString(SelectGoToSourceInputDialog.class, "dialog.label"));
        fd = new FormData();
        fd.top = new FormAttachment(0);
        fd.left = new FormAttachment(0);
        fd.right = new FormAttachment(100);
        info.setLayoutData((Object)fd);
        this.viewer = new TableViewer(area, 68356);
        fd = new FormData();
        fd.top = new FormAttachment((Control)info);
        fd.left = new FormAttachment(0);
        fd.right = new FormAttachment(100);
        fd.bottom = new FormAttachment(100);
        this.viewer.getControl().setLayoutData((Object)fd);
        col = this.createTableViewerColumn(Messages.getString(SelectGoToSourceInputDialog.class, "table.column.file"), 400, 0);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((TextSelectionInFile)element).getFileName();
            }
        });
        this.viewer.setComparator((ViewerComparator)this.comparator);
        int dir = this.comparator.getDirection();
        this.viewer.getTable().setSortDirection(dir);
        this.viewer.getTable().setSortColumn(col.getColumn());
        col = this.createTableViewerColumn(Messages.getString(SelectGoToSourceInputDialog.class, "table.column.line"), 100, 1);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                int[] bounds = ((TextSelectionInFile)element).getBounds();
                return bounds != null && bounds.length > 0 ? String.valueOf(bounds[0]) : "";
            }
        });
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SelectGoToSourceInputDialog.this.getButton(0).setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                SelectGoToSourceInputDialog.this.getButton(0).setEnabled(true);
            }
        });
        table.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent arg0) {
            }

            public void mouseDown(MouseEvent arg0) {
            }

            public void mouseDoubleClick(MouseEvent arg0) {
                SelectGoToSourceInputDialog.this.okPressed();
            }
        });
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElements) {
                return ((Collection)inputElements).toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
            }
        });
        this.viewer.setInput(this.inputs);
        return parent;
    }

    private TableViewerColumn createTableViewerColumn(String title, int bound, int colNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        column.addSelectionListener((SelectionListener)this.getSelectionAdapter(column, colNumber));
        return viewerColumn;
    }

    private SelectionAdapter getSelectionAdapter(final TableColumn column, final int index) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectGoToSourceInputDialog.this.comparator.setColumn(index);
                int dir = SelectGoToSourceInputDialog.this.comparator.getDirection();
                SelectGoToSourceInputDialog.this.viewer.getTable().setSortDirection(dir);
                SelectGoToSourceInputDialog.this.viewer.getTable().setSortColumn(column);
                SelectGoToSourceInputDialog.this.viewer.refresh();
            }
        };
        return selectionAdapter;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        Button button = super.getOkButton();
        if (this.okButtonTxt == null || this.okButtonTxt.isEmpty()) {
            this.okButtonTxt = Messages.getString(SelectGoToSourceInputDialog.class, "gotosource.button");
        }
        button.setText(this.okButtonTxt);
        button.setEnabled(false);
        this.setButtonLayoutData(button);
    }

    protected void cancelPressed() {
        this.setSelectionResult(null);
        super.cancelPressed();
    }

    protected void okPressed() {
        this.computeResult();
        super.okPressed();
    }

    protected void computeResult() {
        ISelection checked = this.viewer.getSelection();
        this.setSelectionResult(((StructuredSelection)checked).toArray());
    }

    class LinesComparator
    extends ViewerComparator {
        private int propertyIndex = 0;
        private static final int DESCENDING = 1;
        private int direction = -1;

        public int getDirection() {
            return this.direction == 1 ? 1024 : 128;
        }

        public void setColumn(int column) {
            if (column == this.propertyIndex) {
                this.direction = 1 - this.direction;
            } else {
                this.propertyIndex = column;
                this.direction = 1;
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int rc = 0;
            TextSelectionInFile tsi1 = (TextSelectionInFile)e1;
            TextSelectionInFile tsi2 = (TextSelectionInFile)e2;
            int fComp = tsi1.getFileName().compareTo(tsi2.getFileName());
            int lComp = new Integer(0);
            lComp = tsi1.getBounds() != null && tsi1.getBounds().length > 0 ? (tsi2.getBounds() != null && tsi2.getBounds().length > 0 ? new Integer(tsi1.getBounds()[0]).compareTo(new Integer(tsi2.getBounds()[0])) : -1) : 1;
            switch (this.propertyIndex) {
                case 0: {
                    rc = this.direction == 1 ? -fComp : fComp;
                    rc = rc == 0 ? lComp : rc;
                    break;
                }
                case 1: {
                    rc = this.direction == 1 ? -lComp : lComp;
                    rc = rc == 0 ? fComp : rc;
                }
            }
            return rc;
        }
    }
}

