/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.gui.rdz;

import com.ez.internal.rdz.IHook;
import com.ez.internal.utils.ServiceUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HookUtils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(HookUtils.class);
    private static final boolean test = false;
    private static boolean initialized = false;
    private static IHook hookUtils = null;

    public static boolean isRdzAdditionsAvailable() {
        if (!initialized) {
            hookUtils = (IHook)ServiceUtils.getService(IHook.class);
            if (hookUtils != null) {
                L.info("RDZHook utils loaded!");
            } else {
                L.error("could not load RDZHook utils!, check service!");
            }
            initialized = true;
        }
        return hookUtils != null;
    }

    public static boolean openRemoteEditor(IProgressMonitor monitor, String mainframeProjectName, String path) {
        boolean rdzAdditionsAvailable = HookUtils.isRdzAdditionsAvailable();
        if (hookUtils != null && rdzAdditionsAvailable) {
            L.debug("RDZAdditions are available. Opening editor[mainframeProjectName={}, path={} ].", (Object)mainframeProjectName, (Object)path);
            hookUtils.openRDZEditor(monitor, mainframeProjectName, path);
        } else {
            L.error("failed to open remote editor [mainframeProjectName={}, path={}]. Cause: RDZAdditions are not available.", (Object)mainframeProjectName, (Object)path);
        }
        return rdzAdditionsAvailable;
    }

    public static void openRemoteEditor(IProgressMonitor monitor, String mainframeProjectName, String path, int lineNumber, int charStart, int charEnd) {
        boolean rdzAdditionsAvailable = HookUtils.isRdzAdditionsAvailable();
        if (hookUtils != null && rdzAdditionsAvailable) {
            L.debug("RDZAdditions are available. Opening editor [mainframeProjectName={}, path={}, lineNumber={}, charStart={}, charEnd={}]. ", new Object[]{mainframeProjectName, path, lineNumber, charStart, charEnd});
            hookUtils.openRDZEditor(monitor, mainframeProjectName, path, lineNumber, charStart, charEnd);
        } else {
            L.error("failed to open remote editor [mainframeProjectName={}, path={}, lineNumber={}, charStart={}, charEnd={}]. Cause: RDZAdditions are not available.", new Object[]{mainframeProjectName, path, lineNumber, charStart, charEnd});
        }
    }

    public static StringBuilder getContent(IProgressMonitor monitor, String mainframeProjectName, String path) throws IOException {
        boolean rdzAdditionsAvailable = HookUtils.isRdzAdditionsAvailable();
        StringBuilder sb = null;
        if (hookUtils != null && rdzAdditionsAvailable) {
            InputStream is = hookUtils.getFileContent(monitor, mainframeProjectName, path);
            if (is != null) {
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)is, (Writer)writer);
                sb = new StringBuilder(writer.getBuffer());
            } else {
                L.warn("null content for the file {} ", (Object)path);
            }
        }
        return sb;
    }

    public static boolean isValitRemotePath(String path) {
        boolean b = false;
        if (hookUtils != null && HookUtils.isRdzAdditionsAvailable()) {
            b = hookUtils.isValidRdzPath(path);
        }
        return b;
    }
}

