/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.gui.properties.sections;

import com.ez.common.ui.guielements.TabType;
import com.ez.common.ui.properties.sections.AbstractEZSection;
import com.ez.internal.id.EZEntityID;
import com.ez.mainframe.gui.internal.Messages;
import com.ez.mainframe.gui.properties.StmtSourceInfoNode;
import com.ez.workspace.model.segments.EZSourceMainframeNodeIdSg;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class StmtSourceInfoSection
extends AbstractEZSection {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private StmtSourceInfoNode model;
    private static final String EMPTY_STRING = "";
    private Text txtPath;
    private Text txtStmtType;
    private Text txtPrgType;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        this.composite.setLayout((Layout)gl);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        this.getWidgetFactory().createLabel(this.composite, Messages.getString(StmtSourceInfoSection.class, "label.Path"));
        this.txtPath = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        this.txtPath.setLayoutData((Object)gd);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        this.getWidgetFactory().createLabel(this.composite, Messages.getString(StmtSourceInfoSection.class, "label.StatementType"));
        this.txtStmtType = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        this.txtStmtType.setLayoutData((Object)gd);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        this.getWidgetFactory().createLabel(this.composite, Messages.getString(StmtSourceInfoSection.class, "label.ProgramType"));
        this.txtPrgType = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        this.txtPrgType.setLayoutData((Object)gd);
    }

    public void refresh() {
        if (!this.allowRefresh()) {
            return;
        }
        this.clearData();
        if (this.model != null) {
            if (this.model.getPath() != null) {
                this.txtPath.setText(this.model.getPath());
            }
            if (this.model.getStmtType() != null) {
                this.txtStmtType.setText(this.model.getStmtType());
            }
            if (this.model.getPrgType() != null) {
                this.txtPrgType.setText(this.model.getPrgType());
            }
        }
        this.composite.pack();
    }

    private void clearData() {
        this.txtPath.setText(EMPTY_STRING);
        this.txtStmtType.setText(EMPTY_STRING);
        this.txtPrgType.setText(EMPTY_STRING);
    }

    protected void setSectionInput(IWorkbenchPart part, ISelection selection) {
        Object node;
        EZSourceMainframeNodeIdSg sg;
        EZEntityID eid;
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (input instanceof EZEntityID && (eid = (EZEntityID)input) != null && (sg = (EZSourceMainframeNodeIdSg)eid.getSegment(EZSourceMainframeNodeIdSg.class)) != null && (node = sg.getResNode()) != null && node instanceof StmtSourceInfoNode) {
            this.model = (StmtSourceInfoNode)node;
        }
    }

    protected Set<TabType> getParentTabs() {
        return null;
    }

    protected boolean isShowingOtherTab(ISelection selection) {
        return false;
    }
}

