/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.gui.preferences.pages;

import com.ez.internal.utils.Utils;
import com.ez.mainframe.gui.internal.Messages;
import com.ez.mainframe.gui.preferences.pages.AddEntryDialog;
import com.ez.mainframe.gui.preferences.pages.CallgraphRestrictionsChecker;
import com.ez.workspace.preferences.WorkspacePrefUtils;
import com.ez.workspace.utils.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NameRestrictionsBlock {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(NameRestrictionsBlock.class);
    private static Set<String> restrictions = new HashSet<String>();
    private static boolean mustLoad = true;
    private static String propPath = Utils.getApplicationDefaultPath();
    private static final String CG_RESTRICTIONS_PROPERTIES_FILENAME = "cgRestrictions.properties";
    private static String FILE_NAME = String.valueOf(propPath) + System.getProperty("file.separator") + "cgRestrictions.properties";
    private Composite fControl;
    private Set<String> objSet = new HashSet<String>();
    private CheckboxTableViewer objListTree;
    private Button editButton;
    private Table fTable;
    private Button restrictionButton;
    private Button limitResourcesButton;
    private Group resGroup;
    private CallgraphRestrictionsChecker entryChecker = new CallgraphRestrictionsChecker();

    private String[] getCheckedRestrictions() {
        IPreferenceStore store = WorkspacePrefUtils.getPreferenceStore();
        String value = store.getString("callgraphNamesList");
        return value.split(FileUtils.SEPARATOR);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doStore() {
        IPreferenceStore store = WorkspacePrefUtils.getPreferenceStore();
        store.setValue("callgraphRestrictedNodesVisibility", this.restrictionButton.getSelection());
        store.setValue("callgraphWithoutResources", this.limitResourcesButton.getSelection());
        Control[] controlArray = this.resGroup.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            Button b = (Button)c;
            store.setValue(b.getText(), b.getSelection());
            ++n2;
        }
        Object[] names = this.objListTree.getCheckedElements();
        StringBuilder sbstore = new StringBuilder();
        Object[] objectArray = names;
        int b = names.length;
        int n3 = 0;
        while (n3 < b) {
            Object o = objectArray[n3];
            if (sbstore.length() > 0) {
                sbstore.append(FileUtils.SEPARATOR);
            }
            sbstore.append(String.valueOf(o));
            ++n3;
        }
        store.setValue("callgraphNamesList", sbstore.toString());
        restrictions.clear();
        restrictions.addAll(this.objSet);
        FileOutputStream fileOut = null;
        try {
            try {
                File file = new File(FILE_NAME);
                fileOut = new FileOutputStream(file);
                for (String input : restrictions) {
                    String s = String.valueOf(input) + "\r\n";
                    byte[] b2 = s.getBytes();
                    fileOut.write(b2);
                }
                return;
            }
            catch (FileNotFoundException e) {
                L.error("File not found: ", (Throwable)e);
                if (fileOut == null) return;
                try {
                    fileOut.close();
                    return;
                }
                catch (IOException e2) {
                    L.warn("could not close fileOut ", (Throwable)e2);
                }
                return;
            }
            catch (IOException e) {
                L.error("exception: ", (Throwable)e);
                if (fileOut == null) return;
                try {
                    fileOut.close();
                    return;
                }
                catch (IOException e3) {
                    L.warn("could not close fileOut ", (Throwable)e3);
                }
                return;
            }
        }
        finally {
            if (fileOut != null) {
                try {
                    fileOut.close();
                }
                catch (IOException e) {
                    L.warn("could not close fileOut ", (Throwable)e);
                }
            }
        }
    }

    public void createControl(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        Font font = ancestor.getFont();
        parent.setFont(font);
        this.fControl = parent;
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        this.fControl.setLayoutData((Object)data);
        this.createlimitResourcesButton(parent);
        Label sep = new Label(parent, 258);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 2;
        sep.setLayoutData((Object)gridData);
        this.createVisibilityRestrictionButton(parent);
        Label tableLabel = new Label(parent, 0);
        tableLabel.setText(Messages.getString(NameRestrictionsBlock.class, "table.label"));
        data = new GridData();
        data.horizontalSpan = 2;
        tableLabel.setLayoutData((Object)data);
        tableLabel.setFont(font);
        this.fTable = new Table(parent, 67618);
        data = new GridData(1808);
        this.fTable.setLayoutData((Object)data);
        this.fTable.setFont(font);
        this.fTable.setHeaderVisible(true);
        this.fTable.setLinesVisible(true);
        TableColumn column1 = new TableColumn(this.fTable, 0);
        column1.setText(Messages.getString(NameRestrictionsBlock.class, "column1.label"));
        this.objListTree = new CheckboxTableViewer(this.fTable);
        this.objListTree.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.objListTree.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.objListTree.setComparator(new ViewerComparator());
        this.objListTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent evt) {
                NameRestrictionsBlock.this.enableButtons();
            }
        });
        this.fTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0) {
                    NameRestrictionsBlock.this.removeSelected();
                }
            }
        });
        Composite buttons = new Composite(parent, 0);
        buttons.setLayoutData((Object)new GridData(2));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        buttons.setFont(font);
        Button addButton = this.createPushButton(buttons, Messages.getString(NameRestrictionsBlock.class, "addBtn.txt"), null);
        addButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                NameRestrictionsBlock.this.addEntry(null);
            }
        });
        this.editButton = this.createPushButton(buttons, Messages.getString(NameRestrictionsBlock.class, "editBtn.txt"), null);
        this.editButton.setEnabled(false);
        this.editButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                NameRestrictionsBlock.this.editEntry();
            }
        });
        Button removeButton = this.createPushButton(buttons, Messages.getString(NameRestrictionsBlock.class, "removeBtn.txt"), null);
        removeButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                NameRestrictionsBlock.this.removeSelected();
            }
        });
        Label separator = new Label(buttons, 0);
        separator.setVisible(false);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.heightHint = 4;
        separator.setLayoutData((Object)gd);
        Button addFromFileButton = this.createPushButton(buttons, Messages.getString(NameRestrictionsBlock.class, "addFromFileBtn.txt"), null);
        addFromFileButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                NameRestrictionsBlock.this.addFromFileEntry();
            }
        });
        Button removeAllButton = this.createPushButton(buttons, Messages.getString(NameRestrictionsBlock.class, "removeAllBtn.txt"), null);
        removeAllButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                NameRestrictionsBlock.this.removeAllSelected();
            }
        });
        this.setLimitResourcesState();
        this.setExistingEntries();
        this.restoreColumnSettings();
        this.setVisibilityRestrictionState();
    }

    private void createVisibilityRestrictionButton(Composite parent) {
        this.restrictionButton = new Button(parent, 32);
        this.restrictionButton.setFont(parent.getFont());
        this.restrictionButton.setText(Messages.getString(NameRestrictionsBlock.class, "restrictionBtn.txt"));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.restrictionButton.setLayoutData((Object)gd);
    }

    private void setVisibilityRestrictionState() {
        IPreferenceStore store = WorkspacePrefUtils.getPreferenceStore();
        Boolean value = store.getBoolean("callgraphRestrictedNodesVisibility");
        this.restrictionButton.setSelection(value.booleanValue());
    }

    private void createlimitResourcesButton(Composite parent) {
        this.limitResourcesButton = new Button(parent, 32);
        this.limitResourcesButton.setFont(parent.getFont());
        this.limitResourcesButton.setText(Messages.getString(NameRestrictionsBlock.class, "limit.resources.btn.txt"));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.limitResourcesButton.setLayoutData((Object)gd);
        this.resGroup = new Group(parent, 0);
        GridLayout gl = new GridLayout(4, true);
        this.resGroup.setLayout((Layout)gl);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.grabExcessVerticalSpace = true;
        this.resGroup.setLayoutData((Object)gd);
        this.resGroup.setText(Messages.getString(NameRestrictionsBlock.class, "resources.grp.txt"));
        for (String lbl : com.ez.mainframe.gui.utils.Utils.resourceTypesLbl.keySet()) {
            Button button = new Button((Composite)this.resGroup, 32);
            button.setText(lbl);
        }
        this.limitResourcesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NameRestrictionsBlock.this.resGroup.setEnabled(!NameRestrictionsBlock.this.limitResourcesButton.getSelection());
                Control[] controlArray = NameRestrictionsBlock.this.resGroup.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control c = controlArray[n2];
                    c.setEnabled(!NameRestrictionsBlock.this.limitResourcesButton.getSelection());
                    ++n2;
                }
            }
        });
    }

    private void setLimitResourcesState() {
        IPreferenceStore store = WorkspacePrefUtils.getPreferenceStore();
        Boolean value = store.getBoolean("callgraphWithoutResources");
        this.limitResourcesButton.setSelection(value.booleanValue());
        this.resGroup.setEnabled(value == false);
        Control[] controlArray = this.resGroup.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            Button b = (Button)c;
            boolean isChecked = store.getBoolean(b.getText());
            b.setSelection(isChecked);
            b.setEnabled(value == false);
            ++n2;
        }
    }

    private void restoreColumnSettings() {
        this.objListTree.getTable().layout(true);
        int columnCount = this.fTable.getColumnCount();
        int i = 0;
        while (i < columnCount) {
            int width = -1;
            try {
                width = 110;
            }
            catch (NumberFormatException numberFormatException) {}
            if (width <= 0) {
                this.fTable.getColumn(i).pack();
            } else {
                this.fTable.getColumn(i).setWidth(width);
            }
            ++i;
        }
    }

    private void addEntry(String entr) {
        Shell shell = this.fControl.getShell();
        AddEntryDialog dialog = new AddEntryDialog(shell, entr, this.entryChecker);
        dialog.create();
        if (dialog.open() == 0) {
            String entriesToAdd = dialog.getEntryToAdd();
            if (entr != null) {
                this.objSet.remove(entr);
            }
            this.objSet.add(entriesToAdd);
            this.objListTree.setInput(this.objSet);
            this.objListTree.setChecked((Object)entriesToAdd, true);
            this.objListTree.refresh();
        }
    }

    private void editEntry() {
        IStructuredSelection selection = (IStructuredSelection)this.objListTree.getSelection();
        if (selection.getFirstElement() != null) {
            String entr = (String)selection.getFirstElement();
            this.addEntry(entr);
        }
    }

    private void addFromFileEntry() {
        FileDialog fileDialog = new FileDialog(Display.getDefault().getActiveShell(), 4096);
        String file = fileDialog.open();
        if (file != null) {
            Set<Object> inputsFromFile;
            block20: {
                FileInputStream inStream = null;
                inputsFromFile = null;
                try {
                    try {
                        L.trace("fileName={}", (Object)file);
                        inStream = new FileInputStream(file);
                        try {
                            Properties properties = new Properties();
                            properties.load(inStream);
                            inputsFromFile = properties.keySet();
                        }
                        catch (IOException iOException) {
                            L.error("load Restrictions from file ", (Throwable)iOException);
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        L.info("file to add new entries not found: ", (Throwable)fileNotFoundException);
                        if (inStream != null) {
                            try {
                                inStream.close();
                            }
                            catch (IOException e2) {
                                L.warn("could not close inputstream ", (Throwable)e2);
                            }
                        }
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    if (inStream != null) {
                        try {
                            inStream.close();
                        }
                        catch (IOException e) {
                            L.warn("could not close inputstream ", (Throwable)e);
                        }
                    }
                    throw throwable;
                }
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (IOException e) {
                        L.warn("could not close inputstream ", (Throwable)e);
                    }
                }
            }
            if (inputsFromFile != null) {
                for (Object e : inputsFromFile) {
                    String text = (String)e;
                    boolean errExists = this.entryChecker.check(text);
                    if (errExists) continue;
                    this.objSet.add(text);
                }
                this.objListTree.setInput(this.objSet);
                for (Object object : inputsFromFile) {
                    this.objListTree.setChecked((Object)((String)object), Boolean.TRUE.booleanValue());
                }
                this.objListTree.refresh();
            }
        }
    }

    private Button createPushButton(Composite parent, String label, Image image) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        if (image != null) {
            button.setImage(image);
        }
        if (label != null) {
            button.setText(label);
        }
        GridData gd = new GridData();
        button.setLayoutData((Object)gd);
        this.setButtonDimensionHint(button);
        return button;
    }

    private void setButtonDimensionHint(Button button) {
        Object gd = button.getLayoutData();
        if (gd instanceof GridData) {
            ((GridData)gd).horizontalAlignment = 4;
        }
    }

    private void enableButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.objListTree.getSelection();
        int selectionCount = selection.size();
        this.editButton.setEnabled(selectionCount == 1);
    }

    private void removeSelected() {
        IStructuredSelection selection = (IStructuredSelection)this.objListTree.getSelection();
        this.removeEntries(selection.toArray());
    }

    private void removeAllSelected() {
        this.objSet.clear();
        this.objListTree.refresh();
    }

    private void removeEntries(Object[] obj) {
        int i = 0;
        while (i < obj.length) {
            this.objSet.remove(obj[i]);
            ++i;
        }
        this.objListTree.refresh();
    }

    private void setExistingEntries() {
        L.trace("before getting restrictions");
        Set<String> restrs = NameRestrictionsBlock.getRestrictions();
        for (String res : restrs) {
            this.objSet.add(res);
        }
        this.objListTree.setInput(this.objSet);
        String[] stringArray = this.getCheckedRestrictions();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String res;
            res = stringArray[n2];
            this.objListTree.setChecked((Object)res, true);
            ++n2;
        }
        this.objListTree.refresh();
    }

    private static Set<String> getRestrictions() {
        if (mustLoad) {
            NameRestrictionsBlock.loadRestrictions();
        }
        return restrictions;
    }

    private static void loadRestrictions() {
        block15: {
            FileInputStream inStream = null;
            try {
                try {
                    L.trace("fileName={}", (Object)FILE_NAME);
                    inStream = new FileInputStream(FILE_NAME);
                    try {
                        Properties propr = new Properties();
                        propr.load(inStream);
                        L.trace("after load file; restrictions: {}", propr.keySet());
                        for (Object name : propr.keySet()) {
                            restrictions.add((String)name);
                        }
                        mustLoad = false;
                    }
                    catch (IOException e) {
                        L.error("loadRestrictions() ", (Throwable)e);
                    }
                }
                catch (FileNotFoundException e) {
                    L.info("file not found: ", (Throwable)e);
                    if (inStream == null) break block15;
                    try {
                        inStream.close();
                    }
                    catch (IOException e2) {
                        L.warn("could not close inputstream ", (Throwable)e2);
                    }
                }
            }
            finally {
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (IOException e) {
                        L.warn("could not close inputstream ", (Throwable)e);
                    }
                }
            }
        }
    }
}

