/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.gui.preferences.pages;

import com.ez.mainframe.gui.internal.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallgraphRestrictionsChecker {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(CallgraphRestrictionsChecker.class);
    private static final String emptyEntryError = Messages.getString(CallgraphRestrictionsChecker.class, "empty.entry.err");
    private String errMessage = null;

    public boolean check(String text) {
        boolean errExists = false;
        this.errMessage = "";
        if (text.isEmpty()) {
            errExists = true;
            this.errMessage = emptyEntryError;
        } else {
            String[] denied = new String[]{"'", "\\"};
            int i = 0;
            while (i < denied.length) {
                if (text.indexOf(denied[i]) > -1) {
                    errExists = true;
                    L.debug("character not accepted: {}", (Object)denied[i]);
                    this.errMessage = "";
                    break;
                }
                ++i;
            }
            if (!errExists) {
                String patternMatch = "*";
                if (patternMatch.equals(text)) {
                    errExists = true;
                    L.debug("pattern not accepted: {}", (Object)patternMatch);
                    this.errMessage = "";
                } else {
                    int lastIdx;
                    int firstIdx = text.indexOf(patternMatch);
                    if (firstIdx != (lastIdx = text.lastIndexOf(patternMatch))) {
                        if (firstIdx == 0 && lastIdx == text.length() - 1) {
                            String tmpTxt = text.substring(1, text.length() - 1);
                            if (tmpTxt.isEmpty() || tmpTxt.indexOf(patternMatch) > -1) {
                                errExists = true;
                                L.debug("pattern not accepted: {}", (Object)patternMatch);
                                this.errMessage = "";
                            } else {
                                errExists = false;
                                this.errMessage = "";
                            }
                        } else {
                            errExists = true;
                            L.debug("pattern not accepted: {}", (Object)patternMatch);
                            this.errMessage = "";
                        }
                    } else {
                        errExists = false;
                        this.errMessage = "";
                    }
                }
            }
        }
        return errExists;
    }

    public String getErrorMessage() {
        return this.errMessage;
    }
}

