/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.gui.preferences.pages;

import com.ez.mainframe.gui.internal.Messages;
import com.ez.mainframe.gui.preferences.pages.CallgraphRestrictionsChecker;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddEntryDialog
extends TrayDialog {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(AddEntryDialog.class);
    private static final String ADD_TITLE = Messages.getString(AddEntryDialog.class, "add.title");
    private static final String EDIT_TITLE = Messages.getString(AddEntryDialog.class, "edit.title");
    private Composite composite;
    private Text entryText;
    private Button okButton;
    private Label errorLabel;
    private boolean errExists = false;
    private String entry;
    private CallgraphRestrictionsChecker entryChecker;

    public AddEntryDialog(Shell shell, String entry, CallgraphRestrictionsChecker entryChecker) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setHelpAvailable(false);
        this.entry = entry;
        this.entryChecker = entryChecker;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.entry == null) {
            newShell.setText(ADD_TITLE);
        } else {
            newShell.setText(EDIT_TITLE);
        }
        Rectangle rect = newShell.getParent().getBounds();
        newShell.setLocation(rect.x + rect.width / 6, rect.y + rect.height / 8);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        area.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        area.setLayout((Layout)layout);
        this.getDiagControl(area);
        this.errorLabel = new Label(area, 0);
        this.errorLabel.setText("");
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.horizontalIndent = this.convertHorizontalDLUsToPixels(7);
        this.errorLabel.setLayoutData((Object)data);
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.okButton = this.getButton(0);
        this.okButton.setEnabled(false);
    }

    private Composite getDiagControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 8;
        layout.numColumns = 4;
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        this.composite.setLayout((Layout)layout);
        this.composite.setLayoutData((Object)gd);
        Label labelEntry = new Label(this.composite, 0);
        gd = new GridData();
        labelEntry.setLayoutData((Object)gd);
        labelEntry.setText(Messages.getString(AddEntryDialog.class, "entry.lbl"));
        this.entryText = new Text(this.composite, 2048);
        if (this.entry != null) {
            this.entryText.setText(this.entry);
        }
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 3;
        this.entryText.setLayoutData((Object)gd);
        this.entryText.setEnabled(true);
        this.entryText.addModifyListener((ModifyListener)new EntryListener());
        this.entryText.setFocus();
        labelEntry.setData((Object)this.entryText);
        this.composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                AddEntryDialog.this.composite = null;
            }
        });
        return this.composite;
    }

    private void updateErrorMsg(String notValid) {
        this.errorLabel.setText(notValid);
        if (this.entryText.getText().length() != 0) {
            if (notValid.trim().isEmpty() && !this.errExists) {
                this.okButton.setEnabled(true);
            } else {
                this.okButton.setEnabled(false);
            }
        } else {
            this.okButton.setEnabled(false);
        }
    }

    protected void okPressed() {
        this.entry = this.entryText.getText();
        super.okPressed();
    }

    public String getEntryToAdd() {
        L.debug("entryToAdd----> {}", (Object)this.entry);
        return this.entry.trim();
    }

    class EntryListener
    implements ModifyListener {
        EntryListener() {
        }

        public void modifyText(ModifyEvent e) {
            AddEntryDialog.this.errExists = false;
            Text widgetText = (Text)e.getSource();
            String text = widgetText.getText().trim();
            AddEntryDialog.this.errExists = AddEntryDialog.this.entryChecker.check(text);
            AddEntryDialog.this.updateErrorMsg(AddEntryDialog.this.entryChecker.getErrorMessage());
        }
    }
}

