/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.gui.preferences;

import com.ez.mainframe.gui.internal.Activator;
import com.ez.mainframe.gui.preferences.PreferenceConstants;
import com.ez.workspace.preferences.WorkspacePrefUtils;
import com.ez.workspace.utils.FileUtils;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;

public class PreferenceUtils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    public static void addPropertyChangeListener(IPropertyChangeListener listener) {
        Activator default1 = Activator.getDefault();
        if (default1 != null) {
            IPreferenceStore store = default1.getPreferenceStore();
            store.addPropertyChangeListener(listener);
        }
    }

    public static void removePropertyChangeListener(IPropertyChangeListener listener) {
        Activator default1 = Activator.getDefault();
        if (default1 != null) {
            IPreferenceStore store = default1.getPreferenceStore();
            store.removePropertyChangeListener(listener);
        }
    }

    public static IPreferenceStore getPreferenceStore() {
        Activator activator = Activator.getDefault();
        IPreferenceStore ret = null;
        if (activator != null) {
            ret = activator.getPreferenceStore();
        }
        return ret;
    }

    public static final Object getDefaultValue(String preferenceID) {
        if (preferenceID != null) {
            if (preferenceID.equalsIgnoreCase("showSCLProcsPreference")) {
                return PreferenceConstants.SHOW_SCLPROCEDURES;
            }
            if (preferenceID.equalsIgnoreCase("showFlowchartAsText")) {
                return PreferenceConstants.SHOW_FLOWCHART_AS_TEXT;
            }
            if (preferenceID.equalsIgnoreCase("displayDeadCode")) {
                return PreferenceConstants.DISPLAY_DEAD_CODE;
            }
            if (preferenceID.equalsIgnoreCase("displayIMSSegmentsHierarchy")) {
                return PreferenceConstants.SHOW_IMS_SEGMENTS_HIERARCHY;
            }
        }
        return null;
    }

    public static boolean isShowingSCLProcs() {
        IPreferenceStore store = PreferenceUtils.getPreferenceStore();
        boolean showSCLProcs = store.getBoolean("showSCLProcsPreference");
        return showSCLProcs;
    }

    public static String[] getCallgraphNamesCheckedRestrictions() {
        IPreferenceStore store = WorkspacePrefUtils.getPreferenceStore();
        String value = store.getString("callgraphNamesList");
        return value.split(FileUtils.SEPARATOR);
    }
}

