/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.gui.graphs;

import com.ez.mainframe.gui.internal.Activator;
import com.ez.mainframe.gui.internal.Messages;
import com.ez.workspace.analysis.graph.model.GraphInnerElement;
import com.ez.workspace.analysis.graph.model.Model;
import com.ez.workspace.analysis.graph.model.StructureContentProviderAdapter;
import com.ez.workspace.analysis.graph.mouseHook.MouseActionsHook;
import com.tomsawyer.graph.TSGraphMember;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;

public class ContentProvider
extends StructureContentProviderAdapter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    protected boolean hasExport = false;
    private boolean current = false;

    public ContentProvider(MouseActionsHook mouseActionsHook) {
        this.mouseActionsHook = mouseActionsHook;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof GraphInnerElement) {
            GraphInnerElement elm = (GraphInnerElement)parentElement;
            return elm.getElems().toArray();
        }
        return EMPTY_ARRAY;
    }

    public Object getParent(Object element) {
        if (element instanceof Model) {
            return ((Model)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object getInputTree() {
        GraphInnerElement result = null;
        if (this.inputTree != null) {
            result = this.initialize(new GraphInnerElement(), this.inputTree);
        }
        return result;
    }

    private GraphInnerElement initialize(GraphInnerElement root, Map map) {
        for (Object o1 : map.keySet()) {
            GraphInnerElement gie = this.getGIE(o1);
            if (gie == null) continue;
            root.addElem(gie);
            Object o2 = map.get(o1);
            if (o2 != null) {
                if (o2 instanceof Collection) {
                    Collection elemSet = (Collection)o2;
                    for (Object o3 : elemSet) {
                        GraphInnerElement gieChild = this.getGIE(o3);
                        if (gieChild == null) continue;
                        gie.addElem(gieChild);
                    }
                } else if (o2 instanceof Map) {
                    HashMap elemMap = (HashMap)o2;
                    this.initialize(gie, elemMap);
                }
            }
            if (gie.getElems().size() == 0) {
                root.getElems().remove(gie);
                continue;
            }
            this.annotateName(gie);
        }
        return root;
    }

    protected GraphInnerElement getGIE(Object o1) {
        String name = this.computeName(o1);
        TSGraphMember node1 = null;
        if (o1 instanceof TSGraphMember) {
            node1 = (TSGraphMember)o1;
        }
        GraphInnerElement gie = new GraphInnerElement(name, node1);
        return gie;
    }

    protected String computeName(Object o1) {
        String name = null;
        TSGraphMember node1 = null;
        if (o1 instanceof String) {
            name = o1.toString();
        } else if (o1 instanceof TSGraphMember) {
            node1 = (TSGraphMember)o1;
            name = node1.hasAttribute("TAG_VISIBLE_ONLY_GRAPHINVENTORY") ? (String)node1.getAttributeValue("TAG_VISIBLE_ONLY_GRAPHINVENTORY") : node1.getText();
        }
        return name;
    }

    protected void annotateName(GraphInnerElement elem) {
        if (elem != null && elem.getElems() != null) {
            String name = elem.getName() == null ? "" : elem.getName();
            elem.setName(name.concat("(" + elem.getElems().size() + ")"));
        }
    }

    public MouseActionsHook getMouseActionsHook() {
        return this.mouseActionsHook;
    }

    public void setInputTree(Map map) {
        this.inputTree = map;
    }

    public void setHasExport(boolean hasExport) {
        this.hasExport = hasExport;
    }

    public boolean hasExport() {
        return this.hasExport;
    }

    public String getToolbarName() {
        return Messages.getString(ContentProvider.class, "toolbar.button.tooltip");
    }

    public void setToolbarImage(ImageDescriptor toolbarImage) {
        this.toolbarImage = toolbarImage;
    }

    public boolean isDefault() {
        return true;
    }

    public boolean isCurrent() {
        return this.current;
    }

    public void setCurrent(boolean isCurrent) {
        this.current = isCurrent;
    }

    public ImageDescriptor getToolbarImage() {
        return Activator.getImageDescriptor("icons/sortByType.png");
    }
}

