/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.gui.graphs;

import com.ez.internal.id.EZEntityID;
import com.ez.workspace.state.IPartStateManager;
import com.tomsawyer.drawing.geometry.shared.TSConstRect;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.interactive.swing.TSSwingCanvas;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationPartStateManager
implements IPartStateManager {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(AnnotationPartStateManager.class);
    private Map<EZEntityID, Boolean> currentState = null;
    private TSSwingCanvas canvas;
    private Map<EZEntityID, Set<TSENode>> needState = null;

    public void register(EZEntityID source, Object targetNode) {
        if (this.needState == null) {
            this.needState = new HashMap<EZEntityID, Set<TSENode>>();
        }
        Set<Object> targetNodes = null;
        if (!this.needState.containsKey(source)) {
            targetNodes = new HashSet();
            this.needState.put(source, targetNodes);
        } else {
            targetNodes = this.needState.get(source);
        }
        targetNodes.add((TSENode)targetNode);
    }

    public void update() {
        L.trace("manager start the update");
        if (this.needState == null || this.needState.size() == 0) {
            return;
        }
        Set<EZEntityID> resourceSet = this.needState.keySet();
        for (EZEntityID entityID : this.currentState.keySet()) {
            if (!resourceSet.contains(entityID)) continue;
            Set<TSENode> targetNodes = this.needState.get(entityID);
            Boolean vb = this.currentState.get(entityID);
            if (vb == null) {
                vb = Boolean.FALSE;
            }
            for (TSENode tsNode : targetNodes) {
                tsNode.setAttribute("annotation", (Object)vb.toString());
                this.markNodeUI(tsNode);
            }
        }
        this.currentState = null;
        L.trace("manager ends the update");
    }

    private void markNodeUI(TSENode tsNode) {
        TSConstRect bounds = tsNode.getBounds();
        this.canvas.addInvalidRegion(bounds);
        this.canvas.updateInvalidRegion(true);
        this.canvas.listen(null);
    }

    public void setCurrentState(Map<EZEntityID, Boolean> stateMap) {
        this.currentState = stateMap;
    }

    public void setCanvas(TSSwingCanvas canvas) {
        this.canvas = canvas;
    }

    public void clear() {
        if (this.needState != null) {
            this.needState.clear();
            this.needState = null;
        }
        if (this.currentState != null) {
            this.currentState.clear();
            this.currentState = null;
        }
    }

    public void dispose() {
        this.canvas = null;
        this.clear();
    }
}

