/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.gui.graphs;

import com.ez.ann.db.EZAnnotationDbManager;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.utils.LogUtil;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.gui.graphs.AnnotationPartStateManager;
import com.ez.mainframe.gui.graphs.GraphRestrictionsLegendInfo;
import com.ez.mainframe.gui.internal.Activator;
import com.ez.mainframe.gui.internal.Messages;
import com.ez.mainframe.projects.info.AnnotationsDbCheckerService;
import com.ez.workspace.analysis.graph.model.AbstractAnalysisGraphModel;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.tomsawyer.graph.TSGraph;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graphicaldrawing.TSENode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotatedGraphModel
extends AbstractAnalysisGraphModel {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(AnnotatedGraphModel.class);
    public static final String MF_PROJECT_ID_SG = "MAINFRAME_PROJECT_ID_SG";
    public static final String PROJECTS_TS_MAP_KEY = "Projects_TS_map";
    protected AnnotationPartStateManager annStateManager;

    public void setAnnotationsManager(AnnotationPartStateManager annStateManager) {
        this.annStateManager = annStateManager;
    }

    protected void findAnnotations(SubMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(AnnotatedGraphModel.class, "finding.annotations.task"));
        AnnotationsDbCheckerService srv = (AnnotationsDbCheckerService)ServiceUtils.getService(AnnotationsDbCheckerService.class);
        boolean isAnnDbAvailable = srv != null ? Boolean.valueOf(srv.isAnnDbAvailable()) : null;
        Map<EZObjectType, TSENode> tmp = this.prepareInputs(isAnnDbAvailable);
        if (isAnnDbAvailable) {
            if (!tmp.isEmpty()) {
                try {
                    Set ret = EZAnnotationDbManager.getInstance().haveAnnotations(tmp.keySet(), monitor);
                    if (ret != null && !ret.isEmpty()) {
                        for (EZObjectType tt : ret) {
                            TSENode n = tmp.remove(tt);
                            n.setAttribute("annotation", (Object)"true");
                            this.restrictionTypesSetForLegend.add(GraphRestrictionsLegendInfo.ANNOTATION);
                        }
                    }
                }
                catch (Exception e) {
                    L.error("error finding annotations", (Throwable)e);
                }
                tmp.clear();
                tmp = null;
            }
        } else {
            L.warn("annotations database cannot be reached; nodes in graph will not be annotated");
            LogUtil.log((int)2, (String)EZAnnotationDbManager.NO_ANN_DB_CONNECTION_WARNING_MSG, null, (Bundle)Activator.getDefault().getBundle());
        }
        monitor.setWorkRemaining(0);
    }

    protected Map<EZObjectType, TSENode> prepareInputs(boolean isAnnDbAvailable) {
        HashMap<EZObjectType, TSENode> tmp = new HashMap<EZObjectType, TSENode>();
        ArrayList nodes = new ArrayList();
        Map prjTSMap = (Map)this.graphManager.getAttributeValue(PROJECTS_TS_MAP_KEY);
        if (prjTSMap != null) {
            for (String pjName : prjTSMap.keySet()) {
                TSENode prjNode = (TSENode)prjTSMap.get(pjName);
                TSGraph graph = prjNode.getChildGraph();
                EZSourceProjectIDSg sg = (EZSourceProjectIDSg)graph.getAttributeValue(MF_PROJECT_ID_SG);
                if (sg == null) continue;
                nodes.addAll(graph.nodes());
            }
        } else {
            nodes.addAll(this.graph.nodes());
        }
        while (!nodes.isEmpty()) {
            TSENode node = (TSENode)nodes.remove(0);
            if (!this.isAnnCandidate(node)) continue;
            EZObjectType inpt = (EZObjectType)node.getAttributeValue("APPLICABLE_INPUT");
            if (inpt == null) {
                inpt = this.getApplicableInputType((TSNode)node);
            }
            if (inpt == null) continue;
            tmp.put(inpt, node);
            if (!isAnnDbAvailable) continue;
            this.annStateManager.register(inpt.getEntID(), node);
        }
        return tmp;
    }

    protected boolean isAnnCandidate(TSENode node) {
        return true;
    }

    public void dispose() {
        this.annStateManager = null;
        super.dispose();
    }
}

