/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.gui.graphs;

import com.ez.internal.id.EZEntityID;
import com.ez.mainframe.gui.graphs.AnnotatedGraphModel;
import com.ez.mainframe.gui.graphs.AnnotationContentProvider;
import com.ez.mainframe.gui.graphs.AnnotationPartStateManager;
import com.ez.mainframe.gui.graphs.AnnotationStateListener;
import com.ez.workspace.analysis.graph.job.GraphAnalysisJob;
import com.ez.workspace.analysis.graph.model.AbstractAnalysisGraphModel;
import com.ez.workspace.analysis.graph.mouseHook.MouseActionsHook;
import com.ez.workspace.state.EventType;
import com.ez.workspace.state.IEZStateListener;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;

public class AnnotatedGraphJob
extends GraphAnalysisJob {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    AnnotationPartStateManager annStateManager;
    AnnotationStateListener annStateListener;

    public AnnotatedGraphJob(EZEntityID id) {
        super(id);
    }

    protected void setAnnotationsContext() {
        if (this.annStateManager == null) {
            this.annStateManager = new AnnotationPartStateManager();
            this.annStateListener = new AnnotationStateListener(this.annStateManager);
            this.annStateManager.setCanvas(this.canvas);
            EventType evType = EventType.EZANNOTATION_EVENT_TYPE;
            this.stateManager.register((IEZStateListener)this.annStateListener, evType);
        } else {
            this.annStateManager.clear();
        }
    }

    protected void unsetAnnotationsContext() {
        EventType evType = EventType.EZANNOTATION_EVENT_TYPE;
        this.stateManager.unregister((IEZStateListener)this.annStateListener, evType);
        this.annStateListener = null;
        if (this.annStateManager != null) {
            this.annStateManager.dispose();
            this.annStateManager = null;
        }
    }

    protected void computeResults(AbstractAnalysisGraphModel model, IProgressMonitor monitor) {
        this.setAnnotationsContext();
        ((AnnotatedGraphModel)this.graphModel).setAnnotationsManager(this.annStateManager);
    }

    public void closing() {
        this.unsetAnnotationsContext();
        super.closing();
    }

    protected void addAnnContentProvider(MouseActionsHook hook) {
        HashSet<AnnotationContentProvider> providers = this.graphInfo.getContentProviders();
        if (providers == null) {
            providers = new HashSet<AnnotationContentProvider>();
            this.graphInfo.setContentProviders(providers);
        }
        AnnotationContentProvider annCP = new AnnotationContentProvider(hook);
        providers.add(annCP);
    }
}

