/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.gui.filters;

import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.LockType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.gui.filters.AbstractProjectInputsFilter;
import com.ez.mainframe.gui.internal.Messages;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.report.application.model.ProgramInput;
import com.ez.report.application.ui.collectors.ProgramsCollector;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.ui.wizard.SelectProgramsPage;
import com.ez.workspace.analysis.AbstractAnalysis;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectInputsFilter
extends AbstractProjectInputsFilter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ProjectInputsFilter.class);
    protected ProjectInfo prjInfo;

    @Override
    protected PrepareReportWizard getWizard() {
        PrepareReportWizard wizard = null;
        if (wizard == null) {
            wizard = new PrepareReportWizard();
            String wizardName = Messages.getString(ProjectInputsFilter.class, "wizard.title");
            wizard.setWindowTitle(wizardName);
            SelectProgramsPage selectProgramsPage = new SelectProgramsPage("programs page", true, false);
            ProgramsCollector pc = new ProgramsCollector();
            pc.setProgramsQuery(Utils.AVAILABLE_PROGRAMS_4FUJITSU_QUERY);
            selectProgramsPage.setResourcesCollector(pc);
            selectProgramsPage.setTitle(Messages.getString(ProjectInputsFilter.class, "page.title"));
            selectProgramsPage.setDescription(Messages.getString(ProjectInputsFilter.class, "page.description"));
            wizard.addPage((IWizardPage)selectProgramsPage);
        }
        return wizard;
    }

    @Override
    protected void processWizardData(PrepareReportWizard wizard, AbstractAnalysis analysis) throws Exception {
        List selected = wizard.getList("selected resources");
        if (selected != null) {
            HashSet<String> parents = new HashSet<String>();
            ArrayList<ProgramInput> toComplete = new ArrayList<ProgramInput>();
            ArrayList<EZEntityID> list = new ArrayList<EZEntityID>();
            ProjectInfo prjInfo = (ProjectInfo)analysis.getContextValue("PROJECT_INFO");
            EZSourceProjectIDSg prjIdSg = new EZSourceProjectIDSg(prjInfo);
            for (ProgramInput pi : selected) {
                if (pi.getTypeCode() == 8 || pi.getTypeCode() == 13) {
                    parents.add(pi.getName());
                    toComplete.add(pi);
                    continue;
                }
                EZEntityID entity = new EZEntityID();
                entity.addSegment((EZSegment)prjIdSg);
                EZSourceProgramIDSg prgIdSg = new EZSourceProgramIDSg(pi.getName(), pi.getProgramID(), pi.getTypeCode());
                entity.addSegment((EZSegment)prgIdSg);
                list.add(entity);
            }
            this.setConToAddChildren(prjIdSg, parents, toComplete, list);
            analysis.addContextValue("input_list", list);
        }
    }

    protected void setConToAddChildren(final EZSourceProjectIDSg prjIdSg, final Set<String> parents, final List<ProgramInput> toComplete, final List<EZEntityID> list) throws Exception {
        if (!parents.isEmpty()) {
            IMFConnectionService service = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
            IMFProjectHandler ph = service.getProjectHandler(prjIdSg.getProjectName(), null);
            ph.executeWithLock(ph, new IMFRunnable(){

                public void run(EZSourceConnection conn, IProgressMonitor pmonitor) {
                    ProjectInputsFilter.this.addAssemblerSCLChildren(conn, parents, toComplete, list, prjIdSg);
                }
            }, LockType.Shared, (IProgressMonitor)new NullProgressMonitor());
        }
    }
}

