/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.gui.filters;

import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceNativeException;
import com.ez.ezsource.connection.ServerType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.internal.utils.LogUtil;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.filters.InputsFilter;
import com.ez.mainframe.gui.internal.Activator;
import com.ez.mainframe.gui.internal.Messages;
import com.ez.report.application.model.BaseMainframeResource4GUI;
import com.ez.report.application.model.PrgOrIncludeWithPathInput;
import com.ez.report.application.model.ProgramInput;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.ui.wizard.ReportWizardDialog;
import com.ez.workspace.analysis.AbstractAnalysis;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProjectInputsFilter
implements InputsFilter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(AbstractProjectInputsFilter.class);
    public static final int DIALOG_MIN_HEIGHT = 550;
    public static final int DIALOG_MIN_WIDTH = 700;

    public static String getASSEMBLER_SCL_CHILDREN_QUERY(ServerType dbEngine) {
        String tempTableName = dbEngine != null ? Utils.getTempTableName((ServerType)dbEngine, (String)"string_param_temp") : "string_param_temp";
        String query = String.format("select distinct child.ProgramName, child.ProgramTypeID, '' as appName, child.programid, parent.programname, parent.programid from programs child join programs parent on child.ancestor=parent.programname where parent.programname in (select * from %s) AND  (parent.ProgramTypeID IS NULL OR parent.ProgramTypeID NOT IN (15, 16, 19)) order by parent.programname", tempTableName);
        return query;
    }

    protected abstract PrepareReportWizard getWizard();

    protected abstract void processWizardData(PrepareReportWizard var1, AbstractAnalysis var2) throws Exception;

    public boolean filter(AbstractAnalysis analysis) {
        boolean[] result = new boolean[1];
        analysis.getContextListValue("input_list");
        String projectName = (String)analysis.getContextValue("input_project_names");
        try {
            HashMap<String, String> params;
            L.debug("before wizard");
            boolean getModel = true;
            PrepareReportWizard wizard = this.getWizard();
            L.debug("project {} is opened", (Object)projectName);
            if (projectName != null && !projectName.isEmpty()) {
                wizard.setProject(projectName);
                wizard.setWindowTitle(String.valueOf(projectName) + "  -  " + wizard.getWindowTitle());
            }
            final PrepareReportWizard wiz = wizard;
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    ReportWizardDialog dialog = AbstractProjectInputsFilter.this.getWizardDialog(wiz, wiz.getShell());
                    dialog.create();
                    dialog.setMinimumPageSize(700, 550);
                    dialog.open();
                }
            });
            if (wizard.isCanceled()) {
                getModel = false;
                result[0] = true;
            } else {
                this.processWizardData(wizard, analysis);
            }
            HashMap<String, String> hashMap = getModel ? (wizard != null ? wizard.getValues() : new HashMap<String, String>()) : (params = null);
            if (params != null) {
                params.put("project_name", projectName);
                analysis.addAllContextValues(params);
            }
            if (result[0]) {
                analysis.notifyFinish();
            }
        }
        catch (Throwable e) {
            L.error("error while executing analysis", e);
            LogUtil.displayErrorMessage((Throwable)e, (String)Messages.getString(AbstractProjectInputsFilter.class, "error.logview.message"), (String)Messages.getString(AbstractProjectInputsFilter.class, "error.logview.title"), (Plugin)Activator.getDefault(), (boolean)true);
            result[0] = true;
        }
        return result[0];
    }

    protected final void addAssemblerSCLChildren(EZSourceConnection bridge, Set<String> parents, List<ProgramInput> toComplete, List<EZEntityID> list, EZSourceProjectIDSg prjIdSg) {
        if (!parents.isEmpty()) {
            try {
                List<EZSourceDataType> types = Arrays.asList(new EZSourceDataType[parents.size()]);
                Collections.fill(types, EZSourceDataType.String);
                String[][] programs = bridge.executeSQL(AbstractProjectInputsFilter.getASSEMBLER_SCL_CHILDREN_QUERY(bridge.getProjectInfo().getDbEngine()), types, new ArrayList<String>(parents));
                HashSet<ProgramInput> programWithChildren = new HashSet<ProgramInput>();
                HashSet<ProgramInput> allPrograms = new HashSet<ProgramInput>(toComplete);
                if (programs != null && programs.length > 0) {
                    Collections.sort(toComplete);
                    int i = 0;
                    boolean cont = true;
                    while (cont) {
                        String prgName = programs[i][4];
                        ProgramInput inpt = null;
                        try {
                            inpt = toComplete.get(0);
                            L.trace("1. prgName={} ;;; inpt={}", (Object)prgName, (Object)inpt.getName());
                        }
                        catch (Exception e) {
                            L.error("1. not found prg {} to complete!", (Object)prgName, (Object)e);
                            cont = false;
                        }
                        if (inpt == null) continue;
                        int j = 0;
                        while (inpt != null && !inpt.getName().equalsIgnoreCase(prgName)) {
                            try {
                                inpt = toComplete.get(j);
                                L.trace("2. prgName={} ;;; inpt={}", (Object)prgName, (Object)inpt.getName());
                                ++j;
                            }
                            catch (Exception e) {
                                L.error("2. not found prg {} to complete!", (Object)prgName, (Object)e);
                                inpt = null;
                                cont = false;
                            }
                        }
                        if (inpt == null) continue;
                        toComplete.remove((Object)inpt);
                        while (i < programs.length && programs[i][4].equalsIgnoreCase(prgName)) {
                            String childId = programs[i][3];
                            EZEntityID entity = new EZEntityID();
                            entity.addSegment((EZSegment)prjIdSg);
                            String name = programs[i][0];
                            EZSourceProgramIDSg prgIdSg = new EZSourceProgramIDSg(name, Integer.valueOf(Integer.parseInt(childId)), Integer.valueOf(Integer.parseInt(programs[i][1])));
                            prgIdSg.setAncestorName(inpt.getName());
                            programWithChildren.add(inpt);
                            prgIdSg.setAncestorId(Integer.valueOf(programs[i][5]));
                            entity.addSegment((EZSegment)prgIdSg);
                            list.add(entity);
                            inpt.addChildId(childId);
                            prgName = programs[i][4];
                            ++i;
                        }
                        boolean bl = cont = i < programs.length;
                    }
                }
                for (ProgramInput pi : allPrograms) {
                    if (programWithChildren.contains((Object)pi)) continue;
                    EZEntityID entity = new EZEntityID();
                    entity.addSegment((EZSegment)prjIdSg);
                    EZSourceProgramIDSg prgIdSg = new EZSourceProgramIDSg(pi.getName(), pi.getProgramID(), pi.getTypeCode());
                    entity.addSegment((EZSegment)prgIdSg);
                    list.add(entity);
                }
                parents = null;
                toComplete = null;
                allPrograms = null;
            }
            catch (EZSourceNativeException e) {
                L.error("exception at getting childrens of assembler programs: {}", parents, (Object)e);
                throw e;
            }
            catch (Throwable ex) {
                L.error("completeSelectedPrograms()", ex);
            }
        }
    }

    protected ReportWizardDialog getWizardDialog(PrepareReportWizard wiz, Shell shell) {
        ReportWizardDialog dialog = new ReportWizardDialog(shell, (IWizard)wiz);
        return dialog;
    }

    protected EZSourceProgramIDSg checkAndAdd(ProgramInput inputPrg, List<BaseMainframeResource4GUI> selectedChildren, List<BaseMainframeResource4GUI> allChildren) {
        boolean addIt = false;
        if (inputPrg.getTypeCode() != 8 && inputPrg.getTypeCode() != 1) {
            addIt = true;
        } else if (selectedChildren == null || selectedChildren.isEmpty()) {
            addIt = true;
        } else {
            addIt = true;
            if (!selectedChildren.isEmpty()) {
                ProgramInput child;
                for (BaseMainframeResource4GUI child4GUI : selectedChildren) {
                    child = (ProgramInput)child4GUI.getObject();
                    if (!inputPrg.getName().equalsIgnoreCase(child.getAncestorName())) continue;
                    if (inputPrg.getTypeCode() == 1 && inputPrg.getTypeCode().equals(child.getTypeCode())) {
                        addIt = false;
                        break;
                    }
                    if (inputPrg.getTypeCode() != 8 || child.getTypeCode() != 15 && child.getTypeCode() != 16) continue;
                    addIt = false;
                    break;
                }
                if (inputPrg.getTypeCode() == 8 && addIt) {
                    for (BaseMainframeResource4GUI child4GUI : allChildren) {
                        child = (ProgramInput)child4GUI.getObject();
                        if (child.getTypeCode() != 15 && child.getTypeCode() != 16 || !inputPrg.getName().equalsIgnoreCase(child.getAncestorName())) continue;
                        addIt = false;
                        break;
                    }
                }
            }
        }
        EZSourceProgramIDSg prgIdSg = null;
        if (addIt) {
            boolean path = inputPrg instanceof PrgOrIncludeWithPathInput;
            if (path) {
                Boolean occur = ((PrgOrIncludeWithPathInput)inputPrg).getPath() != null;
                prgIdSg = new EZSourceProgramIDSg(inputPrg.getName(), inputPrg.getProgramID(), inputPrg.getTypeCode(), occur);
            } else {
                prgIdSg = new EZSourceProgramIDSg(inputPrg.getName(), inputPrg.getProgramID(), inputPrg.getTypeCode());
            }
            prgIdSg.setOdbRID(inputPrg.getOdbRID());
        }
        return addIt ? prgIdSg : null;
    }
}

