/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.gui.datasetflow;

import com.ez.mainframe.gui.internal.Messages;
import com.ez.mainframe.model.Direction;
import com.ez.report.application.ui.wizard.AbstractWizardPage;
import com.ez.workspace.preferences.WorkspacePrefUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SelectOptionsForDatasetPage
extends AbstractWizardPage {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private Text thresholdLimit;
    private Button limitButton;
    private Button backwardButton;
    private Button forwardButton;
    private Button bothButton;
    private Button infoButton;

    public SelectOptionsForDatasetPage(String pageName, boolean showReportsOptionGroup) {
        super(pageName);
        this.showReportsOptionGroup = showReportsOptionGroup;
        this.showInputsOption = showReportsOptionGroup;
        this.optionValue = Platform.getPreferencesService().getBoolean("com.ez.mainframe.reports.gui", "showInputDetails", false, null);
    }

    @Override
    protected boolean getShowAppendixValue() {
        return Platform.getPreferencesService().getBoolean("com.ez.mainframe.reports.gui", "showAppendix", false, null);
    }

    @Override
    protected void createContent(Composite composite) {
        Composite parentComposite = new Composite(composite, composite.getStyle());
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalIndent = 45;
        parentComposite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        parentComposite.setLayout((Layout)gridLayout);
        if (this.showReportsOptionGroup) {
            Group reportOptionsGroup = this.getReportOptionsGroup(parentComposite);
            gridLayout = new GridLayout(2, false);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            reportOptionsGroup.getParent().setLayout((Layout)gridLayout);
            gridData = new GridData();
            gridData.grabExcessHorizontalSpace = true;
            gridData.grabExcessVerticalSpace = true;
            gridData.horizontalAlignment = 4;
            reportOptionsGroup.getParent().setLayoutData((Object)gridData);
            gridData = new GridData();
            gridData.grabExcessHorizontalSpace = true;
            gridData.grabExcessVerticalSpace = true;
            gridData.horizontalAlignment = 4;
            reportOptionsGroup.setLayoutData((Object)gridData);
            this.createInfoArea((Composite)reportOptionsGroup);
        }
        this.createLimitGroup(parentComposite);
        this.createDirectionGroup(parentComposite);
        composite.getShell().setMinimumSize(500, 300);
    }

    private void createInfoArea(Composite parent) {
        if (this.showReportsOptionGroup) {
            ChoiceSelection cs = new ChoiceSelection();
            this.infoButton = new Button(parent, 32);
            this.infoButton.setText(Messages.getString(SelectOptionsForDatasetPage.class, "info.btn.txt"));
            this.infoButton.addSelectionListener((SelectionListener)cs);
            this.wizard.set("generate detailed information", this.infoButton.getSelection());
        }
    }

    @Override
    protected void addShowAppendixOptions(Composite optionsGroup) {
        this.defaultAddAppendixOptions(optionsGroup);
    }

    private void createLimitGroup(Composite parent) {
        IPreferenceStore store = WorkspacePrefUtils.getPreferenceStore();
        int levelLimit = store.getInt("callgraphLimitExceed");
        boolean isLimited = store.getBoolean("callgraphLevelsLimitedPreference");
        Group limitGroup = new Group(parent, 0);
        limitGroup.setText(Messages.getString(SelectOptionsForDatasetPage.class, "limit.group.txt"));
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        limitGroup.setLayoutData((Object)data);
        GridLayout gl = new GridLayout(2, false);
        limitGroup.setLayout((Layout)gl);
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isLimited = SelectOptionsForDatasetPage.this.limitButton.getSelection();
                SelectOptionsForDatasetPage.this.wizard.set("datesetflow is limited", isLimited);
                SelectOptionsForDatasetPage.this.thresholdLimit.setEnabled(isLimited);
                if (isLimited) {
                    SelectOptionsForDatasetPage.this.catchThresholdLimit();
                } else {
                    SelectOptionsForDatasetPage.this.wizard.set("datasetflow threshold", null);
                    SelectOptionsForDatasetPage.this.setErrorMessage(null);
                }
                SelectOptionsForDatasetPage.this.setPageComplete(SelectOptionsForDatasetPage.this.isPageComplete());
            }
        };
        this.limitButton = new Button((Composite)limitGroup, 32);
        data = new GridData();
        data.verticalAlignment = 1024;
        this.limitButton.setLayoutData((Object)data);
        this.limitButton.addSelectionListener((SelectionListener)selectionListener);
        this.limitButton.setText(Messages.getString(SelectOptionsForDatasetPage.class, "limit.button.txt"));
        this.limitButton.setSelection(isLimited);
        this.wizard.set("datesetflow is limited", isLimited);
        this.thresholdLimit = new Text((Composite)limitGroup, 2048);
        this.thresholdLimit.setText("" + levelLimit);
        this.wizard.set("datasetflow threshold", isLimited ? Integer.valueOf(levelLimit) : null);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.minimumWidth = 120;
        this.thresholdLimit.setLayoutData((Object)data);
        this.thresholdLimit.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectOptionsForDatasetPage.this.catchThresholdLimit();
                SelectOptionsForDatasetPage.this.setPageComplete(SelectOptionsForDatasetPage.this.isPageComplete());
            }
        });
        this.thresholdLimit.setEnabled(isLimited);
    }

    private void catchThresholdLimit() {
        block8: {
            String text = this.thresholdLimit.getText();
            String errorMsg = Messages.getString(SelectOptionsForDatasetPage.class, "level.thresold.error");
            Integer newThreshold = null;
            try {
                try {
                    newThreshold = Integer.valueOf(text);
                    if (newThreshold <= 0) {
                        this.setErrorMessage(errorMsg);
                        newThreshold = null;
                        break block8;
                    }
                    this.setErrorMessage(null);
                }
                catch (NumberFormatException numberFormatException) {
                    this.setErrorMessage(errorMsg);
                    if (newThreshold != null) {
                        this.wizard.set("datasetflow threshold", newThreshold);
                    }
                }
            }
            finally {
                if (newThreshold != null) {
                    this.wizard.set("datasetflow threshold", newThreshold);
                }
            }
        }
    }

    private void createDirectionGroup(Composite parent) {
        ChoiceSelection cs = new ChoiceSelection();
        Group directionGroup = new Group(parent, 0);
        directionGroup.setText(Messages.getString(SelectOptionsForDatasetPage.class, "direction.group.txt"));
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        directionGroup.setLayoutData((Object)data);
        GridLayout gl = new GridLayout(3, true);
        directionGroup.setLayout((Layout)gl);
        this.forwardButton = new Button((Composite)directionGroup, 16);
        this.forwardButton.setText(Messages.getString(SelectOptionsForDatasetPage.class, "forward.btn.txt"));
        this.forwardButton.setSelection(false);
        this.forwardButton.addSelectionListener((SelectionListener)cs);
        this.forwardButton.setData((Object)Direction.FORWARD);
        this.forwardButton.setSelection(true);
        this.wizard.set("directed", Direction.FORWARD);
        data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.horizontalAlignment = 0x1000000;
        data.verticalAlignment = 1024;
        data.minimumWidth = 95;
        this.forwardButton.setLayoutData((Object)data);
        this.backwardButton = new Button((Composite)directionGroup, 16);
        this.backwardButton.setText(Messages.getString(SelectOptionsForDatasetPage.class, "backward.btn.txt"));
        this.backwardButton.setSelection(false);
        this.backwardButton.addSelectionListener((SelectionListener)cs);
        this.backwardButton.setData((Object)Direction.BACKWARD);
        data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.horizontalAlignment = 0x1000000;
        data.verticalAlignment = 1024;
        data.minimumWidth = 95;
        this.backwardButton.setLayoutData((Object)data);
        this.bothButton = new Button((Composite)directionGroup, 16);
        this.bothButton.setText(Messages.getString(SelectOptionsForDatasetPage.class, "both.btn.txt"));
        this.bothButton.setSelection(false);
        this.bothButton.addSelectionListener((SelectionListener)cs);
        this.bothButton.setData((Object)Direction.BOTH);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = false;
        data.horizontalAlignment = 0x1000000;
        data.verticalAlignment = 1024;
        data.minimumWidth = 95;
        this.bothButton.setLayoutData((Object)data);
    }

    public boolean isPageComplete() {
        boolean ret = true;
        if (this.wizard.getValue("directed") == null) {
            return false;
        }
        if (this.getErrorMessage() != null) {
            return false;
        }
        return ret;
    }

    @Override
    protected void checkAppendix() {
        super.checkAppendix();
        boolean showAppendix = this.btnAppendix.getSelection();
        if (this.btnShowInputs != null) {
            this.btnShowInputs.setEnabled(showAppendix);
        }
    }

    @Override
    protected void checkOnlySummary() {
        super.checkOnlySummary();
        boolean selected = this.btnSummary.getSelection();
        if (this.btnShowInputs != null) {
            this.btnShowInputs.setEnabled(selected ? this.btnAppendix.getSelection() : true);
        }
    }

    class ChoiceSelection
    implements SelectionListener {
        ChoiceSelection() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Button b = (Button)e.getSource();
            if (!b.equals(SelectOptionsForDatasetPage.this.infoButton) && b.getSelection()) {
                Direction direction = (Direction)b.getData();
                SelectOptionsForDatasetPage.this.wizard.set("directed", direction);
            }
            if (SelectOptionsForDatasetPage.this.showReportsOptionGroup) {
                SelectOptionsForDatasetPage.this.wizard.set("generate detailed information", SelectOptionsForDatasetPage.this.infoButton.getSelection());
            }
            SelectOptionsForDatasetPage.this.setPageComplete(SelectOptionsForDatasetPage.this.isPageComplete());
        }
    }
}

