/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.gui.datasetflow;

import com.ez.common.ui.listselection.IOperationHandler;
import com.ez.common.ui.listselection.ListChangeEvent;
import com.ez.common.ui.listselection.ListChangeListener;
import com.ez.common.ui.listselection.ListSelectionUI;
import com.ez.common.ui.listselection.Listable;
import com.ez.common.ui.listselection.WizardLongOpeerationHandler;
import com.ez.mainframe.gui.internal.Messages;
import com.ez.mainframe.model.Direction;
import com.ez.report.application.ui.wizard.SelectProgramsPage;
import com.ez.workspace.preferences.WorkspacePrefUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SelectDatasetsAndDirectionPage<T extends Listable>
extends SelectProgramsPage<T> {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    public static final String NOT_SELECTED_DATASETS = "not selected datasets";
    public static final String EXCLUDED_DATASETS = "excluded datasets";
    private boolean showSelectDirection = true;
    private boolean showInfoButton = true;
    private boolean showLimit = true;
    private Button backwardButton;
    private Button forwardButton;
    private Button bothButton;
    private Button infoButton;
    private boolean showAppendixVal = false;
    private Text thresholdLimit;
    private Button limitButton;

    public SelectDatasetsAndDirectionPage(String pageName, String pageTitle, String pageDescription, boolean showSelectDirection) {
        this(pageName, pageTitle, pageDescription, showSelectDirection, true, true);
    }

    public SelectDatasetsAndDirectionPage(String pageName, String pageTitle, String pageDescription, boolean showSelectDirection, boolean showInfoButton, boolean showLimit) {
        super(pageName, pageTitle, pageDescription);
        this.showSelectDirection = showSelectDirection;
        this.showInfoButton = showInfoButton;
        this.showLimit = showLimit;
        this.optionValue = Platform.getPreferencesService().getBoolean("com.ez.mainframe.reports.gui", "showInputDetails", false, null);
    }

    public SelectDatasetsAndDirectionPage(String pageName) {
        super(pageName);
        this.showReportsOptionGroup = true;
        this.showInputsOption = true;
        this.showLimit = true;
        this.optionValue = Platform.getPreferencesService().getBoolean("com.ez.mainframe.reports.gui", "showInputDetails", false, null);
    }

    @Override
    protected void createContent(Composite composite) {
        this.propertiesGroup = new ListSelectionUI.Builder(composite).useFilters(this.isUseFilters()).useImport(this.isUseImport()).operationWorker((IOperationHandler)new WizardLongOpeerationHandler(true, false, this.getWizard())).createInstance();
        this.propertiesGroup.addChangeListener(new ListChangeListener(){

            public void listChangeEventHappend(ListChangeEvent listChangeEv) {
                List notSelected = SelectDatasetsAndDirectionPage.this.propertiesGroup.getAvObjectList();
                SelectDatasetsAndDirectionPage.this.wizard.set(SelectDatasetsAndDirectionPage.NOT_SELECTED_DATASETS, notSelected);
                ArrayList selected = new ArrayList(SelectDatasetsAndDirectionPage.this.propertiesGroup.getSelObjectList());
                if (SelectDatasetsAndDirectionPage.this.showSelectDirection) {
                    SelectDatasetsAndDirectionPage.this.wizard.set("selected resources", selected);
                } else {
                    SelectDatasetsAndDirectionPage.this.wizard.set(SelectDatasetsAndDirectionPage.EXCLUDED_DATASETS, selected);
                }
                SelectDatasetsAndDirectionPage.this.setPageComplete(SelectDatasetsAndDirectionPage.this.isPageComplete());
            }
        });
        if (this.leftLabel != null) {
            ((ListSelectionUI)this.propertiesGroup).setLeftGroupLabel(this.leftLabel);
        }
        if (this.rightLabel != null) {
            ((ListSelectionUI)this.propertiesGroup).setRightGroupLabel(this.rightLabel);
        }
        SelectionAdapter sa = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isLimited = SelectDatasetsAndDirectionPage.this.saveLimitInWizard();
                SelectDatasetsAndDirectionPage.this.thresholdLimit.setEnabled(isLimited);
                if (isLimited) {
                    SelectDatasetsAndDirectionPage.this.catchThresholdLimit();
                } else {
                    SelectDatasetsAndDirectionPage.this.wizard.set("datasetflow threshold", null);
                    SelectDatasetsAndDirectionPage.this.setErrorMessage(null);
                }
                SelectDatasetsAndDirectionPage.this.setPageComplete(SelectDatasetsAndDirectionPage.this.isPageComplete());
            }
        };
        Composite options = null;
        if (this.showInfoButton) {
            this.createInfoArea((Composite)this.getReportOptionsGroup(composite));
            options = new Composite(this.getReportOptionsGroup(composite).getParent(), 0);
        } else {
            options = new Composite(composite, 0);
        }
        options.setLayoutData((Object)new GridData(896));
        options.setLayout((Layout)new GridLayout(3, false));
        if (this.showLimit) {
            this.createLimitGroup(options, (SelectionListener)sa);
        }
        if (this.showSelectDirection) {
            this.createDirectionGroup(options);
        }
        composite.getShell().setMinimumSize(700, 500);
    }

    private void createLimitGroup(Composite parent, SelectionListener limitSelection) {
        IPreferenceStore store = WorkspacePrefUtils.getPreferenceStore();
        int levelLimit = store.getInt("callgraphLimitExceed");
        boolean isLimited = store.getBoolean("callgraphLevelsLimitedPreference");
        Group limitGroup = new Group(parent, 0);
        limitGroup.setText(Messages.getString(SelectDatasetsAndDirectionPage.class, "limit.group.txt"));
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 131072;
        data.verticalAlignment = 1024;
        data.minimumWidth = 80;
        limitGroup.setLayoutData((Object)data);
        GridLayout gl = new GridLayout(2, false);
        limitGroup.setLayout((Layout)gl);
        this.limitButton = new Button((Composite)limitGroup, 32);
        data = new GridData();
        data.verticalAlignment = 1024;
        this.limitButton.setLayoutData((Object)data);
        this.limitButton.addSelectionListener(limitSelection);
        this.limitButton.setText(Messages.getString(SelectDatasetsAndDirectionPage.class, "limit.button.txt"));
        this.limitButton.setSelection(isLimited);
        this.wizard.set("datesetflow is limited", isLimited);
        this.thresholdLimit = new Text((Composite)limitGroup, 2048);
        this.thresholdLimit.setText("" + levelLimit);
        this.wizard.set("datasetflow threshold", isLimited ? Integer.valueOf(levelLimit) : null);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = false;
        data.minimumWidth = 120;
        this.thresholdLimit.setLayoutData((Object)data);
        this.thresholdLimit.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectDatasetsAndDirectionPage.this.catchThresholdLimit();
                SelectDatasetsAndDirectionPage.this.setPageComplete(SelectDatasetsAndDirectionPage.this.isPageComplete());
            }
        });
        this.thresholdLimit.setEnabled(isLimited);
    }

    private void catchThresholdLimit() {
        block8: {
            String text = this.thresholdLimit.getText();
            String errorMsg = Messages.getString(SelectDatasetsAndDirectionPage.class, "level.thresold.error");
            Integer newThreshold = null;
            try {
                try {
                    newThreshold = Integer.valueOf(text);
                    if (newThreshold <= 0) {
                        this.setErrorMessage(errorMsg);
                        newThreshold = null;
                        break block8;
                    }
                    this.setErrorMessage(null);
                }
                catch (NumberFormatException numberFormatException) {
                    this.setErrorMessage(errorMsg);
                    if (newThreshold != null) {
                        this.wizard.set("datasetflow threshold", newThreshold);
                    }
                }
            }
            finally {
                if (newThreshold != null) {
                    this.wizard.set("datasetflow threshold", newThreshold);
                }
            }
        }
    }

    private void createInfoArea(Composite parent) {
        if (this.showInfoButton) {
            ChoiceSelection cs = new ChoiceSelection();
            this.infoButton = new Button(parent, 32);
            this.infoButton.setText(Messages.getString(SelectDatasetsAndDirectionPage.class, "info.btn.txt"));
            this.infoButton.addSelectionListener((SelectionListener)cs);
            this.wizard.set("generate detailed information", this.infoButton.getSelection());
        }
    }

    private void createDirectionGroup(Composite fakeParent) {
        ChoiceSelection cs = new ChoiceSelection();
        Group directionGroup = new Group(fakeParent, 0);
        directionGroup.setText(Messages.getString(SelectDatasetsAndDirectionPage.class, "direction.group.txt"));
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = false;
        data.horizontalAlignment = 131072;
        data.verticalAlignment = 1024;
        directionGroup.setLayoutData((Object)data);
        GridLayout gl = new GridLayout(3, false);
        directionGroup.setLayout((Layout)gl);
        data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.horizontalAlignment = 0x1000000;
        data.verticalAlignment = 1024;
        data.minimumWidth = 90;
        this.forwardButton = new Button((Composite)directionGroup, 16);
        this.forwardButton.setText(Messages.getString(SelectDatasetsAndDirectionPage.class, "forward.btn.txt"));
        this.forwardButton.setSelection(false);
        this.forwardButton.setLayoutData((Object)data);
        this.forwardButton.addSelectionListener((SelectionListener)cs);
        this.forwardButton.setData((Object)Direction.FORWARD);
        this.forwardButton.setSelection(true);
        this.wizard.set("directed", Direction.FORWARD);
        this.backwardButton = new Button((Composite)directionGroup, 16);
        this.backwardButton.setText(Messages.getString(SelectDatasetsAndDirectionPage.class, "backward.btn.txt"));
        this.backwardButton.setSelection(false);
        data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.horizontalAlignment = 0x1000000;
        data.verticalAlignment = 1024;
        data.minimumWidth = 90;
        this.backwardButton.setLayoutData((Object)data);
        this.backwardButton.addSelectionListener((SelectionListener)cs);
        this.backwardButton.setData((Object)Direction.BACKWARD);
        this.bothButton = new Button((Composite)directionGroup, 16);
        this.bothButton.setText(Messages.getString(SelectDatasetsAndDirectionPage.class, "both.btn.txt"));
        this.bothButton.setSelection(false);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = false;
        data.horizontalAlignment = 0x1000000;
        data.verticalAlignment = 1024;
        data.minimumWidth = 90;
        this.bothButton.setLayoutData((Object)data);
        this.bothButton.addSelectionListener((SelectionListener)cs);
        this.bothButton.setData((Object)Direction.BOTH);
    }

    @Override
    public boolean isPageComplete() {
        if (this.showSelectDirection) {
            boolean ret = super.isPageComplete();
            if (ret) {
                ret = this.wizard.getValue("directed") == null ? false : this.getErrorMessage() == null;
            }
            return ret;
        }
        return true;
    }

    @Override
    public void setVisible(boolean visible) {
        ArrayList availableDatasetsList;
        super.setVisible(visible);
        if (this.showSelectDirection && visible) {
            availableDatasetsList = new ArrayList();
            ArrayList selectedDatasetsList = new ArrayList();
            if (this.wizard.getList(NOT_SELECTED_DATASETS) != null) {
                availableDatasetsList.addAll(this.wizard.getList(NOT_SELECTED_DATASETS));
            }
            if (this.wizard.getList("selected resources") != null) {
                selectedDatasetsList.addAll(this.wizard.getList("selected resources"));
            }
            this.propertiesGroup.clearUILists();
            this.propertiesGroup.setAvList(availableDatasetsList);
            this.propertiesGroup.setSelList(selectedDatasetsList);
        }
        if (!this.showSelectDirection && visible) {
            availableDatasetsList = new ArrayList();
            ArrayList excludedDatasetsList = new ArrayList();
            if (this.wizard.getList(NOT_SELECTED_DATASETS) != null) {
                availableDatasetsList.addAll(this.wizard.getList(NOT_SELECTED_DATASETS));
            }
            if (this.wizard.getList(EXCLUDED_DATASETS) != null) {
                excludedDatasetsList.addAll(this.wizard.getList(EXCLUDED_DATASETS));
            }
            this.propertiesGroup.clearUILists();
            this.propertiesGroup.setAvList(availableDatasetsList);
            this.propertiesGroup.setSelList(excludedDatasetsList);
        }
    }

    @Override
    protected boolean getShowAppendixValue() {
        return this.showAppendixVal;
    }

    public void setShowAppendixValue(boolean val) {
        this.showAppendixVal = val;
    }

    public boolean saveLimitInWizard() {
        boolean isLimited = this.limitButton.getSelection();
        this.wizard.set("datesetflow is limited", isLimited);
        return isLimited;
    }

    class ChoiceSelection
    implements SelectionListener {
        ChoiceSelection() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Button b = (Button)e.getSource();
            if (!b.equals(SelectDatasetsAndDirectionPage.this.infoButton) && b.getSelection()) {
                Direction direction = (Direction)b.getData();
                SelectDatasetsAndDirectionPage.this.wizard.set("directed", direction);
            }
            if (SelectDatasetsAndDirectionPage.this.showInfoButton) {
                SelectDatasetsAndDirectionPage.this.wizard.set("generate detailed information", SelectDatasetsAndDirectionPage.this.infoButton.getSelection());
            }
            SelectDatasetsAndDirectionPage.this.setPageComplete(SelectDatasetsAndDirectionPage.this.isPageComplete());
        }
    }
}

