/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.gui.datasetflow;

import com.ez.mainframe.gui.datasetflow.CustomSerializer;
import com.ez.mainframe.gui.datasetflow.InfoData;
import com.ez.report.application.utils.mapDB.PersistentCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import org.mapdb.Serializer;
import org.mapdb.serializer.GroupSerializer;
import org.mapdb.serializer.SerializerArrayTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentMap
extends PersistentCollection
implements Map<String, Iterable<InfoData>> {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(PersistentMap.class);
    private NavigableSet<Object[]> map;

    PersistentMap(int cacheSize) {
        super(PersistentMap.class, cacheSize);
        this.createMap();
    }

    private void createMap() {
        this.map = (NavigableSet)this.db.treeSet("map").counterEnable().serializer((GroupSerializer)new SerializerArrayTuple(new Serializer[]{Serializer.STRING, new CustomSerializer()}, new Comparator[]{String.CASE_INSENSITIVE_ORDER, new Comparator<InfoData>(){

            @Override
            public int compare(InfoData o1, InfoData o2) {
                return o1.compareTo(o2);
            }
        }})).create();
    }

    @Override
    public int size() {
        int size = this.map.size();
        L.trace("size={}", (Object)size);
        return size;
    }

    public void add(InfoData data) {
        this.map.add(new Object[]{data.name1, data});
        if (L.isTraceEnabled()) {
            boolean hasValues = this.hasValues(data.name1);
            L.trace("{} hasValues={}", (Object)data.name1, (Object)hasValues);
            Object val = this.get(data.name1);
            if (val.iterator().next() != null) {
                L.trace("next={}", (Object)((InfoData)val.iterator().next()).name1);
            } else {
                L.trace("next null for {}", (Object)data);
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.map != null && this.map.isEmpty();
    }

    @Override
    public Iterable<InfoData> get(Object id) {
        Iterable<InfoData> iterable = null;
        String idAsString = (String)id;
        Object[] objectArray = new Object[2];
        objectArray[0] = idAsString;
        SortedSet<Object[]> mapSubset = this.map.subSet(new Object[]{idAsString}, objectArray);
        if (!mapSubset.isEmpty()) {
            ArrayList vals = new ArrayList();
            mapSubset.forEach((? super T s) -> {
                boolean bl = vals.add((InfoData)s[1]);
            });
            iterable = () -> vals.iterator();
        } else {
            iterable = Collections.emptyList();
        }
        return iterable;
    }

    public boolean hasValues(String listableName) {
        Object val = this.get(listableName);
        boolean ret = val != null && val.iterator() != null && val.iterator().hasNext();
        return ret;
    }

    @Override
    public boolean containsKey(Object key) {
        L.warn("not implemented!");
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        L.warn("containsValue() is not implemented!");
        return false;
    }

    @Override
    public Set<Map.Entry<String, Iterable<InfoData>>> entrySet() {
        L.warn("entrySet() is not implemented!");
        return null;
    }

    @Override
    public Set<String> keySet() {
        L.warn("keySet() is not implemented!");
        return null;
    }

    @Override
    public Iterable<InfoData> put(String key, Iterable<InfoData> value) {
        L.warn("put() is not implemented!");
        return null;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Iterable<InfoData>> m) {
        L.warn("putAll() is not implemented!");
    }

    @Override
    public Iterable<InfoData> remove(Object key) {
        L.warn("remove() is not implemented!");
        return null;
    }

    @Override
    public Collection<Iterable<InfoData>> values() {
        L.warn("values() is not implemented!");
        return null;
    }
}

