/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.gui.datasetflow;

import com.ez.internal.analysis.config.inputs.EZSourceDataset;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.gui.datasetflow.DSFlowEdgeLegendInfo;
import com.ez.mainframe.gui.datasetflow.DSFlowNodeLegendInfo;
import com.ez.mainframe.gui.datasetflow.InfoData;
import com.ez.mainframe.gui.datasetflow.PersistentMap;
import com.ez.mainframe.gui.internal.Messages;
import com.ez.mainframe.gui.properties.DatasetNode;
import com.ez.mainframe.model.Direction;
import com.ez.mainframe.model.dataset.VSAMInput;
import com.ez.workspace.analysis.graph.EZNodeBuilder;
import com.ez.workspace.model.segments.EZSourceDatasetIDSg;
import com.tomsawyer.drawing.geometry.shared.TSPolygonShape;
import com.tomsawyer.drawing.geometry.shared.TSShape;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graphicaldrawing.TSEEdge;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.graphicaldrawing.TSEGraphManager;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.graphicaldrawing.awt.TSEFont;
import com.tomsawyer.graphicaldrawing.builder.TSNodeBuilder;
import com.tomsawyer.graphicaldrawing.ui.TSNodeUI;
import com.tomsawyer.graphicaldrawing.ui.composite.TSCompositeNodeUI;
import com.tomsawyer.graphicaldrawing.ui.composite.element.shared.TSGroupUIElement;
import com.tomsawyer.graphicaldrawing.ui.composite.element.shared.TSOvalUIElement;
import com.tomsawyer.graphicaldrawing.ui.composite.element.shared.TSShapeTextUIElement;
import com.tomsawyer.graphicaldrawing.ui.composite.element.shared.TSShapeUIElement;
import com.tomsawyer.graphicaldrawing.ui.composite.element.shared.TSSwitchUIElement;
import com.tomsawyer.graphicaldrawing.ui.composite.element.shared.TSUIElement;
import com.tomsawyer.util.shared.TSProperty;
import java.awt.Font;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class DatasetGraphBuilder {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(DatasetGraphBuilder.class);
    private static final String TEXT_COLOR = "Text_Color";
    private static final String FILL_COLOR = "Fill_Color";
    private TSNodeBuilder nodeBuilder;
    private TSEGraphManager gmanager;
    private Runnable stopCode;

    public DatasetGraphBuilder(Runnable stopCode) {
        this.nodeBuilder = new EZNodeBuilder();
        this.nodeBuilder.setResizability(3);
        this.nodeBuilder.setShape((TSShape)TSPolygonShape.getInstance((String)"rrect"));
        this.gmanager = new TSEGraphManager();
        this.gmanager.setNodeBuilder(this.nodeBuilder);
        this.stopCode = stopCode;
    }

    public DatasetGraphBuilder(Runnable stopCode, TSEGraphManager gmanager) {
        this.stopCode = stopCode;
        this.gmanager = gmanager;
        this.nodeBuilder = gmanager.getNodeBuilder();
        this.nodeBuilder.setResizability(3);
        this.nodeBuilder.setShape((TSShape)TSPolygonShape.getInstance((String)"rrect"));
    }

    public boolean fillTSGraph(VSAMInput input, Map<String, Iterable<InfoData>> rez, TSEGraph graph, IProgressMonitor pmonitor) {
        return this.fillTSGraph((Collection<VSAMInput>)new ArrayList<VSAMInput>(input){
            {
                this.add(vSAMInput);
            }
        }, rez, graph, null, pmonitor);
    }

    public boolean fillTSGraph(Collection<VSAMInput> inputNames, Map<String, Iterable<InfoData>> rez, TSEGraph graph, Map<String, Set<TSENode>> inventoryNodes, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.subTask(Messages.getString(DatasetGraphBuilder.class, "createGraph.subtask"));
        if (graph == null) {
            L.debug("no graph; add a new one");
            graph = (TSEGraph)this.gmanager.addGraph();
        }
        TSEEdge edge = null;
        TSENode sourceNode = null;
        TSENode destNode = null;
        HashMap<String, TSENode> allNodes = new HashMap<String, TSENode>();
        LinkedList<String> toExpand = new LinkedList<String>();
        HashSet<String> visited = new HashSet<String>();
        TSENode node = null;
        Set nodeTypesSetForLegend = (Set)this.gmanager.getAttributeValue("node types set for legend");
        Set edgeTypesSetForLegend = (Set)this.gmanager.getAttributeValue("edge types set for legend");
        String category = DSFlowNodeLegendInfo.DATASET.getLegendLabel();
        for (VSAMInput vsamInput : inputNames) {
            String iName = vsamInput.getListableName();
            String iMemberName = vsamInput.getMemberName();
            Integer iGenerationNumber = vsamInput.getGenerationNumber();
            node = this.nodeBuilder.addNode(graph);
            node.setAttribute(FILL_COLOR, (Object)DSFlowNodeLegendInfo.INPUT_DATASET.getTSEColor());
            node.setName((Object)iName);
            node.setAttribute("drawing", (Object)"roundtext");
            node.setAttribute("HAS_PROPERTIES_IN_PROPVIEW", (Object)true);
            this.setPropertiesViewer(node, iName, iMemberName, iGenerationNumber, ResultElementType.DATASET.getDisplayName());
            this.createApplicableInputType(node, iName, vsamInput.getResourceID());
            allNodes.put(iName, node);
            this.register(inventoryNodes, category, node);
            toExpand.add(iName);
        }
        if (nodeTypesSetForLegend != null) {
            nodeTypesSetForLegend.add(DSFlowNodeLegendInfo.INPUT_DATASET);
        }
        this.stopCode.run();
        boolean hasGraph = false;
        while (!toExpand.isEmpty()) {
            boolean isLeaf;
            String nodeName = (String)toExpand.remove(0);
            if (visited.contains(nodeName)) continue;
            if (allNodes.containsKey(nodeName)) {
                sourceNode = (TSENode)allNodes.get(nodeName);
            } else {
                sourceNode = this.nodeBuilder.addNode(graph);
                sourceNode.setAttribute(FILL_COLOR, (Object)DSFlowNodeLegendInfo.DATASET.getTSEColor());
                sourceNode.setName((Object)nodeName);
                sourceNode.setAttribute("drawing", (Object)"roundtext");
                allNodes.put(nodeName, sourceNode);
                this.register(inventoryNodes, category, sourceNode);
                if (nodeTypesSetForLegend != null) {
                    nodeTypesSetForLegend.add(DSFlowNodeLegendInfo.DATASET);
                }
            }
            visited.add(nodeName);
            boolean bl = isLeaf = !((PersistentMap)rez).hasValues(nodeName);
            if (isLeaf) continue;
            hasGraph = true;
            Iterable<InfoData> infoList = rez.get(nodeName);
            for (InfoData info : infoList) {
                Direction cfr_ignored_0 = info.direction;
                String dest = info.name2;
                if (allNodes.containsKey(dest)) {
                    destNode = (TSENode)allNodes.get(dest);
                } else {
                    destNode = this.nodeBuilder.addNode(graph);
                    destNode.setName((Object)dest);
                    destNode.setAttribute(FILL_COLOR, (Object)DSFlowNodeLegendInfo.DATASET.getTSEColor());
                    destNode.setAttribute("drawing", (Object)"roundtext");
                    this.createApplicableInputType(destNode, dest, Integer.parseInt(info.id2));
                    allNodes.put(dest, destNode);
                    this.register(inventoryNodes, category, destNode);
                    if (nodeTypesSetForLegend != null) {
                        nodeTypesSetForLegend.add(DSFlowNodeLegendInfo.DATASET);
                    }
                }
                if (!visited.contains(dest)) {
                    toExpand.add(dest);
                }
                boolean edgeAlreadyDraw = false;
                edgeAlreadyDraw = this.edgeAlreadyDrawn(destNode, sourceNode);
                if (!edgeAlreadyDraw) {
                    edge = (TSEEdge)this.gmanager.addEdge((TSNode)sourceNode, (TSNode)destNode);
                    edge.setAttribute("Color", (Object)DSFlowEdgeLegendInfo.DATA_FLOW.getTSEColor());
                    if (edgeTypesSetForLegend != null) {
                        edgeTypesSetForLegend.add(DSFlowEdgeLegendInfo.DATA_FLOW);
                    }
                }
                this.stopCode.run();
            }
        }
        allNodes.clear();
        visited.clear();
        monitor.done();
        return hasGraph;
    }

    private void createApplicableInputType(TSENode node, String dsWithMemberName, Integer dsId) {
        if (!node.hasAttribute("APPLICABLE_INPUT")) {
            EZSourceDataset inputtype = new EZSourceDataset();
            inputtype.addProperty("holds the load modules of the program to be executed in the JCL", (Object)Boolean.FALSE);
            String dsMemberName = "";
            String dsName = dsWithMemberName;
            if (dsWithMemberName.endsWith(")") && dsWithMemberName.indexOf("(") > 0) {
                int lastIndexOf = dsWithMemberName.lastIndexOf("(");
                dsName = dsWithMemberName.substring(0, lastIndexOf);
                dsMemberName = dsWithMemberName.substring(lastIndexOf + 1, dsWithMemberName.length() - 1);
            }
            inputtype.setName(dsName);
            EZEntityID entID = new EZEntityID();
            inputtype.setEntID(entID);
            Integer genNumber = null;
            EZSourceDatasetIDSg sg = new EZSourceDatasetIDSg(dsName, dsId, dsMemberName, genNumber);
            sg.setIncompleteSegment(true);
            entID.addSegment((EZSegment)sg);
            inputtype.addProperty("mainframe resource id sg", (Object)sg);
            node.setAttribute("APPLICABLE_INPUT", (Object)inputtype);
            node.setAttribute("HAS_PROPERTIES_IN_PROPVIEW", (Object)true);
            this.setPropertiesViewer(node, dsName, dsMemberName, genNumber, ResultElementType.DATASET.toString());
        }
    }

    private boolean edgeAlreadyDrawn(TSENode sourceNode, TSENode destNode) {
        boolean edgeAlreadyDraw = false;
        List edges = sourceNode.inEdges();
        for (TSEEdge e : edges) {
            if (!e.getSourceNode().equals(destNode)) continue;
            edgeAlreadyDraw = true;
            break;
        }
        return edgeAlreadyDraw;
    }

    private void createUI(TSNodeBuilder nodeBuilder) {
        TSCompositeNodeUI nodeUI = new TSCompositeNodeUI();
        TSGroupUIElement rootElement = new TSGroupUIElement();
        nodeUI.setRootElement((TSUIElement)rootElement);
        TSGroupUIElement textGrElement = new TSGroupUIElement();
        TSShapeUIElement shapeElement = new TSShapeUIElement();
        textGrElement.addElement((TSUIElement)shapeElement);
        nodeUI.getStyle().setProperty((TSUIElement)shapeElement, "TIGHT_WIDTH", (Serializable)new Double(20.0));
        nodeUI.getStyle().setProperty((TSUIElement)shapeElement, "TIGHT_HEIGHT", (Serializable)new Double(20.0));
        nodeUI.getStyle().setProperty((TSUIElement)shapeElement, "FILL_COLOR", (Serializable)((Object)"<Fill_Color>"));
        nodeUI.getStyle().setProperty((TSUIElement)shapeElement, "LINE_WIDTH", (Serializable)Double.valueOf(0.01));
        TSShapeTextUIElement textElement = new TSShapeTextUIElement();
        textElement.setProperty(new TSProperty("text", (Object)"$tag()"));
        nodeUI.getStyle().setProperty((TSUIElement)textElement, "TEXT_COLOR", (Serializable)((Object)"<Text_Color>"));
        nodeUI.getStyle().setProperty((TSUIElement)textElement, "TEXT_FONT", (Serializable)new TSEFont(new Font("SansSerif", 0, 16)));
        nodeUI.getStyle().setProperty((TSUIElement)textElement, "TEXT_TRUNCATION_ENABLED", (Serializable)Boolean.FALSE);
        textGrElement.addElement((TSUIElement)textElement);
        TSSwitchUIElement switchElementType = new TSSwitchUIElement();
        switchElementType.setFunction("$valueOf(drawing)");
        switchElementType.addChild("roundtext", (TSUIElement)textGrElement);
        TSOvalUIElement oval = new TSOvalUIElement();
        switchElementType.addChild("guguloi", (TSUIElement)oval);
        rootElement.addElement((TSUIElement)switchElementType);
        nodeBuilder.setNodeUI((TSNodeUI)nodeUI);
    }

    public TSEGraphManager getGraphManager() {
        return this.gmanager;
    }

    public void clear() {
        this.gmanager.clear();
    }

    public void dispose() {
        this.gmanager.dispose();
    }

    private void register(Map<String, Set<TSENode>> map, String inventoryCategory, TSENode tsNode) {
        if (map == null) {
            return;
        }
        Set<TSENode> nodes = map.get(inventoryCategory);
        if (nodes == null) {
            nodes = new HashSet<TSENode>();
            map.put(inventoryCategory, nodes);
        }
        nodes.add(tsNode);
    }

    private void setPropertiesViewer(TSENode resourceNode, String resourceName, String resMemberName, Integer resGenerationNumber, String resourceType) {
        resourceNode.setAttribute("Node_Mainframe", (Object)new DatasetNode(resourceName, resMemberName, resGenerationNumber, resourceType));
    }
}

