/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.gui.datasetflow;

import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceAuthorizationConnectionException;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.ezsource.connection.EZSourceNativeException;
import com.ez.internal.utils.Pair;
import com.ez.internal.utils.Quartet;
import com.ez.internal.utils.Sextet;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.gui.datasetflow.IValidator;
import com.ez.mainframe.gui.datasetflow.InfoData;
import com.ez.mainframe.gui.datasetflow.PersistentMap;
import com.ez.mainframe.gui.internal.MainframeGUIErrorLog;
import com.ez.mainframe.gui.internal.Messages;
import com.ez.mainframe.gui.utils.DatasetUtils;
import com.ez.mainframe.model.Direction;
import com.ez.mainframe.model.dataset.MultipleVSAMInput;
import com.ez.mainframe.model.dataset.VSAMInput;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasetFlow {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(DatasetFlow.class);
    private Direction direction;
    private List<VSAMInput> inputs;
    private List<VSAMInput> excludedDS;
    private Set<String> excluded = new HashSet<String>();
    private int limit = -1;
    private static final String DD_FOR_PROGRAMS_SP = "EZViewer_JCLGetUseInProgsAndFdd";
    private static final String EZReports_DatasetFlow_JCLInfo = "EZReports_DatasetFlow_JCLInfo";
    private Set<Pair<String, Direction>> d1 = new HashSet<Pair<String, Direction>>();
    private Set<Pair<String, Direction>> steps = new HashSet<Pair<String, Direction>>();
    private PersistentMap d2 = new PersistentMap(512);
    private List<Sextet<Integer, String, Direction, Integer, String[], String>> d3 = new ArrayList<Sextet<Integer, String, Direction, Integer, String[], String>>();
    private Map<String, String[][]> writes = new HashMap<String, String[][]>();
    Map<String, String[][]> cardsforproc = new HashMap<String, String[][]>();
    private final int NOT_SPECIAL = -1;
    private final int SORTIN = 100;
    private final int SORTOUT = 200;
    private final int SORTOF = 300;
    private final int SDSETO = 400;
    private final int SDSETI = 500;
    private final int SBDSETI = 600;
    private final int SBDSETO = 700;
    private final int INFILE = 800;
    private final int OUTFIL = 900;
    private final int SYSUT1 = 1000;
    private final int SYSUT2 = 1100;
    private IValidator validator = null;

    public DatasetFlow(Direction direction) {
        this.direction = direction;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setValidator(IValidator validator) {
        this.validator = validator;
    }

    public void find(EZSourceConnection conn, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        L.debug("find datasetflow in direction: {}", (Object)this.direction);
        if (this.inputs == null || this.inputs.size() == 0) {
            return;
        }
        this.completeAllDbidForDSName(conn);
        this.initialize();
        String taskName = this.inputs.size() == 1 ? Messages.getString(DatasetFlow.class, "acquiringData.withParameter.progress.taskName", new String[]{this.inputs.get(0).getName()}) : Messages.getString(DatasetFlow.class, "acquiringData.progress.taskName");
        while (!this.d3.isEmpty()) {
            Sextet<Integer, String, Direction, Integer, String[], String> t = this.d3.remove(0);
            L.debug((String)t.getSecond());
            if (monitor.isCanceled()) break;
            Integer level = (Integer)t.getFourth();
            if (this.limit == -1 || this.limit > 0 && level < this.limit) {
                monitor.setTaskName(taskName);
                this.step2(t, conn, (IProgressMonitor)monitor);
            }
            L.debug("d2 queue size: {}", (Object)this.d2.size());
            L.debug("d3 queue size: {}", (Object)this.d3.size());
        }
        monitor.setTaskName(Messages.getString(DatasetFlow.class, "dataAcquired.taskName"));
        this.d1.clear();
        this.d3.clear();
        this.writes.clear();
        this.cardsforproc.clear();
        this.steps.clear();
        this.inputs = null;
        this.excludedDS = null;
        this.excluded.clear();
    }

    private void completeAllDbidForDSName(EZSourceConnection conn) {
        if (this.inputs.get(0) instanceof MultipleVSAMInput && ((MultipleVSAMInput)this.inputs.get(0)).isIncomplete()) {
            DatasetFlow.checkInputs(conn, this.inputs);
        }
    }

    public static Collection<MultipleVSAMInput> checkInputs(EZSourceConnection conn, List<VSAMInput> inputs) {
        HashMap<String, MultipleVSAMInput> dsNames = new HashMap<String, MultipleVSAMInput>();
        for (VSAMInput inp : inputs) {
            dsNames.put(inp.getName(), (MultipleVSAMInput)inp);
        }
        List<EZSourceDataType> types = Arrays.asList(new EZSourceDataType[dsNames.size()]);
        Collections.fill(types, EZSourceDataType.String);
        String[][] infoToCompleteInputs = conn.executeSQL(DatasetUtils.getDatasetInputInfoQuery(conn.getProjectInfo().getDbEngine()), types, new ArrayList(dsNames.keySet()));
        if (infoToCompleteInputs != null) {
            String[][] stringArray = infoToCompleteInputs;
            int n = infoToCompleteInputs.length;
            int n2 = 0;
            while (n2 < n) {
                String[] info = stringArray[n2];
                MultipleVSAMInput inp = (MultipleVSAMInput)dsNames.get(info[1]);
                inp.addInfo(Integer.valueOf(info[0]), info[2]);
                ++n2;
            }
        } else {
            dsNames.clear();
        }
        return dsNames.values();
    }

    private void print(PrintStream ps) {
        System.out.println("---------------------------");
    }

    private void printToFile(File f) {
        try {
            f.delete();
            PrintStream ps = new PrintStream(f);
            this.print(ps);
            ps.close();
        }
        catch (Exception e) {
            L.error("Error:", (Throwable)e);
        }
    }

    private void initialize() {
        for (VSAMInput input : this.inputs) {
            for (Integer dbId : input.getIds()) {
                Sextet t = new Sextet((Object)dbId, (Object)input.getName(), null, (Object)0, (Object)input.getExtra(), (Object)input.getMemberName());
                L.trace("initialize: (d1) new pair: name {} , direction: {}", t.getSecond(), t.getThird());
                this.d1.add((Pair<String, Direction>)new Pair((Object)this.getKeyForD1((String)t.getSecond(), String.valueOf(t.getFirst()), (String)t.getSixth()), (Object)((Direction)t.getThird())));
                switch (this.direction) {
                    case FORWARD: {
                        t.setThird((Object)Direction.FORWARD);
                        this.d3.add((Sextet<Integer, String, Direction, Integer, String[], String>)t);
                        break;
                    }
                    case BACKWARD: {
                        t.setThird((Object)Direction.BACKWARD);
                        this.d3.add((Sextet<Integer, String, Direction, Integer, String[], String>)t);
                        break;
                    }
                    case BOTH: {
                        t.setThird((Object)Direction.FORWARD);
                        this.d3.add((Sextet<Integer, String, Direction, Integer, String[], String>)t);
                        t = new Sextet((Object)dbId, (Object)input.getName(), (Object)Direction.BACKWARD, (Object)0, (Object)input.getExtra(), (Object)input.getMemberName());
                        this.d3.add((Sextet<Integer, String, Direction, Integer, String[], String>)t);
                        break;
                    }
                }
            }
        }
        if (this.excludedDS != null) {
            for (VSAMInput ex : this.excludedDS) {
                this.excluded.add(ex.getName());
            }
        }
    }

    private boolean isExcluded(String datasetName) {
        return this.excluded.contains(datasetName);
    }

    private void step2(Sextet<Integer, String, Direction, Integer, String[], String> t, EZSourceConnection conn, IProgressMonitor monitor) {
        block18: {
            String cDDName = (String)t.getSecond();
            Integer cfr_ignored_0 = (Integer)t.getFirst();
            Direction direction = (Direction)t.getThird();
            String[] params = new String[]{String.valueOf(t.getFirst()), t.getSixth() != null ? (String)t.getSixth() : ""};
            Integer cfr_ignored_1 = (Integer)t.getFourth();
            String[] cfr_ignored_2 = (String[])t.getFifth();
            String[][] repResults = null;
            try {
                repResults = conn.execNonTransactionalStoredProc(EZReports_DatasetFlow_JCLInfo, params);
                if (repResults == null) break block18;
                int max = repResults.length;
                int cr = 0;
                String[][] stringArray = repResults;
                int n = repResults.length;
                int n2 = 0;
                while (n2 < n) {
                    Pair p;
                    Direction d;
                    String[] cols = stringArray[n2];
                    if (monitor.isCanceled()) break;
                    monitor.subTask(Messages.getString(DatasetFlow.class, "processingData.subtask", new Object[]{cDDName, cr * 100 / max}));
                    ++cr;
                    String path = cols[0];
                    String lineInProc = cols[1];
                    String procName = cols[14];
                    String cfr_ignored_3 = cols[15];
                    String prgId = cols[17];
                    String ddName = cols[11];
                    String stepId = cols[24];
                    String jclCalledPgmName = cols[16];
                    String jobId = cols[13];
                    String ordinalInJob = cols[25];
                    boolean hasProgram = Utils.filterNullValue((String)prgId) != null;
                    boolean dirOk = true;
                    if (hasProgram && ((d = this.getDataDirection(jclCalledPgmName, prgId, ddName, conn)) == null || !d.equals((Object)Direction.BOTH) && !d.equals((Object)direction))) {
                        dirOk = false;
                    }
                    if (!this.steps.contains(p = new Pair((Object)(String.valueOf(stepId) + "|" + cDDName + "|" + prgId), (Object)direction))) {
                        this.steps.add((Pair<String, Direction>)p);
                        if (this.validator == null || this.validator.isAcceptable(t, cols)) {
                            String[][] cardsForProc = null;
                            String jobName = cols[12];
                            if (Utils.filterNullValue((String)stepId) != null) {
                                if (!this.cardsforproc.containsKey(stepId)) {
                                    cardsForProc = this.getCardsForProc(stepId, conn);
                                    this.cardsforproc.put(stepId, cardsForProc);
                                } else {
                                    cardsForProc = this.cardsforproc.get(stepId);
                                }
                            }
                            if (cardsForProc != null) {
                                HashMap<String, List<String[]>> steps = new HashMap<String, List<String[]>>();
                                HashMap<String, HashSet<Quartet>> dsData = new HashMap<String, HashSet<Quartet>>();
                                int i = 0;
                                while (i < cardsForProc.length) {
                                    boolean special;
                                    if (monitor.isCanceled()) break;
                                    String[] cs = cardsForProc[i];
                                    String cddn = cs[3];
                                    String cfr_ignored_4 = cs[1];
                                    Quartet currentDSData = null;
                                    if (hasProgram) {
                                        String datasetn = cs[4];
                                        String datasetid = cs[5];
                                        String dsMemberName = cs[8];
                                        currentDSData = new Quartet((Object)datasetn, (Object)datasetid, (Object)dsMemberName, (Object)cs);
                                    }
                                    if (hasProgram && dirOk) {
                                        HashSet<Quartet> datasets = (HashSet<Quartet>)dsData.get(cddn);
                                        if (datasets == null) {
                                            datasets = new HashSet<Quartet>();
                                            dsData.put(cddn, datasets);
                                        }
                                        datasets.add(currentDSData);
                                    }
                                    boolean bl = special = this.getSpecial(cddn) != -1;
                                    if (special && this.isUtility(jclCalledPgmName)) {
                                        ArrayList<String[]> l = (ArrayList<String[]>)steps.get(stepId);
                                        if (l == null) {
                                            l = new ArrayList<String[]>();
                                            steps.put(stepId, l);
                                        }
                                        l.add(cs);
                                    }
                                    ++i;
                                }
                                for (String cddn : dsData.keySet()) {
                                    this.processPrograms(t, prgId, cddn, (Set)dsData.get(cddn), jobName, jobId, procName, path, lineInProc, ordinalInJob, jclCalledPgmName, conn);
                                }
                                if (monitor.isCanceled()) break;
                                this.processUtilities(jobName, procName, path, lineInProc, steps, t, jclCalledPgmName, jobId, conn);
                            }
                            monitor.subTask("");
                            repResults[cr - 1] = null;
                        }
                    }
                    ++n2;
                }
            }
            catch (EZSourceNativeException e) {
                L.error("can't retrieve data from Application Discovery Build", (Throwable)e);
            }
        }
    }

    private boolean isUtility(String name) {
        return name.equalsIgnoreCase("SORT") || name.equalsIgnoreCase("DB#FTPTRN") || name.equalsIgnoreCase("SBRDWT") || name.equalsIgnoreCase("RWRDWT") || name.equalsIgnoreCase("EZTPA00") || name.equalsIgnoreCase("IEBGENER") || name.equalsIgnoreCase("ICEGENER") || name.equalsIgnoreCase("IEBCOPY") || name.equalsIgnoreCase("IEBDG") || name.equalsIgnoreCase("IEBPTPCH") || name.equalsIgnoreCase("IEBUPDTE");
    }

    private Direction getDataDirection(String pgmName, String prgId, String ddName, EZSourceConnection conn) {
        String[][] rwCols = this.getReadWriteStatus(prgId, ddName, conn);
        Direction d = null;
        if (rwCols == null) {
            if (ddName.toLowerCase().contains("out")) {
                d = Direction.BACKWARD;
            }
            if (ddName.toLowerCase().contains("in")) {
                d = Direction.FORWARD;
            }
            if (d == null) {
                return null;
            }
        }
        if (d == null) {
            String[][] stringArray = rwCols;
            int n = rwCols.length;
            int n2 = 0;
            while (n2 < n) {
                String[] cols = stringArray[n2];
                Direction dd = this.convertDirection(cols[3]);
                if (dd != null) {
                    if (d != null && dd != d) {
                        d = Direction.BOTH;
                        break;
                    }
                    d = dd;
                } else {
                    L.error("invalid direction for prgI{}, ddname={} : {}", new Object[]{prgId, ddName, Arrays.deepToString((Object[])rwCols)});
                }
                ++n2;
            }
        }
        return d;
    }

    private Direction convertDirection(String dirCode) {
        int dir = 0;
        try {
            dir = Integer.valueOf(dirCode);
        }
        catch (NumberFormatException numberFormatException) {
            L.error("incorrect direction from Application Discovery Build: {}", (Object)dirCode);
            return null;
        }
        Direction d = null;
        if ((dir & 1) == 1 || (dir & 0x10) == 16) {
            d = Direction.FORWARD;
        }
        if ((dir & 2) == 2 || (dir & 4) == 4 || (dir & 0x20) == 32) {
            d = Direction.BACKWARD;
        }
        if ((dir & 3) == 3 || (dir & 8) == 8) {
            d = Direction.BOTH;
        }
        return d;
    }

    private String[][] getCardsForProc(String stepId, EZSourceConnection conn) {
        String[][] cards = null;
        ArrayList<String> list = new ArrayList<String>();
        list.add(stepId);
        List<EZSourceDataType> types = Arrays.asList(new EZSourceDataType[list.size()]);
        Collections.fill(types, EZSourceDataType.Integer);
        try {
            cards = conn.execNonTransactionalStoredProc("EZReports_DatasetFlow_DDCards_Of_Step", new String[0], types, list);
        }
        catch (EZSourceAuthorizationConnectionException ex) {
            L.error("license authorization failed", (Throwable)ex);
            MainframeGUIErrorLog.err(ex.getMessage(), ex);
        }
        catch (EZSourceConnectionException ex) {
            L.error("exception while getting bridge connection", (Throwable)ex);
            MainframeGUIErrorLog.err(ex.getMessage(), ex);
        }
        return cards;
    }

    private int getSpecial(String ddn) {
        int rez = -1;
        if (ddn.equalsIgnoreCase("sortin")) {
            return 100;
        }
        if (ddn.equalsIgnoreCase("sortout")) {
            return 200;
        }
        if (ddn.equalsIgnoreCase("INFILE")) {
            return 800;
        }
        if (ddn.toUpperCase().startsWith("OUTFIL")) {
            return 900;
        }
        if (ddn.equalsIgnoreCase("SYSUT1")) {
            return 1000;
        }
        if (ddn.equalsIgnoreCase("SYSUT2")) {
            return 1100;
        }
        String[] prefix = new String[]{"SORTOF", "SDSETO", "SDSETI", "SBDSETI", "SBDSETO"};
        int i = 0;
        while (i < prefix.length) {
            if (ddn.toUpperCase().startsWith(prefix[i])) {
                String suf = ddn.substring(prefix[i].length(), ddn.length());
                if (suf.length() == 2) {
                    if (Character.isDigit(suf.charAt(0)) && Character.isDigit(suf.charAt(1))) {
                        return 300 + i * 100 + Integer.valueOf(suf);
                    }
                } else if (suf.length() == 0) {
                    return 300 + i * 100;
                }
            }
            ++i;
        }
        return rez;
    }

    private boolean is(int target, int what) {
        int dif = what - target;
        if (dif < 0) {
            return false;
        }
        return dif <= 99;
    }

    private void processUtilities(String jobName, String procName, String path, String lineInProc, Map<String, List<String[]>> steps, Sextet<Integer, String, Direction, Integer, String[], String> t, String jclCalledPgmName, String jobId, EZSourceConnection conn) {
        String cDatasetName = (String)t.getSecond();
        Direction cDirection = (Direction)t.getThird();
        Integer cDSId = (Integer)t.getFirst();
        String csDSId = cDSId.toString();
        String cDsMemberName = (String)t.getSixth();
        for (String stepid : steps.keySet()) {
            String ddn;
            List<String[]> entries = steps.get(stepid);
            int type = -1;
            for (String[] cols : entries) {
                String id = cols[5];
                if (!id.equals(csDSId)) continue;
                ddn = cols[3];
                type = this.getSpecial(ddn);
                if (Direction.FORWARD == cDirection && (this.is(100, type) || this.is(500, type) || this.is(600, type) || this.is(800, type) || this.is(1000, type)) || Direction.BACKWARD == cDirection && (this.is(300, type) || this.is(200, type) || this.is(400, type) || this.is(700, type) || this.is(900, type) || this.is(1100, type))) break;
                type = -1;
            }
            if (type == -1) continue;
            boolean found = false;
            for (String[] cols : entries) {
                ddn = cols[3];
                String pgmName = jclCalledPgmName;
                int cType = this.getSpecial(ddn);
                boolean add = false;
                try {
                    add = this.arePair(type, cType);
                }
                catch (Exception exception) {
                    L.debug("type={} and cType={} are not pair", (Object)type, (Object)cType);
                    break;
                }
                if (!add) continue;
                InfoData info = new InfoData();
                info.isProgram = false;
                info.id1 = csDSId;
                info.id2 = cols[5];
                info.name1 = this.getDSWithMember(cDatasetName, cDsMemberName);
                info.name2 = this.getDSWithMember(cols[4], cols[8]);
                info.stepName = cols[1];
                info.jobName = jobName;
                info.pgmName = pgmName;
                info.direction = cDirection;
                info.procName = procName != null && (procName.equals("-1") || procName.equals("0")) ? "" : procName;
                info.lineInProc = lineInProc;
                info.cardInfo = cols;
                info.path = path;
                this.addToD2(info);
                L.trace("processUtilities: (d1) new pair: name {}, direction: {}", (Object)cols[4], (Object)cDirection);
                Pair p = new Pair((Object)this.getKeyForD1(cols[4], cols[5], cols[8]), (Object)cDirection);
                if (!this.isExcluded(cols[4]) && this.d1.add((Pair<String, Direction>)p)) {
                    Sextet tt = new Sextet();
                    tt.setFirst((Object)Integer.parseInt(cols[5]));
                    tt.setSecond((Object)cols[4]);
                    tt.setThird((Object)cDirection);
                    tt.setFourth((Object)((Integer)t.getFourth() + 1));
                    tt.setFifth((Object)new String[]{jobId, cols[0], cols[7], info.jobName});
                    tt.setSixth((Object)cols[8]);
                    this.d3.add((Sextet<Integer, String, Direction, Integer, String[], String>)tt);
                }
                found = true;
            }
            if (found || !this.is(100, type) && !this.is(500, type)) continue;
            String[][] res = null;
            try {
                ArrayList<String> list = new ArrayList<String>();
                list.add(stepid);
                List<EZSourceDataType> types = Arrays.asList(new EZSourceDataType[list.size()]);
                Collections.fill(types, EZSourceDataType.Integer);
                res = conn.execNonTransactionalStoredProc("EZReports_DatasetFlow_DDCards_Of_Step_2", new String[0], types, list);
            }
            catch (EZSourceNativeException e) {
                L.error("can't retrieve data from Application Discovery Build", (Throwable)e);
            }
            for (String[] cols : entries) {
                int l = this.getLine(cols, res, type);
                InfoData info = new InfoData();
                info.isProgram = false;
                info.id1 = csDSId;
                info.id2 = "-1";
                info.name1 = this.getDSWithMember(cDatasetName, cDsMemberName);
                info.name2 = "Printer";
                info.stepName = cols[1];
                info.jobName = jobName;
                info.pgmName = jclCalledPgmName;
                info.direction = cDirection;
                info.procName = procName != null && (procName.equals("-1") || procName.equals("0")) ? "" : procName;
                info.lineInProc = lineInProc;
                info.path = path;
                if (l != -1) {
                    cols[10] = res[l][5];
                    cols[11] = res[l][6];
                }
                info.cardInfo = cols;
                this.addToD2(info);
            }
        }
    }

    private int getLine(String[] cols, String[][] res, int type) {
        if (res != null) {
            int i = 0;
            while (i < res.length) {
                if (res[i][4].equals(cols[9]) && res[i][5].equals(cols[10])) {
                    String ddn = res[i][1];
                    int cType = this.getSpecial(ddn);
                    boolean pair = false;
                    try {
                        pair = this.arePair(type, cType);
                    }
                    catch (Exception exception) {
                        L.debug("getLine(): type={} and cType={} are not pair", (Object)type, (Object)cType);
                    }
                    if (pair) {
                        return i;
                    }
                }
                ++i;
            }
        }
        return -1;
    }

    private boolean arePair(int type, int cType) throws Exception {
        boolean add = false;
        if (this.is(100, cType)) {
            if (this.is(300, type) || this.is(200, type)) {
                add = true;
            }
        } else if (this.is(300, cType) || this.is(200, cType)) {
            if (this.is(100, type)) {
                add = true;
            }
        } else if (this.is(500, cType) || this.is(600, cType)) {
            if (this.is(400, type) && cType - 500 == type - 400) {
                add = true;
            }
            if (this.is(700, type) && cType - 600 == type - 700) {
                add = true;
            }
        } else if (this.is(400, cType) || this.is(700, cType)) {
            if (this.is(500, type) && cType - 400 == type - 500) {
                add = true;
            }
            if (this.is(600, type) && cType - 700 == type - 600) {
                add = true;
            }
        } else if (this.is(800, cType)) {
            if (this.is(900, type)) {
                add = true;
            }
        } else if (this.is(900, cType)) {
            if (this.is(800, type)) {
                add = true;
            }
        } else if (this.is(1000, cType)) {
            if (this.is(1100, type)) {
                add = true;
            }
        } else if (this.is(1100, cType)) {
            if (this.is(1000, type)) {
                add = true;
            }
        } else {
            throw new Exception("");
        }
        return add;
    }

    private void addToD2(InfoData info) {
        this.d2.add(info);
    }

    private void processPrograms(Sextet<Integer, String, Direction, Integer, String[], String> t, String prgId, String ddName, Set<Quartet<String, String, String, String[]>> datasetInfo, String jobName, String jobId, String procName, String path, String lineInProc, String ordinalInJob, String calledPgm, EZSourceConnection conn) {
        Direction d = (Direction)t.getThird();
        String cDatasetName = (String)t.getSecond();
        Integer cDatasetId = (Integer)t.getFirst();
        String cDsMemberName = (String)t.getSixth();
        String[][] rez2 = this.getReadWriteStatus(prgId, ddName, conn);
        if (rez2 != null) {
            String[][] stringArray = rez2;
            int n = rez2.length;
            int n2 = 0;
            while (n2 < n) {
                String[] cols = stringArray[n2];
                Direction targetDirection = null;
                targetDirection = this.convertDirection(cols[3]);
                if (targetDirection != null && (!d.equals((Object)targetDirection) || targetDirection.equals((Object)Direction.BOTH))) {
                    for (Quartet<String, String, String, String[]> dsInfo : datasetInfo) {
                        String datasetid = (String)dsInfo.getSecond();
                        String datasetName = (String)dsInfo.getFirst();
                        String dsMemberName = (String)dsInfo.getThird();
                        String[] cardInfo = (String[])dsInfo.getFourth();
                        String stepId = cardInfo[0];
                        String stepName = cardInfo[1];
                        boolean added = false;
                        Pair p = new Pair((Object)this.getKeyForD1(datasetName, datasetid, dsMemberName), (Object)d);
                        if (!datasetid.equals(cDatasetId.toString())) {
                            Pair sp = new Pair((Object)(String.valueOf(stepId) + "|" + datasetName + "|" + prgId), (Object)d);
                            if (!this.steps.contains(sp)) {
                                if (targetDirection == Direction.BOTH) {
                                    this.steps.add((Pair<String, Direction>)sp);
                                }
                                added = true;
                            }
                            InfoData info = new InfoData();
                            info.isProgram = true;
                            info.direction = d;
                            info.id1 = cDatasetId.toString();
                            info.id2 = datasetid;
                            info.name1 = this.getDSWithMember(cDatasetName, cDsMemberName);
                            info.name2 = this.getDSWithMember(datasetName, dsMemberName);
                            info.pgmName = cols[0];
                            info.jobName = jobName;
                            info.procName = procName != null && (procName.equals("-1") || procName.equals("0")) ? "" : procName;
                            info.lineInProc = lineInProc;
                            info.stepName = stepName;
                            info.pgmPath = cols[4];
                            info.pgmLine = cols[5];
                            info.cardInfo = cardInfo;
                            info.path = path;
                            this.addToD2(info);
                        }
                        if (this.isExcluded(datasetName) || this.isInD1((Pair<String, Direction>)p) || !added) continue;
                        L.trace("processPrograms: (d1) new pair: name {}, direction: {}", (Object)datasetName, (Object)d);
                        this.d1.add((Pair<String, Direction>)p);
                        Sextet t2 = new Sextet();
                        t2.setFirst((Object)Integer.parseInt(datasetid));
                        t2.setSecond((Object)datasetName);
                        t2.setThird((Object)d);
                        t2.setFourth((Object)((Integer)t.getFourth() + 1));
                        t2.setFifth((Object)new String[]{jobId, stepId, ordinalInJob, jobName});
                        t2.setSixth((Object)dsMemberName);
                        this.d3.add((Sextet<Integer, String, Direction, Integer, String[], String>)t2);
                    }
                }
                ++n2;
            }
        } else if (!this.isUtility(calledPgm)) {
            String pgmName = null;
            Direction targetDir = null;
            if (ddName.equalsIgnoreCase("SORTOUT") || ddName.toUpperCase().startsWith("SORTOF")) {
                pgmName = "SORT";
                targetDir = Direction.BACKWARD;
            }
            if (ddName.equalsIgnoreCase("SORTIN")) {
                pgmName = "SORT";
                targetDir = Direction.FORWARD;
            }
            if (pgmName != null) {
                this.addExtra(t, datasetInfo, jobName, jobId, procName, lineInProc, ordinalInJob, d, cDatasetName, cDatasetId, cDsMemberName, pgmName, targetDir, prgId);
            }
        }
    }

    private void addExtra(Sextet<Integer, String, Direction, Integer, String[], String> t, Set<Quartet<String, String, String, String[]>> datasetInfo, String jobName, String jobId, String procName, String lineInProc, String ordinalInJob, Direction d, String cDatasetName, Integer cDatasetId, String cDsMemberName, String pgmName, Direction targetDirection, String prgId) {
        for (Quartet<String, String, String, String[]> dsInfo : datasetInfo) {
            String datasetid = (String)dsInfo.getSecond();
            String datasetName = (String)dsInfo.getFirst();
            String dsMemberName = (String)dsInfo.getThird();
            String[] cardInfo = (String[])dsInfo.getFourth();
            String stepId = cardInfo[0];
            String stepName = cardInfo[1];
            boolean added = false;
            if (cDatasetId == Integer.parseInt(datasetid)) continue;
            String dsKey = this.getKeyForD1(datasetName, datasetid, dsMemberName);
            Pair p = new Pair((Object)dsKey, (Object)d);
            Pair sp = new Pair((Object)(String.valueOf(stepId) + "|" + datasetName + "|" + prgId), (Object)d);
            if (!this.steps.contains(sp)) {
                if (targetDirection == Direction.BOTH) {
                    this.steps.add((Pair<String, Direction>)sp);
                }
                added = true;
            }
            InfoData info = new InfoData();
            info.isProgram = false;
            info.id1 = cDatasetId.toString();
            info.id2 = datasetid;
            info.name1 = this.getDSWithMember(cDatasetName, cDsMemberName);
            info.name2 = this.getDSWithMember(datasetName, dsMemberName);
            info.stepName = stepName;
            info.jobName = jobName;
            info.pgmName = pgmName;
            info.direction = d;
            info.procName = procName != null && (procName.equals("-1") || procName.equals("0")) ? "" : procName;
            info.lineInProc = lineInProc;
            info.cardInfo = cardInfo;
            this.addToD2(info);
            if (this.isExcluded(datasetName) || this.isInD1((Pair<String, Direction>)p) || !added || this.isExcluded(datasetName) || !this.d1.add((Pair<String, Direction>)p)) continue;
            Sextet tt = new Sextet();
            tt.setFirst((Object)Integer.parseInt(datasetid));
            tt.setSecond((Object)datasetName);
            tt.setThird((Object)d);
            tt.setFourth((Object)((Integer)t.getFourth() + 1));
            tt.setFifth((Object)new String[]{jobId, stepId, ordinalInJob, info.jobName});
            tt.setSixth((Object)dsMemberName);
            this.d3.add((Sextet<Integer, String, Direction, Integer, String[], String>)tt);
        }
    }

    private String getDSWithMember(String datasetName, String dsMemberName) {
        return dsMemberName != null && !dsMemberName.isEmpty() ? String.valueOf(datasetName) + "(" + dsMemberName + ")" : datasetName;
    }

    private String getKeyForD1(String datasetName, String datasetid, String dsMemberName) {
        String dsKey = dsMemberName == null ? String.valueOf(datasetName) + datasetid : String.valueOf(datasetName) + datasetid + dsMemberName;
        return dsKey;
    }

    private boolean isInD1(Pair<String, Direction> p) {
        boolean b = this.d1.contains(p);
        if (L.isTraceEnabled()) {
            L.trace("check in D1 for: {} and direction: {} found: {}", new Object[]{p.getFirst(), p.getSecond(), b});
        }
        return b;
    }

    private String[][] getReadWriteStatus(String prgId, String ddName, EZSourceConnection conn) {
        String[][] rez2 = null;
        try {
            if (this.writes.containsKey(String.valueOf(prgId) + ddName)) {
                rez2 = this.writes.get(String.valueOf(prgId) + ddName);
            } else {
                String[][] prgCgResults = conn.execNonTransactionalStoredProc("EZViewer_CalledProgramID", new Object[]{Integer.valueOf(prgId), 1});
                ArrayList<String> params2 = new ArrayList<String>();
                params2.add(prgId);
                List<Object> types = null;
                if (prgCgResults != null) {
                    types = Arrays.asList(new EZSourceDataType[prgCgResults.length + 1]);
                    Collections.fill(types, EZSourceDataType.Integer);
                    String[][] stringArray = prgCgResults;
                    int n = prgCgResults.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String[] rez = stringArray[n2];
                        params2.add(rez[1]);
                        ++n2;
                    }
                }
                if (types == null) {
                    types = new ArrayList();
                    types.add(EZSourceDataType.Integer);
                }
                if ((rez2 = conn.execNonTransactionalStoredProc(DD_FOR_PROGRAMS_SP, new String[]{ddName}, types, params2)) != null) {
                    this.writes.put(String.valueOf(prgId) + ddName, rez2);
                }
            }
        }
        catch (EZSourceNativeException ex) {
            L.error("can't get readstatus", (Throwable)ex);
        }
        return rez2;
    }

    public Map<String, Iterable<InfoData>> getResults() {
        return this.d2;
    }

    public void setInputs(List<VSAMInput> inputs) {
        this.inputs = inputs;
    }

    public void setExcludes(List<VSAMInput> excludedDS) {
        this.excludedDS = excludedDS;
    }
}

