/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.gui.datasetflow;

import com.ez.mainframe.gui.datasetflow.InfoData;
import com.ez.mainframe.model.Direction;
import java.io.IOException;
import java.io.Serializable;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomSerializer
implements Serializer<InfoData>,
Serializable {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(CustomSerializer.class);
    private static final String NULL_VALUE = "EZ_NULL_VALUE";

    public InfoData deserialize(DataInput2 in, int arg1) throws IOException {
        InfoData data = null;
        try {
            String tmp;
            if (arg1 == 0) {
                L.trace("{}", (Object)0);
            }
            if ("null_object".equals(tmp = in.readUTF())) {
                L.trace("deser null");
            } else {
                data = new InfoData();
                if (!NULL_VALUE.equals(tmp)) {
                    data.id1 = tmp;
                }
                if (!NULL_VALUE.equals(tmp = in.readUTF())) {
                    data.name1 = tmp;
                }
                if (!NULL_VALUE.equals(tmp = in.readUTF())) {
                    data.id2 = tmp;
                }
                if (!NULL_VALUE.equals(tmp = in.readUTF())) {
                    data.name2 = tmp;
                }
                if (!NULL_VALUE.equals(tmp = in.readUTF())) {
                    int size = Integer.valueOf(tmp);
                    data.cardInfo = new String[size];
                    int i = 0;
                    while (i < size) {
                        data.cardInfo[i] = tmp = in.readUTF();
                        ++i;
                    }
                }
                if (!NULL_VALUE.equals(tmp = in.readUTF())) {
                    data.jobName = tmp;
                }
                if (!NULL_VALUE.equals(tmp = in.readUTF())) {
                    data.pgmName = tmp;
                }
                int dir = in.readInt();
                data.direction = Direction.values()[dir];
                tmp = in.readUTF();
                if (!NULL_VALUE.equals(tmp)) {
                    data.stepName = tmp;
                }
                if (!NULL_VALUE.equals(tmp = in.readUTF())) {
                    data.procName = tmp;
                }
                if (!NULL_VALUE.equals(tmp = in.readUTF())) {
                    data.lineInProc = tmp;
                }
                if (!NULL_VALUE.equals(tmp = in.readUTF())) {
                    data.pgmPath = tmp;
                }
                if (!NULL_VALUE.equals(tmp = in.readUTF())) {
                    data.pgmLine = tmp;
                }
                data.isProgram = in.readBoolean();
            }
        }
        catch (Exception ex) {
            L.error("exception at serialization; ignored", (Throwable)ex);
        }
        return data;
    }

    public int fixedSize() {
        return -1;
    }

    public void serialize(DataOutput2 out, InfoData data) throws IOException {
        try {
            if (data == null) {
                L.debug("stop; null_object");
                out.writeUTF("null_object");
            } else {
                if (data.id1 == null) {
                    out.writeUTF(NULL_VALUE);
                } else {
                    out.writeUTF(data.id1);
                }
                if (data.name1 == null) {
                    out.writeUTF(NULL_VALUE);
                } else {
                    out.writeUTF(data.name1);
                }
                if (data.id2 == null) {
                    out.writeUTF(NULL_VALUE);
                } else {
                    out.writeUTF(data.id2);
                }
                if (data.name2 == null) {
                    out.writeUTF(NULL_VALUE);
                } else {
                    out.writeUTF(data.name2);
                }
                if (data.cardInfo == null) {
                    out.writeUTF(NULL_VALUE);
                } else {
                    out.writeUTF("" + data.cardInfo.length);
                    int i = 0;
                    while (i < data.cardInfo.length) {
                        out.writeUTF(data.cardInfo[i]);
                        ++i;
                    }
                }
                if (data.jobName == null) {
                    out.writeUTF(NULL_VALUE);
                } else {
                    out.writeUTF(data.jobName);
                }
                if (data.pgmName == null) {
                    out.writeUTF(NULL_VALUE);
                } else {
                    out.writeUTF(data.pgmName);
                }
                if (data.direction == null) {
                    out.writeUTF(NULL_VALUE);
                } else {
                    out.writeInt(data.direction.ordinal());
                }
                if (data.stepName == null) {
                    out.writeUTF(NULL_VALUE);
                } else {
                    out.writeUTF(data.stepName);
                }
                if (data.procName == null) {
                    out.writeUTF(NULL_VALUE);
                } else {
                    out.writeUTF(data.procName);
                }
                if (data.lineInProc == null) {
                    out.writeUTF(NULL_VALUE);
                } else {
                    out.writeUTF(data.lineInProc);
                }
                if (data.pgmPath == null) {
                    out.writeUTF(NULL_VALUE);
                } else {
                    out.writeUTF(data.pgmPath);
                }
                if (data.pgmLine == null) {
                    out.writeUTF(NULL_VALUE);
                } else {
                    out.writeUTF(data.pgmLine);
                }
                out.writeBoolean(data.isProgram);
            }
        }
        catch (Exception ex) {
            L.error("exception at serialization; ignored", (Throwable)ex);
        }
    }
}

