/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.gui.annotatedresults;

import com.ez.mainframe.gui.annotatedresults.AbstractResultElement;
import com.ez.mainframe.gui.annotatedresults.AnnotationPartStateManager;
import com.ez.mainframe.gui.internal.Activator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationContext;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.swt.graphics.Image;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationUsagesDecorator
implements ILightweightLabelDecorator,
ILabelDecorator {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(AnnotationUsagesDecorator.class);
    ImageDescriptor desc = Activator.getImageDescriptor("icons/ann_overlay.gif");
    AnnotationPartStateManager annManager = null;

    public void decorate(Object element, IDecoration decoration) {
        AnnotationPartStateManager annotationPartStateManager = this.annManager = this.annManager == null ? (AnnotationPartStateManager)((DecorationContext)decoration.getDecorationContext()).getProperty("annManager") : this.annManager;
        if (element instanceof AbstractResultElement) {
            Boolean acceptAnn = (Boolean)((AbstractResultElement)element).getProperty("acceptAnn");
            L.trace("{} acceptAnn={}", element, (Object)acceptAnn);
            boolean decorate = false;
            if (acceptAnn != null && acceptAnn.booleanValue()) {
                Boolean ann = (Boolean)((AbstractResultElement)element).getProperty("annotation");
                if (ann == null) {
                    L.warn("decorator: ann not yet calculated?! {}", (Object)((AbstractResultElement)element));
                    ann = this.annManager.hasAnn((AbstractResultElement)element);
                }
                if (ann != null && ann.booleanValue()) {
                    decorate = true;
                }
                L.trace("{} hasAnn={}", element, (Object)ann);
            }
            if (decorate) {
                decoration.addOverlay(this.desc);
            }
        }
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image decorateImage(Image image, Object element) {
        return null;
    }

    public String decorateText(String text, Object element) {
        return null;
    }

    public void setAnnManager(AnnotationPartStateManager annStateManager) {
        this.annManager = annStateManager;
    }
}

