/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.gui.annotatedresults;

import com.ez.ann.db.EZAnnotationDbManager;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.utils.LogUtil;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.gui.annotatedresults.AbstractResultElement;
import com.ez.mainframe.gui.annotatedresults.AnnotatedViewer;
import com.ez.mainframe.gui.internal.Activator;
import com.ez.workspace.model.segments.EZSourceJobIDSg;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.ez.workspace.state.IPartStateManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AnnotationPartStateManager
implements IPartStateManager {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(AnnotationPartStateManager.class);
    public static final String ACCEPT_ANNOTATION_KEY = "acceptAnn";
    public static final String ANN_STATE_MANAGER_KEY = "annManager";
    protected Map<EZEntityID, Boolean> toUpdate = null;
    protected Map<EZEntityID, Set<AbstractResultElement>> needState = null;
    protected Map<EZEntityID, Boolean> currentState = new HashMap<EZEntityID, Boolean>();

    public void setCurrentState(Map<EZEntityID, Boolean> stateMap) {
        this.toUpdate = stateMap;
    }

    protected abstract AnnotatedViewer getViewer();

    public abstract boolean considerElement(AbstractResultElement var1);

    public abstract EZObjectType buildInputType(AbstractResultElement var1);

    public void dispose() {
        if (this.toUpdate != null) {
            this.toUpdate.clear();
        }
        if (this.needState != null) {
            this.needState.clear();
        }
        if (this.currentState != null) {
            this.currentState.clear();
        }
    }

    public void register(EZEntityID targetID, Object targetNode) {
        this.registerResultElement(targetID, targetNode);
        Boolean hasAnn = null;
        hasAnn = !this.currentState.containsKey(targetID) ? this.askAndCalculate((AbstractResultElement)targetNode) : this.currentState.get(targetID);
        this.updateState((AbstractResultElement)targetNode, targetID, hasAnn);
    }

    public void update() {
        L.trace("manager start the update");
        if (this.needState == null || this.needState.size() == 0) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Set<EZEntityID> resourceSet = AnnotationPartStateManager.this.needState.keySet();
                for (EZEntityID entityID : AnnotationPartStateManager.this.toUpdate.keySet()) {
                    Boolean vb = AnnotationPartStateManager.this.toUpdate.get(entityID);
                    for (EZEntityID entityID2 : resourceSet) {
                        boolean considerIt = entityID2.equals((Object)entityID);
                        if (!considerIt) {
                            EZSourceProgramIDSg prg1 = (EZSourceProgramIDSg)entityID2.getSegment(EZSourceProgramIDSg.class);
                            EZSourceProgramIDSg prg2 = (EZSourceProgramIDSg)entityID.getSegment(EZSourceProgramIDSg.class);
                            if (prg1 != null && prg2 != null) {
                                boolean bl = considerIt = prg1.getPath() != null && prg1.getPath().equalsIgnoreCase(prg2.getPath());
                                if (considerIt) {
                                    boolean bl2 = considerIt = prg1.getTypeId() != null && prg1.getTypeId().equals(prg2.getTypeId());
                                    if (considerIt) {
                                        considerIt = prg1.getProgramName() != null && prg1.getProgramName().equalsIgnoreCase(prg2.getProgramName());
                                    }
                                }
                            } else {
                                EZSourceJobIDSg j1 = (EZSourceJobIDSg)entityID2.getSegment(EZSourceJobIDSg.class);
                                EZSourceJobIDSg j2 = (EZSourceJobIDSg)entityID.getSegment(EZSourceJobIDSg.class);
                                if (j1 != null && j2 != null) {
                                    boolean bl = considerIt = j1.getPath() != null && j1.getPath().equalsIgnoreCase(j2.getPath());
                                }
                            }
                        }
                        if (!considerIt) continue;
                        Set<AbstractResultElement> targetNodes = AnnotationPartStateManager.this.needState.get(entityID2);
                        if (vb == null) {
                            L.warn("current value is null? (for: {})", (Object)entityID2);
                        }
                        for (AbstractResultElement el : targetNodes) {
                            AnnotationPartStateManager.this.updateState(el, entityID2, vb);
                        }
                        AnnotationPartStateManager.this.getViewer().updateFromAnn(targetNodes.toArray(new AbstractResultElement[0]));
                    }
                }
                AnnotationPartStateManager.this.toUpdate = null;
                L.trace("manager ends the update");
            }
        });
    }

    public void unregister(EZEntityID key, Set<AbstractResultElement> st) {
        Set<AbstractResultElement> tmp;
        if (this.needState != null && !this.needState.isEmpty() && (tmp = this.needState.get(key)) != null && !tmp.isEmpty()) {
            tmp.removeAll(st);
            if (tmp.isEmpty()) {
                this.needState.remove(key);
                this.currentState.remove(key);
            }
        }
    }

    public Boolean hasAnn(AbstractResultElement resultElem) {
        EZObjectType inputType = (EZObjectType)resultElem.getProperty("APPLICABLE_INPUT");
        if (inputType != null) {
            EZEntityID key = inputType.getEntID();
            Boolean vb = this.currentState.get(key);
            if (vb == null) {
                L.warn("null init state?! {}", (Object)resultElem);
                vb = this.askAndCalculate(resultElem);
                this.updateState(resultElem, key, vb);
                this.registerResultElement(key, resultElem);
            }
            return vb;
        }
        return false;
    }

    protected void registerResultElement(EZEntityID targetID, Object targetNode) {
        if (this.needState == null) {
            this.needState = new HashMap<EZEntityID, Set<AbstractResultElement>>();
        }
        Set<Object> targets = null;
        if (!this.needState.containsKey(targetID)) {
            targets = new HashSet();
            this.needState.put(targetID, targets);
        } else {
            targets = this.needState.get(targetID);
        }
        targets.add((AbstractResultElement)targetNode);
    }

    protected Boolean askAndCalculate(AbstractResultElement resultElem) {
        if (this.considerElement(resultElem)) {
            L.trace("ask calculate for {}", (Object)resultElem);
            boolean hasAnn = false;
            Object has = resultElem.getProperty("annotation");
            if (has == null) {
                EZObjectType inputType = this.buildInputType(resultElem);
                if (inputType != null) {
                    L.trace("start calculate for {}", (Object)resultElem);
                    hasAnn = this.hasAnn(resultElem, inputType);
                    L.trace("value calculated for {} = {}", (Object)resultElem, (Object)hasAnn);
                }
            } else {
                hasAnn = (Boolean)has;
            }
            return hasAnn;
        }
        return null;
    }

    private boolean hasAnn(AbstractResultElement resultElem, EZObjectType inputType) {
        boolean ret = false;
        try {
            String prjName;
            EZSourceProjectIDSg prjsg;
            String resTypeID = null;
            String dbid = null;
            EZSourceProgramIDSg prgsg = (EZSourceProgramIDSg)inputType.getEntID().getSegment(EZSourceProgramIDSg.class);
            if (prgsg != null) {
                resTypeID = "5";
                dbid = prgsg.getProgramId().toString();
            } else {
                EZSourceJobIDSg jobSg = (EZSourceJobIDSg)inputType.getEntID().getSegment(EZSourceJobIDSg.class);
                if (jobSg != null) {
                    resTypeID = "22";
                    dbid = jobSg.getJobId().toString();
                }
            }
            if (resTypeID != null && dbid != null && (prjsg = (EZSourceProjectIDSg)inputType.getEntID().getSegment(EZSourceProjectIDSg.class)) != null && (prjName = prjsg.getProjectName()) != null) {
                ret = EZAnnotationDbManager.getInstance().hasAnn(prjName, resTypeID, dbid);
            }
        }
        catch (SQLException e) {
            L.error("error checking annotations", (Throwable)e);
            LogUtil.log((int)2, (String)EZAnnotationDbManager.NO_ANN_DB_CONNECTION_WARNING_MSG, null, (Bundle)Activator.getDefault().getBundle());
        }
        return ret;
    }

    protected void updateState(AbstractResultElement resultElem, EZEntityID key, Boolean hasAnn) {
        Boolean vb;
        if (ResultElementType.PROGRAM.equals((Object)resultElem.getType()) && (vb = (Boolean)resultElem.getProperty("is program scl having procedure's information")) != null && vb.booleanValue()) {
            hasAnn = false;
        }
        if (hasAnn == null) {
            resultElem.addProperty(ACCEPT_ANNOTATION_KEY, false);
        } else {
            resultElem.addProperty(ACCEPT_ANNOTATION_KEY, true);
        }
        L.trace("{} oldState={}", (Object)resultElem, resultElem.getProperty("annotation"));
        L.trace("{} newState={}", (Object)resultElem, (Object)hasAnn);
        this.currentState.put(key, hasAnn);
        resultElem.addProperty("annotation", hasAnn);
    }
}

