/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.gui.annotatedresults;

import com.ez.analysisbrowser.actions.IResultViewer;
import com.ez.mainframe.gui.annotatedresults.AbstractResultElement;
import com.ez.mainframe.gui.annotatedresults.AnnotatedResultsContentProvider;
import com.ez.mainframe.gui.annotatedresults.AnnotatedResultsLabelProvider;
import com.ez.mainframe.gui.annotatedresults.AnnotationPartStateManager;
import com.ez.mainframe.gui.annotatedresults.AnnotationStateListener;
import com.ez.workspace.state.EventType;
import com.ez.workspace.state.IEZStateListener;
import com.ez.workspace.state.StateManager;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DecorationContext;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public abstract class AnnotatedViewer
implements IResultViewer {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    protected TreeViewer resultsTreeViewer;
    protected AnnotationPartStateManager annStateManager;
    protected AnnotationStateListener annStateListener;

    public void updateFromAnn(AbstractResultElement[] elements) {
        this.resultsTreeViewer.update((Object[])elements, null);
    }

    protected void setAnnotationsContext() {
        this.instantiateAnnotStateManager();
        this.annStateListener = new AnnotationStateListener(this.annStateManager);
        EventType evType = EventType.EZANNOTATION_EVENT_TYPE;
        StateManager.getInstance().register((IEZStateListener)this.annStateListener, evType);
    }

    protected abstract void instantiateAnnotStateManager();

    protected abstract AnnotatedResultsContentProvider getContentProvider();

    protected void unsetAnnotationsContext() {
        EventType evType = EventType.EZANNOTATION_EVENT_TYPE;
        StateManager.getInstance().unregister((IEZStateListener)this.annStateListener, evType);
        this.annStateListener = null;
        if (this.annStateManager != null) {
            this.annStateManager.dispose();
        }
        this.annStateManager = null;
    }

    protected void buildTreeViewer(Composite parent) {
        this.resultsTreeViewer = new TreeViewer(parent, 770);
        this.setAnnotationsContext();
        this.resultsTreeViewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.buildLabelDecorator();
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.resultsTreeViewer);
        parent.setTabList(new Control[]{this.resultsTreeViewer.getControl()});
    }

    private void buildLabelDecorator() {
        ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        DecorationContext ctx = new DecorationContext();
        ctx.putProperty("annManager", (Object)this.annStateManager);
        this.resultsTreeViewer.setLabelProvider((IBaseLabelProvider)new AnnotatedResultsLabelProvider(this.getLabelProvider(), decorator, (IDecorationContext)ctx));
    }

    protected abstract DelegatingStyledCellLabelProvider.IStyledLabelProvider getLabelProvider();
}

