/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.gui.annotatedresults;

import com.ez.ann.db.EZAnnotationDbManager;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.utils.LogUtil;
import com.ez.mainframe.gui.annotatedresults.AbstractResultElement;
import com.ez.mainframe.gui.annotatedresults.AnnotationPartStateManager;
import com.ez.mainframe.gui.internal.Activator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AnnotatedResultsContentProvider
implements ITreeContentProvider {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(AnnotatedResultsContentProvider.class);
    protected AnnotationPartStateManager annStateManager;
    protected Map<EZEntityID, Set<AbstractResultElement>> annRegistered = new HashMap<EZEntityID, Set<AbstractResultElement>>();

    protected void unregisterNodesFromAnn() {
        for (EZEntityID key : this.annRegistered.keySet()) {
            this.annStateManager.unregister(key, this.annRegistered.get(key));
        }
        this.annRegistered.clear();
    }

    public void dispose() {
        this.unregisterNodesFromAnn();
        this.annStateManager = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.unregisterNodesFromAnn();
    }

    public Object[] getChildren(Object parentElement) {
        ArrayList<AbstractResultElement> childrenList = new ArrayList<AbstractResultElement>();
        Map<String, AbstractResultElement> children = ((AbstractResultElement)parentElement).getChildren();
        if (children != null) {
            childrenList.addAll(children.values());
        }
        try {
            this.register4Annotations(childrenList);
        }
        catch (Exception e) {
            L.error("could not process annotations", (Throwable)e);
            LogUtil.log((int)2, (String)EZAnnotationDbManager.NO_ANN_DB_CONNECTION_WARNING_MSG, null, (Bundle)Activator.getDefault().getBundle());
        }
        Collections.sort(childrenList);
        return childrenList.toArray();
    }

    public boolean hasChildren(Object element) {
        return ((AbstractResultElement)element).hasChildren();
    }

    protected void register4Annotations(Collection<AbstractResultElement> collection) {
        for (AbstractResultElement resultElem : collection) {
            EZObjectType inputType;
            if (!this.annStateManager.considerElement(resultElem) || (inputType = this.annStateManager.buildInputType(resultElem)) == null || this.annStateManager == null) continue;
            EZEntityID key = inputType.getEntID();
            this.annStateManager.register(key, resultElem);
            Set<AbstractResultElement> st = this.annRegistered.get(key);
            if (st == null) {
                st = new HashSet<AbstractResultElement>();
                this.annRegistered.put(key, st);
            }
            st.add(resultElem);
        }
    }
}

