/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.gui;

import com.ez.mainframe.model.ProjectInfo;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Listener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectsListWrapper {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ProjectsListWrapper.class);
    boolean singleSelect = false;
    boolean collectSelection = false;
    List<ProjectInfo> inputProjects;
    List<ProjectInfo> selected;
    protected org.eclipse.swt.widgets.List lst;

    public ProjectsListWrapper() {
    }

    public ProjectsListWrapper(Group parent, int style) {
        this();
        this.instantiateList((Composite)parent, style);
    }

    public ProjectsListWrapper(Composite parent, int style, boolean singleSelection) {
        this();
        this.instantiateList(parent, style, singleSelection);
    }

    public void instantiateList(Composite projectsGrp, int style) {
        this.lst = new org.eclipse.swt.widgets.List(projectsGrp, style);
    }

    public void instantiateList(Composite parent, int style, boolean singleSelection) {
        this.instantiateList(parent, style);
        this.singleSelect = singleSelection;
    }

    public void fill(List<ProjectInfo> projects, List<ProjectInfo> selectedPrjs) {
        this.inputProjects = selectedPrjs;
        if (this.doFill()) {
            this.populateList(projects);
            this.addListener();
        }
    }

    protected void populateList(List<ProjectInfo> projects) {
        int[] selection = new int[this.inputProjects.size()];
        int prjIndex = 0;
        int selIndex = 0;
        Collections.sort(projects);
        for (ProjectInfo projectInfo : projects) {
            if (!this.considerProject(projectInfo)) continue;
            if (this.shouldAdd(projectInfo)) {
                this.lst.add(projectInfo.getName(), prjIndex);
                this.lst.setData(String.valueOf(prjIndex), (Object)projectInfo);
            }
            if (this.shouldSelect(projectInfo)) {
                if (this.collectSelection) {
                    if (this.selected == null) {
                        L.warn("please give the list where to collect selection!");
                    } else {
                        this.selected.add(projectInfo);
                    }
                }
                if (this.singleSelect) {
                    selIndex = prjIndex;
                } else {
                    selection[selIndex] = prjIndex;
                    ++selIndex;
                }
            }
            ++prjIndex;
        }
        this.doSelection(selection, selIndex);
    }

    protected boolean shouldAdd(ProjectInfo projectInfo) {
        return true;
    }

    protected boolean considerProject(ProjectInfo projectInfo) {
        return true;
    }

    protected void doSelection(int[] selection, int selIndex) {
        if (this.singleSelect) {
            this.lst.select(selIndex);
        } else {
            this.lst.select(selection);
        }
    }

    protected boolean shouldSelect(ProjectInfo projectInfo) {
        return this.inputProjects.contains(projectInfo);
    }

    protected boolean doFill() {
        return this.inputProjects != null;
    }

    protected void addListener() {
        this.lst.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                int[] selection = ProjectsListWrapper.this.lst.getSelectionIndices();
                if (selection.length > 0) {
                    boolean selectionShown = false;
                    int i = 0;
                    while (i < selection.length) {
                        int index = selection[i];
                        int listHeight = ProjectsListWrapper.this.lst.getBounds().height;
                        int itemHeight = ProjectsListWrapper.this.lst.getItemHeight();
                        int selectionHeight = itemHeight * index - ProjectsListWrapper.this.lst.getVerticalBar().getSelection();
                        if (selectionHeight >= 0 && selectionHeight <= listHeight - itemHeight) {
                            selectionShown = true;
                            break;
                        }
                        ++i;
                    }
                    if (!selectionShown) {
                        ProjectsListWrapper.this.lst.setTopIndex(selection[0]);
                    }
                }
            }
        });
    }

    public void collectSelection(List<ProjectInfo> lst) {
        this.selected = lst;
        this.collectSelection = this.selected != null;
    }

    public org.eclipse.swt.widgets.List getList() {
        return this.lst;
    }
}

