/*
 * Decompiled with CFR 0.152.
 */
package com.ez.eclient.configuration.bootstrap.internal;

import com.ez.eclient.configuration.bootstrap.internal.Messages;
import com.ez.eclient.preferences.ServerScope;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EclipsePropertiesSyncJob
extends Job {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(EclipsePropertiesSyncJob.class);
    private final String configurationUniqueId;

    public EclipsePropertiesSyncJob(String configurationUniqueId) {
        super(Messages.getString(EclipsePropertiesSyncJob.class, "reload.text", new String[]{configurationUniqueId}));
        this.configurationUniqueId = configurationUniqueId;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IEclipsePreferences p = ServerScope.INSTANCE.getNode(this.configurationUniqueId);
        if (p == null) {
            L.error(String.format("Can't get %s from %s.", this.configurationUniqueId, "configurationServer"));
        } else {
            try {
                p.sync();
                L.info(String.format("Eclipse configuration reload %s:%s", "configurationServer", this.configurationUniqueId));
            }
            catch (BackingStoreException backingStoreException) {
                L.error("Can't reload " + this.configurationUniqueId);
            }
        }
        return Status.OK_STATUS;
    }
}

