/*
 * Decompiled with CFR 0.152.
 */
package com.ez.eclient.configuration.bootstrap.internal;

import com.ez.eclient.configuration.Configuration;
import com.ez.eclient.configuration.bootstrap.BootstrapParticipant;
import com.ez.eclient.configuration.bootstrap.Bootstrapper;
import com.ez.eclient.configuration.bootstrap.internal.EclipsePropertiesSyncJob;
import com.ez.eclient.configuration.bootstrap.internal.NonEclipsePropertiesSyncJob;
import com.ez.eclient.configuration.service.ConfigurationInterceptorFactory;
import com.ez.eclient.configuration.service.DefaultConfigurationService;
import com.ez.eclient.configuration.service.EclipseConfigurationStack;
import com.ez.eclient.configuration.service.EclipseConfigurationStackFactory;
import com.ez.eclient.configuration.synchro.service.ConfigurationDescription;
import com.ez.eclient.configuration.synchro.service.ConfigurationEvent;
import com.ez.eclient.configuration.synchro.service.ConfigurationListener;
import com.ez.eclient.configuration.synchro.service.ConfigurationSynchroService;
import com.ez.eclient.configuration.synchro.service.EventType;
import com.ez.eclient.environment.Environment;
import com.ez.eclient.environment.preferences.EnvironmentPreferences;
import com.ez.eclient.preferences.ServerPreferences;
import com.ez.eclient.preferences.ServerScope;
import com.ez.eclient.preferences.service.DynamicPreferencesService;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapperImpl {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(BootstrapperImpl.class);
    private static final Object IMPLG = new Object();
    private static BootstrapperImpl IMPL = null;
    private List<BootstrapParticipant> participants;
    private Properties properties = null;
    private boolean extentionsExecuted = false;
    private List<ConfigListenerElement> listenerConfigElements = new LinkedList<ConfigListenerElement>();
    private List<ConfigConfigurationElement> eclipseConfigElements = new LinkedList<ConfigConfigurationElement>();
    private List<ConfigConfigurationElement> configElements = new LinkedList<ConfigConfigurationElement>();
    private ConfigurationSynchroService synchroService;
    private DynamicPreferencesService preferencesService;
    private DefaultConfigurationService configService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BootstrapperImpl getBootstrapper() {
        Object object = IMPLG;
        synchronized (object) {
            if (IMPL == null) {
                L.debug("Configuration bootstrapper created.");
                IMPL = new BootstrapperImpl();
            }
            return IMPL;
        }
    }

    private BootstrapperImpl() {
        this.participants = this.loadExtensions();
    }

    public synchronized void preConfigureEclipsePropertiesSevice(Properties properties) {
        L.debug("Preconfigure eclipse properties service.");
        this.ensureExtensionExecuted();
        properties.putAll((Map<?, ?>)this.properties);
    }

    public synchronized void preConfigureSynchroSevice(Properties properties) {
        L.debug("Preconfigure sychronization service.");
        this.ensureExtensionExecuted();
        properties.putAll((Map<?, ?>)this.properties);
    }

    public synchronized void prePropertiesSevice(Properties properties) {
        L.debug("Preconfigure properties service.");
        this.ensureExtensionExecuted();
        properties.putAll((Map<?, ?>)this.properties);
    }

    public synchronized void postConfigureSynchroService(ConfigurationSynchroService service) {
        L.debug("Postconfigure sychronization service.");
        this.ensureExtensionExecuted();
        this.synchroService = service;
        this.configureSynchroService();
        if (this.preferencesService != null) {
            L.debug("Postconfigure updated eclipse properties reload.");
            this.configureEclipsePropertiesReload();
        }
        if (this.configService != null) {
            L.debug("Postconfigure updated properties reload.");
            this.configurePropertiesReload();
        }
    }

    public synchronized void postConfigureEclipsePropertiesService(DynamicPreferencesService preferencesService) {
        L.debug("Postconfigure eclipse properties service.");
        this.ensureExtensionExecuted();
        this.preferencesService = preferencesService;
        this.configureEclipsePropertiesService();
        if (this.synchroService != null) {
            L.debug("Postconfigure updated eclipse properties reload.");
            this.configureEclipsePropertiesReload();
        }
    }

    public synchronized void postConfigurePropertiesService(DefaultConfigurationService configService) {
        L.debug("Postconfigure properties service.");
        this.ensureExtensionExecuted();
        this.configService = configService;
        this.configurePropertiesService(configService);
        if (this.synchroService != null) {
            L.debug("Postconfigure updated properties reload.");
            this.configurePropertiesReload();
        }
    }

    private List<BootstrapParticipant> loadExtensions() {
        LinkedList<BootstrapParticipant> cl = new LinkedList<BootstrapParticipant>();
        IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ez.eclient.configuration.bootstrap.participant");
        if (configs != null) {
            IConfigurationElement[] iConfigurationElementArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement ce = iConfigurationElementArray[n2];
                Object e = null;
                try {
                    e = ce.createExecutableExtension("class");
                }
                catch (CoreException ex) {
                    L.error("Can't create extension.", (Throwable)ex);
                }
                if (e != null && e instanceof BootstrapParticipant) {
                    cl.add((BootstrapParticipant)e);
                }
                ++n2;
            }
        }
        return cl;
    }

    private void ensureExtensionExecuted() {
        if (this.extentionsExecuted) {
            L.debug("Extensions already executed.");
        } else {
            this.properties = new Properties();
            try {
                for (BootstrapParticipant bp : this.participants) {
                    L.debug("Preconfigure " + bp);
                    try {
                        bp.preConfigure(this.properties);
                    }
                    catch (Exception ex) {
                        L.error("Uncaught exception.", (Throwable)ex);
                    }
                }
                this.setupServerMirrorLocation(this.properties);
                for (BootstrapParticipant bp : this.participants) {
                    try {
                        bp.postConfigure(new Bootstrapper(){

                            @Override
                            public void registerListener(String idQualifier, ConfigurationListener listener) {
                                BootstrapperImpl.this.listenerConfigElements.add(new ConfigListenerElement(idQualifier, listener));
                            }

                            @Override
                            public void registerListener(ConfigurationListener listener) {
                                BootstrapperImpl.this.listenerConfigElements.add(new ConfigListenerElement(null, listener));
                            }

                            @Override
                            public void registerEclipseConfiguration(ConfigurationDescription description, ConfigurationListener listener) {
                                BootstrapperImpl.this.eclipseConfigElements.add(new ConfigConfigurationElement(description, listener, null));
                            }

                            @Override
                            public void registerConfiguration(ConfigurationDescription description, ConfigurationListener listener, ConfigurationInterceptorFactory interceptorFactory) {
                                BootstrapperImpl.this.configElements.add(new ConfigConfigurationElement(description, listener, interceptorFactory));
                            }
                        });
                    }
                    catch (Exception ex) {
                        L.error("Uncaught exception.", (Throwable)ex);
                    }
                }
            }
            finally {
                this.extentionsExecuted = true;
            }
        }
    }

    private void setupServerMirrorLocation(Properties properties) {
        String rootLocation = (String)this.properties.get("configuration.default_root_location");
        if (rootLocation == null) {
            L.warn("Root location not set.");
        } else {
            Environment e = EnvironmentPreferences.getEnvironment();
            if (e == null) {
                L.debug("Environment not set.");
            } else {
                rootLocation = new File(rootLocation, e.getId()).getAbsolutePath();
                properties.put("configuration.default_root_location", rootLocation);
            }
        }
    }

    private void configureSynchroService() {
        for (ConfigListenerElement configListenerElement : this.listenerConfigElements) {
            try {
                if (configListenerElement.idQualifier != null) {
                    this.synchroService.registerListener(configListenerElement.idQualifier, configListenerElement.listener);
                    continue;
                }
                this.synchroService.registerListener(configListenerElement.listener);
            }
            catch (Exception ex) {
                L.error("Can't register listener " + configListenerElement.idQualifier, (Throwable)ex);
            }
        }
        for (ConfigConfigurationElement configConfigurationElement : this.eclipseConfigElements) {
            try {
                this.synchroService.registerConfiguration(configConfigurationElement.config, configConfigurationElement.configListener);
            }
            catch (Exception ex) {
                L.error("Can't register " + configConfigurationElement.config.getUniqueId(), (Throwable)ex);
            }
        }
        for (ConfigConfigurationElement configConfigurationElement : this.configElements) {
            try {
                this.synchroService.registerConfiguration(configConfigurationElement.config, configConfigurationElement.configListener);
            }
            catch (Exception ex) {
                L.error("Can't register " + configConfigurationElement.config.getUniqueId(), (Throwable)ex);
            }
        }
    }

    private void configureEclipsePropertiesService() {
        for (ConfigConfigurationElement e : this.eclipseConfigElements) {
            try {
                this.preferencesService.registerServerConfigGroup(e.config.getUniqueId());
            }
            catch (Exception ex) {
                L.error("Can't register " + e.config.getUniqueId(), (Throwable)ex);
            }
        }
    }

    private void configurePropertiesService(DefaultConfigurationService configService) {
        String mirroredLocation = this.properties.getProperty("configuration.default_root_location");
        if (mirroredLocation == null) {
            throw new IllegalStateException("configuration.default_root_location not set.");
        }
        for (ConfigConfigurationElement e : this.configElements) {
            try {
                EclipseConfigurationStack c = EclipseConfigurationStackFactory.create((String)mirroredLocation, (ConfigurationDescription)e.config, (ConfigurationInterceptorFactory)e.interceptorFactory);
                configService.registerConfiguration(e.config.getUniqueId(), (Configuration)c);
            }
            catch (Exception ex) {
                L.error("Can't register " + e.config.getUniqueId(), (Throwable)ex);
            }
        }
    }

    private void configureEclipsePropertiesReload() {
        for (ConfigConfigurationElement e : this.eclipseConfigElements) {
            final String uniqueId = e.config.getUniqueId();
            IEclipsePreferences p = ServerScope.INSTANCE.getNode(uniqueId);
            if (p == null) {
                L.error(String.format("Can't get %s from %s.", uniqueId, "configurationServer"));
                continue;
            }
            if (!(p instanceof ServerPreferences)) {
                L.error(String.format("%s not an instance of %s.", uniqueId, ServerPreferences.class));
                continue;
            }
            L.debug(String.format("Register listener for %s.", uniqueId));
            try {
                this.synchroService.registerListener(uniqueId, new ConfigurationListener(){

                    public void notifyEvent(List<ConfigurationEvent> el) {
                        boolean reload = false;
                        if (L.isTraceEnabled()) {
                            L.trace("Events received for eclipse configuration " + uniqueId);
                        }
                        for (ConfigurationEvent e : el) {
                            if (e.getType() != EventType.SyncApplied) continue;
                            reload = true;
                            break;
                        }
                        if (reload) {
                            EclipsePropertiesSyncJob j = new EclipsePropertiesSyncJob(uniqueId);
                            j.schedule();
                            if (L.isTraceEnabled()) {
                                L.trace("Reload job scheduled for eclipse configuration " + uniqueId);
                            }
                        }
                    }
                });
            }
            catch (Exception ex) {
                L.error("Can't register listener " + uniqueId, (Throwable)ex);
            }
        }
    }

    private void configurePropertiesReload() {
        for (ConfigConfigurationElement e : this.configElements) {
            final String uniqueId = e.config.getUniqueId();
            final DefaultConfigurationService configService = this.configService;
            try {
                this.synchroService.registerListener(uniqueId, new ConfigurationListener(){

                    public void notifyEvent(List<ConfigurationEvent> el) {
                        boolean reload = false;
                        if (L.isTraceEnabled()) {
                            L.trace("Events received for configuration" + uniqueId);
                        }
                        for (ConfigurationEvent e : el) {
                            if (e.getType() != EventType.SyncApplied) continue;
                            reload = true;
                            break;
                        }
                        if (reload) {
                            NonEclipsePropertiesSyncJob j = new NonEclipsePropertiesSyncJob(configService, uniqueId);
                            j.schedule();
                            if (L.isTraceEnabled()) {
                                L.trace("Reload job scheduled for configuration " + uniqueId);
                            }
                        }
                    }
                });
            }
            catch (Exception ex) {
                L.error("Can't register listener " + uniqueId, (Throwable)ex);
            }
        }
    }

    private class ConfigConfigurationElement {
        ConfigurationDescription config;
        ConfigurationListener configListener;
        ConfigurationInterceptorFactory interceptorFactory;

        ConfigConfigurationElement(ConfigurationDescription config, ConfigurationListener configListener, ConfigurationInterceptorFactory interceptorFactory) {
            this.config = config;
            this.configListener = configListener;
            this.interceptorFactory = interceptorFactory;
        }
    }

    private class ConfigListenerElement {
        String idQualifier;
        ConfigurationListener listener;

        ConfigListenerElement(String idQualifier, ConfigurationListener listener) {
            this.idQualifier = idQualifier;
            this.listener = listener;
        }
    }
}

