/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ad.oauth2.ui;

import com.ibm.ad.oauth2.internal.Messages;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressRunn
implements Runnable {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger L = LoggerFactory.getLogger(ProgressRunn.class);
    ProgressMonitorDialog pmd;
    private boolean done = false;
    Long timeout = null;

    public ProgressRunn(Long timeout) {
        this.timeout = timeout;
    }

    public ProgressMonitorDialog getDialog() {
        return this.pmd;
    }

    public void done() {
        this.done = true;
    }

    public boolean isDone() {
        return this.done;
    }

    @Override
    public void run() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = Display.getCurrent().getActiveShell();
                ProgressRunn.this.pmd = new ProgressMonitorDialog(shell);
                try {
                    ProgressRunn.this.pmd.run(true, true, new IRunnableWithProgress(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            Object obj = new Object();
                            int totalWork = (this).ProgressRunn.this.timeout != null ? (this).ProgressRunn.this.timeout.intValue() : 100;
                            monitor.beginTask(Messages.getString(ProgressRunn.class, "taskName"), totalWork);
                            int work = 0;
                            int thresh = 2;
                            Object object = obj;
                            synchronized (object) {
                                while (!ProgressRunn.this.done && !monitor.isCanceled() && work < totalWork) {
                                    try {
                                        obj.wait(thresh * 1000);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        work = totalWork;
                                    }
                                    monitor.worked(thresh);
                                    work += thresh;
                                }
                            }
                            L.trace("after wait; {} out of {} seconds", (Object)work, (Object)totalWork);
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    L.error("error at applying resolution", (Throwable)e);
                }
                catch (InterruptedException e) {
                    L.error("error at applying resolution", (Throwable)e);
                }
            }
        });
    }
}

