/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ad.oauth2.model;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth2Data
implements Cloneable {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(OAuth2Data.class);
    String clientID;
    String clientSecret;
    String redirectURI;
    String authIssuerURI;
    String discoveryURI;
    String resourceServerUrl;
    String grantType = "authorization_code";
    public String scope = "offline_access openid profile email groups";
    public String tokenEndpoint;
    public String authorizationEndpoint;
    long timeout;

    public String getClientID() {
        return this.clientID;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getRedirectURI() {
        return this.redirectURI;
    }

    public String getAuthIssuerURI() {
        return this.authIssuerURI;
    }

    public String getDiscoveryURI() {
        return this.discoveryURI;
    }

    public String getResourceServerUrl() {
        return this.resourceServerUrl;
    }

    public String getGrantType() {
        return this.grantType;
    }

    public String getScope() {
        return this.scope;
    }

    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public String getAuthorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public static class Builder {
        OAuth2Data data = null;

        public Builder() {
            this.data = new OAuth2Data();
        }

        public Builder(OAuth2Data data) {
            try {
                this.data = (OAuth2Data)data.clone();
            }
            catch (CloneNotSupportedException e) {
                L.error("Error:", (Throwable)e);
            }
        }

        public OAuth2Data build() {
            OAuth2Data d = this.data;
            this.data = null;
            return d;
        }

        private void check() {
            if (this.data == null) {
                throw new RuntimeException("cannot reuse builder");
            }
        }

        public Builder withClientID(String clientID) {
            this.check();
            this.data.clientID = clientID;
            return this;
        }

        public Builder withClientSecret(String clientSecret) {
            this.check();
            this.data.clientSecret = clientSecret;
            return this;
        }

        public Builder withRedirectURI(String redirectURI) {
            this.check();
            this.data.redirectURI = redirectURI;
            return this;
        }

        public Builder withAuthIssuerURI(String authIssuerURI) {
            this.check();
            this.data.authIssuerURI = authIssuerURI;
            return this;
        }

        public Builder withTokenEndpoint(String tokenEndpoint) {
            this.check();
            this.data.tokenEndpoint = tokenEndpoint;
            return this;
        }

        public Builder withDiscoveryURI(String discoveryURI) {
            this.check();
            this.data.discoveryURI = discoveryURI;
            return this;
        }

        public Builder withAuthEndpoint(String authorizationEndpoint) {
            this.check();
            this.data.authorizationEndpoint = authorizationEndpoint;
            return this;
        }

        public Builder withTimeout(Long timeout) {
            this.check();
            this.data.timeout = timeout;
            return this;
        }
    }
}

