/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ad.oauth2.model;

import com.ibm.ad.oauth2.internal.Messages;
import com.ibm.ad.oauth2.model.HttpResponseConsumer;
import com.ibm.ad.oauth2.model.OAuth2Data;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth2Client {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    static Logger L = LoggerFactory.getLogger(OAuth2Client.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> discoverProvider(OAuth2Data oauthData) {
        Map<String, String> map;
        if (oauthData.discoveryURI == null) return null;
        String wellKnown = oauthData.discoveryURI;
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(wellKnown);
        CloseableHttpResponse response = null;
        try {
            response = client.execute((HttpUriRequest)get);
            map = OAuth2Client.handleJsonResponse((HttpResponse)response);
        }
        catch (Exception e) {
            try {
                L.error("while discovering", (Throwable)e);
                throw new RuntimeException(Messages.getString(OAuth2Client.class, "authentication.exception"), e);
            }
            catch (Throwable throwable) {
                get.releaseConnection();
                try {
                    client.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        get.releaseConnection();
        try {
            client.close();
            return map;
        }
        catch (IOException iOException) {}
        return map;
    }

    public static Map<String, String> getAccessToken(OAuth2Data oauthData, String authorizationCode, String state) {
        HttpPost post = new HttpPost(oauthData.tokenEndpoint);
        ArrayList<BasicNameValuePair> parametersBody = new ArrayList<BasicNameValuePair>();
        parametersBody.add(new BasicNameValuePair("grant_type", oauthData.grantType));
        parametersBody.add(new BasicNameValuePair("code", authorizationCode));
        parametersBody.add(new BasicNameValuePair("client_id", oauthData.clientID));
        parametersBody.add(new BasicNameValuePair("client_secret", oauthData.clientSecret));
        parametersBody.add(new BasicNameValuePair("redirect_uri", oauthData.redirectURI));
        parametersBody.add(new BasicNameValuePair("state", state));
        parametersBody.add(new BasicNameValuePair("scope", oauthData.scope));
        CloseableHttpClient client = HttpClientBuilder.create().build();
        CloseableHttpResponse response = null;
        String accessToken = null;
        Map tokenData = null;
        try {
            try {
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(parametersBody, Charset.forName("UTF-8"));
                post.setEntity((HttpEntity)entity);
                post.addHeader("Content-Type", "application/x-www-form-urlencoded");
                response = client.execute((HttpUriRequest)post);
                tokenData = OAuth2Client.handleResponse((HttpResponse)response);
                accessToken = (String)tokenData.get("access_token");
                if (accessToken == null || accessToken.isEmpty()) {
                    L.error("invalid response", (Object)tokenData);
                    tokenData = null;
                }
            }
            catch (Throwable e) {
                L.error("Error while getting token", e);
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        finally {
            post.releaseConnection();
            try {
                client.close();
            }
            catch (IOException e) {
                L.debug("Error closing client", (Throwable)e);
            }
        }
        return tokenData;
    }

    public static Map<String, String> refreshAccessToken(OAuth2Data data, String refreshToken) {
        HttpPost post = new HttpPost(data.getTokenEndpoint());
        String clientId = data.getClientID();
        String clientSecret = data.getClientSecret();
        String scope = data.getScope();
        Map<String, String> map = new HashMap<String, String>();
        ArrayList<BasicNameValuePair> parametersBody = new ArrayList<BasicNameValuePair>();
        parametersBody.add(new BasicNameValuePair("grant_type", "refresh_token"));
        parametersBody.add(new BasicNameValuePair("refresh_token", refreshToken));
        parametersBody.add(new BasicNameValuePair("client_id", clientId));
        parametersBody.add(new BasicNameValuePair("client_secret", clientSecret));
        parametersBody.add(new BasicNameValuePair("scope", scope));
        CloseableHttpClient client = HttpClientBuilder.create().build();
        CloseableHttpResponse response = null;
        try {
            try {
                post.setEntity((HttpEntity)new UrlEncodedFormEntity(parametersBody, "UTF-8"));
                response = client.execute((HttpUriRequest)post);
                response.getStatusLine().getStatusCode();
                map = OAuth2Client.handleResponse((HttpResponse)response);
            }
            catch (Exception e) {
                L.error("while getting refresh token", (Throwable)e);
                map.clear();
                if (post != null) {
                    post.releaseConnection();
                }
                try {
                    client.close();
                }
                catch (IOException e2) {
                    L.debug("closing client exception", (Throwable)e2);
                }
            }
        }
        finally {
            if (post != null) {
                post.releaseConnection();
            }
            try {
                client.close();
            }
            catch (IOException e) {
                L.debug("closing client exception", (Throwable)e);
            }
        }
        return map;
    }

    public static void getProtectedResource(String resourceURL, String method, String info, String accessToken, HttpResponseConsumer consumer) throws Exception {
        Exception ret;
        block33: {
            ret = null;
            if (method == null) {
                method = "GET";
            }
            L.debug("accessing resource: {}, with method: {}", (Object)resourceURL, (Object)method);
            HttpPost request = null;
            if ("POST".equalsIgnoreCase(method)) {
                request = new HttpPost(resourceURL);
            } else if ("PUT".equalsIgnoreCase(method)) {
                request = new HttpPut(resourceURL);
            } else if ("DELETE".equalsIgnoreCase(method)) {
                request = new HttpDelete(resourceURL);
            } else if ("GET".equalsIgnoreCase(method)) {
                request = new HttpGet(resourceURL);
            } else {
                L.error("method {} not implemented!!", (Object)method);
                throw new RuntimeException();
            }
            String tokHeader = "Bearer " + accessToken;
            request.addHeader("Authorization", tokHeader);
            CloseableHttpClient client = HttpClientBuilder.create().build();
            if (!"GET".equalsIgnoreCase(method)) {
                if (info != null) {
                    if (request instanceof HttpEntityEnclosingRequestBase) {
                        ByteArrayEntity entity = new ByteArrayEntity(info.getBytes("UTF-8"));
                        entity.setContentType("application/json");
                        ((HttpEntityEnclosingRequestBase)request).setEntity((HttpEntity)entity);
                    } else {
                        L.warn("{} request with info, but not HttpEntityEnclosingRequestBase!", (Object)method);
                    }
                } else {
                    L.warn("null extra-info when call {} method!", (Object)method);
                }
            }
            CloseableHttpResponse response = null;
            int code = -1;
            try {
                try {
                    response = client.execute((HttpUriRequest)request);
                    code = response.getStatusLine().getStatusCode();
                    if (code == 401 || code == 403) {
                        throw new SecurityException(Messages.getString(OAuth2Client.class, "unauthorized.exception"));
                    }
                    if (code == 404) {
                        throw new FileNotFoundException(Messages.getString(OAuth2Client.class, "fileNotFound.exception"));
                    }
                    String data = null;
                    try {
                        data = EntityUtils.toString((HttpEntity)response.getEntity());
                        if (data.isEmpty()) {
                            data = code == 200 ? "no contents!!" : response.getStatusLine().getReasonPhrase();
                        }
                        L.debug("got result: {}", (Object)(data.isEmpty() ? data : data.substring(0, Math.min(6, data.length() - 1))));
                    }
                    catch (Exception e) {
                        ret = e;
                    }
                    if (ret == null) {
                        consumer.setHttpCode(code);
                        if (data != null) {
                            consumer.accept(data);
                        }
                    }
                }
                catch (Exception e) {
                    L.error("exception getting protected resource", (Throwable)e);
                    ret = e;
                    request.releaseConnection();
                    try {
                        client.close();
                    }
                    catch (IOException e2) {
                        L.debug("error closing client when gett protected resource", (Throwable)e2);
                    }
                    break block33;
                }
            }
            catch (Throwable throwable) {
                request.releaseConnection();
                try {
                    client.close();
                }
                catch (IOException e) {
                    L.debug("error closing client when gett protected resource", (Throwable)e);
                }
                throw throwable;
            }
            request.releaseConnection();
            try {
                client.close();
            }
            catch (IOException e) {
                L.debug("error closing client when gett protected resource", (Throwable)e);
            }
        }
        if (ret != null) {
            throw ret;
        }
    }

    public static String getHeader(Header[] headers, String name) {
        String header = null;
        if (headers != null) {
            Header[] headerArray = headers;
            int n = headers.length;
            int n2 = 0;
            while (n2 < n) {
                Header h = headerArray[n2];
                if (h.getName().equalsIgnoreCase(name)) {
                    header = h.getValue();
                    break;
                }
                ++n2;
            }
        }
        return header;
    }

    public static Map handleResponse(HttpResponse response) {
        String contentType = "application/json";
        if (response.getEntity().getContentType() != null) {
            contentType = response.getEntity().getContentType().getValue();
        }
        if (contentType.contains("application/json")) {
            return OAuth2Client.handleJsonResponse(response);
        }
        if (contentType.contains("application/x-www-form-urlencoded")) {
            return OAuth2Client.handleURLEncodedResponse(response);
        }
        L.info("{}", (Object)response);
        throw new RuntimeException("Cannot handle " + contentType + " content type. Supported content types include JSON, XML and URLEncoded");
    }

    public static Map<String, String> handleJsonResponse(HttpResponse response) {
        HashMap<String, String> oauthLoginResponse = null;
        try {
            if (!response.containsHeader("Strict-Transport-Security")) {
                response.addHeader("Strict-Transport-Security", "max-age=31536000; includeSubDomains");
            }
            InputStream inptStream = response.getEntity().getContent();
            try (JsonReader jsonReader = Json.createReader((InputStream)inptStream);){
                JsonObject jObj = jsonReader.readObject();
                oauthLoginResponse = new HashMap<String, String>();
                for (String key : jObj.keySet()) {
                    JsonValue jsonValue = (JsonValue)jObj.get((Object)key);
                    String v = null;
                    v = jsonValue.getValueType().equals((Object)JsonValue.ValueType.STRING) ? ((JsonString)jsonValue).getString() : jsonValue.toString();
                    oauthLoginResponse.put(key, v);
                }
            }
        }
        catch (Exception e) {
            L.error("could not parse JSON response", (Throwable)e);
            throw new RuntimeException("Cannot parse JSON response: " + response, e);
        }
        L.info("Json Response Received");
        L.debug("{}", (Object)response);
        for (Map.Entry entry : oauthLoginResponse.entrySet()) {
            L.debug(String.format("  %s = %s", entry.getKey(), entry.getValue()));
        }
        return oauthLoginResponse;
    }

    public static boolean launchBrowser(String url) {
        boolean ok = true;
        L.info("launching browser with " + url);
        try {
            IWebBrowser externalBrowser = PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser();
            externalBrowser.openURL(new URL(url));
        }
        catch (MalformedURLException | PartInitException e) {
            L.error("could not open external browser", e);
            ok = false;
        }
        return ok;
    }

    public static Map<String, String> handleURLEncodedResponse(HttpResponse response) {
        SortedMap<String, Charset> map = Charset.availableCharsets();
        HashMap<String, String> oauthResponse = new HashMap<String, String>();
        Set set = map.entrySet();
        if (!response.containsHeader("Strict-Transport-Security")) {
            response.addHeader("Strict-Transport-Security", "max-age=31536000; includeSubDomains");
        }
        HttpEntity entity = response.getEntity();
        L.info("URL Encoded Response Received");
        L.debug("{}", (Object)response);
        for (Map.Entry entry : set) {
            L.debug(String.format("  %s = %s", entry.getKey(), entry.getValue()));
            if (!((String)entry.getKey()).equalsIgnoreCase("UTF-8")) continue;
            Charset cfr_ignored_0 = (Charset)entry.getValue();
        }
        try {
            List list = URLEncodedUtils.parse((String)EntityUtils.toString((HttpEntity)entity), (Charset)Charset.forName("UTF-8"));
            for (NameValuePair pair : list) {
                L.debug(String.format("  %s = %s", pair.getName(), pair.getValue()));
                oauthResponse.put(pair.getName(), pair.getValue());
            }
        }
        catch (IOException e) {
            L.error("could not parse URLencoded response", (Throwable)e);
            throw new RuntimeException("Could not parse URLEncoded Response");
        }
        return oauthResponse;
    }
}

