/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ad.oauth2.fileservice;

import com.ez.eclient.service.rsrv.fileservice.FileServerService;
import com.ez.internal.utils.ServiceUtils;
import com.ibm.ad.oauth2.Utils;
import com.ibm.ad.oauth2.model.HttpResponseConsumer;
import com.ibm.ad.oauth2.service.SSOService;
import com.ibm.ad.oauth2.ui.ProgressRunn;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Base64;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileAuthUtils {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2021.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger L = LoggerFactory.getLogger(FileAuthUtils.class);

    public static HttpResponseConsumer getFileContent(String file) throws Exception {
        return FileAuthUtils.getFileContent(file, false);
    }

    public static HttpResponseConsumer getFileContent(String filePath, boolean getExpandedInfo) throws Exception {
        HttpResponseConsumer ret = FileAuthUtils.readFileContent(filePath, getExpandedInfo);
        return ret;
    }

    private static HttpResponseConsumer readFileContent(String filePath, boolean getExpandedInfo) throws Exception {
        HttpResponseConsumer cons;
        block7: {
            cons = getExpandedInfo ? new FileExtraContentConsumer() : new HttpResponseConsumer();
            FileServerService service = (FileServerService)ServiceUtils.getService(FileServerService.class);
            SSOService ssoServ = Utils.getSSOService();
            if (service != null && ssoServ != null) {
                String lnk = getExpandedInfo ? service.getFileExtraEndpoint() : service.getFileContentEndpoint();
                L.trace("resource server link: {}", (Object)lnk);
                String url = FileAuthUtils.prepareFileURL(lnk, filePath);
                L.trace("invoking: {}", (Object)url);
                ProgressRunn runn = null;
                try {
                    try {
                        ssoServ.request(new URL(url), cons);
                        break block7;
                    }
                    catch (Exception re) {
                        L.error("error requesting content of file {}", (Object)filePath, (Object)re);
                        throw re;
                    }
                }
                finally {
                    IProgressMonitor monitor;
                    ProgressMonitorDialog pmd;
                    if (runn != null && (pmd = runn.getDialog()) != null && (monitor = pmd.getProgressMonitor()) != null && !monitor.isCanceled()) {
                        monitor.setCanceled(true);
                    }
                }
            }
            L.error("cannot find reference of a service (SSOService: {}, FileService: {})!", (Object)ssoServ, (Object)service);
        }
        return cons;
    }

    private static String prepareFileURL(String prefix, String uncPath) {
        String url = null;
        try {
            url = String.valueOf(prefix) + "?q=" + URLEncoder.encode(uncPath, "UTF-8");
        }
        catch (Exception e) {
            L.error("error preparing file url. prefix={}; uncPath={}", new Object[]{prefix, uncPath, e});
        }
        return url;
    }

    public static class FileExtraContentConsumer
    extends HttpResponseConsumer {
        boolean hasExpanded = false;
        String fileServiceEncoding;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void accept(String content) {
            L.trace("got a text in FileExtraContentConsumer: {}", (Object)content.length());
            if (content == null || this.httpCode != 200) throw new RuntimeException(content);
            try (JsonReader reader = null;){
                try {
                    reader = Json.createReader((Reader)new StringReader(content));
                    JsonObject root = reader.readObject();
                    boolean ok = root.getBoolean("readable");
                    if (ok) {
                        JsonString data = root.getJsonString("data");
                        if (data != null) {
                            byte[] bytes = Base64.getDecoder().decode(data.getString());
                            this.fileServiceEncoding = root.getString("encoding");
                            L.info("Reading file using encoding: {}", (Object)this.fileServiceEncoding);
                            this.ret = new String(bytes, this.fileServiceEncoding);
                        }
                        this.hasExpanded = root.getBoolean("expanded");
                        return;
                    }
                    L.warn("content of file {} is not readable by service");
                    return;
                }
                catch (Exception e) {
                    L.error("while parsing reply", (Throwable)e);
                    if (reader == null) return;
                    reader.close();
                }
                return;
            }
        }

        public boolean isExpanded() {
            return this.hasExpanded;
        }
    }
}

