/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ad.oauth2;

import com.ibm.ad.oauth2.internal.Activator;
import com.ibm.ad.oauth2.service.SSOService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger L = LoggerFactory.getLogger(Utils.class);

    public static boolean checkIdentity() {
        boolean ret = false;
        SSOService service = Utils.getSSOService();
        if (service != null) {
            ret = service.isAuthEnabled();
        } else {
            L.error("cannot find SSOService reference!");
        }
        return ret;
    }

    public static SSOService getSSOService() {
        SSOService service = null;
        BundleContext ctx = Activator.getContext();
        if (ctx != null) {
            ServiceReference sr = ctx.getServiceReference(SSOService.class);
            if (sr != null) {
                service = (SSOService)ctx.getService(sr);
            } else {
                L.error("cannot find SSOService reference!");
            }
        } else {
            L.error("cannot access bundle context of oauth2.core bundle!");
        }
        return service;
    }
}

