/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ad.oauth2;

import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.Base64;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;

public class TokenDecode {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";

    static String getUserFrom(String token) {
        return TokenDecode.getUserFrom(token, "email");
    }

    public static String getUserFrom(String token, String key) {
        String[] parts = token.split("\\.");
        if (parts.length < 2) {
            throw new IllegalStateException("oidc: malformed jwt, expected 3 parts got " + parts.length);
        }
        String user = null;
        try {
            String payload = new String(Base64.getUrlDecoder().decode(parts[1]), Charset.forName("UTF-8"));
            JsonReader reader = Json.createReader((Reader)new StringReader(payload));
            JsonObject obj = reader.readObject();
            user = ((JsonString)obj.get((Object)key)).getString();
        }
        catch (Exception e) {
            throw new IllegalStateException("malformed jwt. expected proper json payload.", e);
        }
        if (user == null) {
            throw new IllegalStateException("unexpected jwt content. Expecting email attribute.");
        }
        return user;
    }
}

