/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ad.oauth2;

import com.ibm.ad.oauth2.Handler;
import com.ibm.ad.oauth2.StdErrorExceptionLogger;
import com.ibm.ad.oauth2.internal.Messages;
import com.ibm.ad.oauth2.model.HttpResponseConsumer;
import com.ibm.ad.oauth2.model.OAuth2Client;
import com.ibm.ad.oauth2.model.OAuth2Data;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.http.ExceptionLogger;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.bootstrap.HttpServer;
import org.apache.http.impl.bootstrap.ServerBootstrap;
import org.apache.http.protocol.HttpRequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicroClient {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    static Logger L = LoggerFactory.getLogger(MicroClient.class);
    private OAuth2Data data = null;
    private HttpServer server;
    private String token;
    private String refresh;
    private Handler handler;
    Object tokLock = new Object();
    boolean shouldRefresh = false;

    public void start(OAuth2Data d) throws IOException, InterruptedException {
        HttpServer server;
        if (d == null) {
            throw new IllegalArgumentException("must be started with OAuth2Data");
        }
        if (this.server != null) {
            throw new IllegalStateException("already started");
        }
        this.data = this.fillWithDiscovery(d);
        URI uri = URI.create(this.data.getRedirectURI());
        int port = uri.getPort();
        this.handler = new Handler(this.data);
        this.server = server = ServerBootstrap.bootstrap().setListenerPort(port).setServerInfo("Test/1.1").setExceptionLogger((ExceptionLogger)new StdErrorExceptionLogger()).registerHandler("/callback", (HttpRequestHandler)this.handler).create();
        this.server.start();
    }

    private OAuth2Data fillWithDiscovery(OAuth2Data data) {
        if (data.getDiscoveryURI() == null) {
            return data;
        }
        Map<String, String> authSrvInfo = OAuth2Client.discoverProvider(data);
        if (authSrvInfo != null) {
            String issuer = authSrvInfo.get("issuer");
            OAuth2Data d = new OAuth2Data.Builder(data).withTokenEndpoint(this.changeIssuer(data.getAuthIssuerURI(), issuer, authSrvInfo.get("token_endpoint"))).withAuthEndpoint(this.changeIssuer(data.getAuthIssuerURI(), issuer, authSrvInfo.get("authorization_endpoint"))).build();
            return d;
        }
        throw new RuntimeException("could not get discovery data");
    }

    public void stop() {
        if (this.server != null) {
            this.server.shutdown(1L, TimeUnit.SECONDS);
            this.server = null;
        }
    }

    public void request(String url, String method, String info, HttpResponseConsumer consumer) throws Exception {
        L.debug("requesting {} ", (Object)url);
        String tok = this.getToken();
        if (tok == null) {
            L.error("illegal state: not authenticated");
            throw new IllegalStateException(Messages.getString(MicroClient.class, "notAuthenticated.exception"));
        }
        Exception ex = null;
        if (!this.shouldRefresh) {
            try {
                OAuth2Client.getProtectedResource(url, method, info, tok, consumer);
            }
            catch (SecurityException se) {
                L.warn("exception getting resource", (Throwable)se);
                ex = se;
                this.shouldRefresh = true;
            }
            catch (FileNotFoundException fe) {
                L.warn("exception getting resource", (Throwable)fe);
                ex = fe;
            }
        }
        if (this.shouldRefresh || ex != null && ex instanceof SecurityException) {
            tok = this.refreshToken();
            if (tok != null) {
                OAuth2Client.getProtectedResource(url, method, info, tok, consumer);
            }
        } else if (ex != null) {
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getToken() {
        String tok = null;
        Object object = this.tokLock;
        synchronized (object) {
            tok = this.token;
        }
        return tok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String refreshToken() {
        String tok = null;
        if (this.shouldRefresh) {
            this.shouldRefresh = false;
            L.info("refresh token forced");
        }
        Object object = this.tokLock;
        synchronized (object) {
            if (this.refresh != null) {
                Map<String, String> td = OAuth2Client.refreshAccessToken(this.data, this.refresh);
                this.token = td.get("id_token");
                this.refresh = td.get("refresh_token");
            } else {
                this.token = null;
            }
            tok = this.token;
        }
        return tok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> obtainToken(OAuth2Data data) {
        final HashMap<String, String> ret = new HashMap<String, String>();
        String state = UUID.randomUUID().toString();
        final Object lock = new Object();
        final boolean[] timedout = new boolean[]{false};
        this.handler.addTokenDataConsumer(state, new Consumer<Map<String, String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void accept(Map<String, String> td) {
                if (!timedout[0]) {
                    ret.putAll(td);
                    Object object = lock;
                    synchronized (object) {
                        lock.notifyAll();
                    }
                }
            }
        });
        boolean ok = false;
        try {
            String authEndpoint = data.getAuthorizationEndpoint();
            if (authEndpoint != null) {
                URI uri = URI.create(authEndpoint);
                String scheme = uri.getScheme();
                String host = uri.getHost();
                int port = uri.getPort();
                String path = uri.getPath();
                uri = new URIBuilder().setScheme(scheme).setHost(host).setPort(port).setPath(path).setParameter("response_type", "code").setParameter("client_id", data.getClientID()).setParameter("redirect_uri", data.getRedirectURI()).setParameter("state", state).setParameter("scope", data.getScope()).build();
                ok = OAuth2Client.launchBrowser(uri.toString());
                L.info("browser launched for: {}", (Object)state);
            }
        }
        catch (Exception e) {
            L.error("error trying to authorize", (Throwable)e);
            ok = false;
        }
        if (ok) {
            Object object = lock;
            synchronized (object) {
                try {
                    lock.wait(data.getTimeout() * 1000L);
                    timedout[0] = true;
                }
                catch (InterruptedException interruptedException) {
                    L.debug("interrupted");
                }
            }
        }
        this.handler.removeTokenDataConsumer(state);
        if (ret.size() == 0) {
            L.info("timed out. will continue without authorization");
        }
        return ret;
    }

    public void shouldRefresh() {
        this.shouldRefresh = true;
    }

    @Deprecated
    public String getUser() throws Exception {
        L.error("do not use this method anymore; token is not parsed on client-side!");
        return null;
    }

    public synchronized boolean needAuth() {
        boolean ret = this.token == null;
        L.trace("needAuth={}", (Object)ret);
        return ret;
    }

    private String changeIssuer(String targetIssuer, String issuer, String url) {
        String changed = url;
        int idx = url.indexOf(issuer);
        if (idx != -1) {
            changed = String.valueOf(targetIssuer) + url.substring(issuer.length());
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void login() throws Exception {
        Object object = this.tokLock;
        synchronized (object) {
            String token = this.token;
            String refresh = null;
            if (token == null) {
                L.debug("starting authorization flow");
                Map<String, String> td = this.obtainToken(this.data);
                token = td.get("id_token");
                refresh = td.get("refresh_token");
            }
            if (token == null) {
                throw new Exception("could not obtain authorization data");
            }
            this.token = token;
            this.refresh = refresh;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout() {
        Object object = this.tokLock;
        synchronized (object) {
            this.token = null;
        }
    }
}

