/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ad.oauth2;

import com.ibm.ad.oauth2.MicroClient;
import com.ibm.ad.oauth2.internal.Messages;
import com.ibm.ad.oauth2.model.OAuth2Client;
import com.ibm.ad.oauth2.model.OAuth2Data;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;

class Handler
implements HttpRequestHandler {
    private OAuth2Data data;
    public Map<String, Consumer<Map<String, String>>> consumers = new ConcurrentHashMap<String, Consumer<Map<String, String>>>();

    public Handler(OAuth2Data data) {
        this.data = data;
    }

    public void addTokenDataConsumer(String id, Consumer<Map<String, String>> consumer) {
        this.consumers.put(id, consumer);
    }

    public void removeTokenDataConsumer(String id) {
        this.consumers.remove(id);
    }

    public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        MicroClient.L.debug("request: {}", (Object)request);
        Map<Object, Object> tokenData = new HashMap();
        boolean ok = true;
        String url = request.getRequestLine().getUri();
        String code = null;
        String state = null;
        try {
            List ps = URLEncodedUtils.parse((URI)new URI(url), (Charset)Charset.forName("UTF-8"));
            for (NameValuePair param : ps) {
                if (param.getName().equals("code")) {
                    code = param.getValue();
                }
                if (!param.getName().equals("state")) continue;
                state = param.getValue();
            }
        }
        catch (Exception e) {
            MicroClient.L.info("Error while handling request", (Throwable)e);
            ok = false;
        }
        MicroClient.L.debug("code={}", code);
        MicroClient.L.debug("state={}", state);
        if (ok) {
            try {
                tokenData = OAuth2Client.getAccessToken(this.data, code, state);
                Consumer<Map<String, String>> consumer = this.consumers.get(state);
                if (consumer != null) {
                    consumer.accept(tokenData);
                } else {
                    MicroClient.L.info("Consumer is null!");
                    ok = false;
                }
            }
            catch (Exception e) {
                MicroClient.L.info("Error while getting token", (Throwable)e);
                ok = false;
            }
        }
        ContentType ct = ContentType.create((String)"text/html", (String)"utf-8");
        if (ok) {
            response.setStatusCode(200);
            response.setHeader("Content-Type", "text/html; charset=utf-8");
            response.addHeader("Strict-Transport-Security", "max-age=31536000; includeSubDomains");
            response.setEntity((HttpEntity)new StringEntity(this.getReply(Messages.getString(MicroClient.class, "authorized.title"), Messages.getString(MicroClient.class, "authorized.message")), ct));
        } else {
            response.setStatusCode(400);
            response.setHeader("Content-Type", "text/html; charset=utf-8");
            response.addHeader("Strict-Transport-Security", "max-age=31536000; includeSubDomains");
            response.setEntity((HttpEntity)new StringEntity(this.getReply(Messages.getString(MicroClient.class, "notauthorized.title"), Messages.getString(MicroClient.class, "notauthorized.message")), ct));
        }
    }

    private String getReply(String msg1, String msg2) {
        String helpLabel = Messages.getString(MicroClient.class, "ibmhelp.address");
        return "<html>\n    <head>\n<meta charset=\"UTF-8\">\n        <style>\n            body {\n                overflow-y: scorll;\n                padding: 0;\n                margin: 20;\n                font-family: \"roboto\";\n            }\n        </style>\n    </head>\n    <body>\n        <div style=\"background-color:#074497; height:100px; display:flex; flex-direction: column; justify-content: center;\">\n            <p style=\"color: white; font-size: 24;\"><b>IBM Application Discovery</b></p>\n        </div>\n\n        <br/>\n        <br/>\n\n        <div align=\"center\">\n            <h1>\n                <p style=\"font-size:48;  color:#074497\"><b>" + msg1 + "</b></p>\n" + "        </div>\n" + "\n" + "        <div align=\"center\">\n" + "            <h1>\n" + "                <p style=\"font-size:36;  color:#074497\"><b>" + msg2 + "</b></p>\n" + "        </div>\n" + "\n" + "        <div style=\"background-color:white; height:400px;\">\n" + "        </div>\n" + "\n" + "        <a href=\"https://www.ibm.com/support/knowledgecenter/en/SSRR9Q\">\n" + "            <div style=\"text-align: right;\">\n" + "                <p style=\"font-size: 16; color:#074497\">" + helpLabel + "</p>\n" + "                </p>\n" + "            </div>\n" + "        </a>\n" + "\n" + "    </body>\n" + "</html>";
    }
}

