/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.cross;

import com.ez.graphs.internal.Messages;
import com.ez.mainframe.model.ProjectInfo;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MFProjectChooserDialog
extends TrayDialog {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(MFProjectChooserDialog.class);
    private static final String SELECT_LABEL = Messages.getString(MFProjectChooserDialog.class, (String)"select.button");
    private static final int DIALOG_MIN_HEIGHT = 200;
    private static final int DIALOG_MIN_WIDTH = 300;
    private org.eclipse.swt.widgets.List avList;
    private List<ProjectInfo> selPrjList;
    private List<ProjectInfo> availableProjects;
    private String title;
    boolean isBackward = false;
    private Button backwardButton;
    private Button forwardButton;

    public MFProjectChooserDialog(Shell shell, List<ProjectInfo> availableProjects, String title) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.availableProjects = availableProjects;
        this.title = title;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setMinimumSize(300, 200);
        newShell.setText(this.title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.heightHint = 300;
        area.setLayoutData((Object)data);
        GridLayout gl = (GridLayout)area.getLayout();
        area.setLayout((Layout)gl);
        Label prjLbl = new Label(area, 0);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        prjLbl.setLayoutData((Object)data);
        prjLbl.setText(Messages.getString(MFProjectChooserDialog.class, (String)"chooseProjects.dialog.label"));
        this.avList = new org.eclipse.swt.widgets.List(area, 2818);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        this.avList.setLayoutData((Object)data);
        ProjectSelectionListener selectionListener = new ProjectSelectionListener();
        this.avList.addSelectionListener((SelectionListener)selectionListener);
        this.fillProjectsList();
        this.createDirectionGroup(area);
        return area;
    }

    private void fillProjectsList() {
        if (this.availableProjects != null && this.availableProjects.size() > 0) {
            ArrayList<String> names = new ArrayList<String>();
            for (ProjectInfo pi : this.availableProjects) {
                String prjName = pi.getName();
                names.add(prjName);
                this.avList.setData(prjName, (Object)pi);
            }
            String[] namePrjs = names.toArray(new String[0]);
            this.avList.setItems(namePrjs);
        }
    }

    private void createDirectionGroup(Composite parent) {
        Group settingsGroup = new Group(parent, parent.getStyle());
        DirectionSelection ds = new DirectionSelection();
        settingsGroup.setText(Messages.getString(MFProjectChooserDialog.class, (String)"direction.group.txt"));
        GridData data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 1024;
        settingsGroup.setLayoutData((Object)data);
        GridLayout gl = new GridLayout(3, false);
        gl.horizontalSpacing = 20;
        settingsGroup.setLayout((Layout)gl);
        this.forwardButton = new Button((Composite)settingsGroup, 16);
        this.forwardButton.setText(Messages.getString(MFProjectChooserDialog.class, (String)"forward.btn.txt"));
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = false;
        data.verticalAlignment = 1024;
        data.minimumWidth = 80;
        this.forwardButton.setLayoutData((Object)data);
        this.forwardButton.addSelectionListener((SelectionListener)ds);
        this.forwardButton.setSelection(!this.isBackward);
        this.backwardButton = new Button((Composite)settingsGroup, 16);
        this.backwardButton.setText(Messages.getString(MFProjectChooserDialog.class, (String)"backward.btn.txt"));
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 1024;
        data.minimumWidth = 80;
        this.backwardButton.setLayoutData((Object)data);
        this.backwardButton.addSelectionListener((SelectionListener)ds);
        this.backwardButton.setSelection(this.isBackward);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button select = this.createButton(parent, 0, SELECT_LABEL, true);
        select.setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        super.okPressed();
    }

    public List<ProjectInfo> getSelectedPrjs() {
        return this.selPrjList;
    }

    public boolean isBackward() {
        return this.isBackward;
    }

    public boolean isHelpAvailable() {
        return false;
    }

    class DirectionSelection
    extends SelectionAdapter {
        DirectionSelection() {
        }

        public void widgetSelected(SelectionEvent e) {
            Button b = (Button)e.getSource();
            MFProjectChooserDialog.this.isBackward = b.equals(MFProjectChooserDialog.this.backwardButton);
        }
    }

    class ProjectSelectionListener
    extends SelectionAdapter {
        ProjectSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            String[] selPrjNameList = ((org.eclipse.swt.widgets.List)e.getSource()).getSelection();
            if (selPrjNameList != null && selPrjNameList.length > 0) {
                MFProjectChooserDialog.this.selPrjList = new ArrayList();
                int i = 0;
                while (i < selPrjNameList.length) {
                    MFProjectChooserDialog.this.selPrjList.add((ProjectInfo)MFProjectChooserDialog.this.avList.getData(selPrjNameList[i]));
                    ++i;
                }
                MFProjectChooserDialog.this.getButton(0).setEnabled(true);
            }
        }
    }
}

