/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.cross;

import com.ez.cobol.callgraph.CallgraphNodeLegendInfo;
import com.ez.cobol.callgraph.utils.CallgraphEdgeUtils;
import com.ez.graphs.internal.Messages;
import com.ez.graphs.sharedresources.SharedResourcesNodeLegendInfo;
import com.ez.graphs.viewer.cross.CrossMainframeGraphAnalysis;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.analysis.config.inputs.EZSourceProjectInputType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.generator.EZObjectTypeGeneratorForMainframe;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.analysis.graph.LoadTSESVGImage;
import com.ez.workspace.analysis.graph.gui.ExportAsCSV;
import com.ez.workspace.analysis.graph.model.AbstractAnalysisGraphModel;
import com.ez.workspace.analysis.graph.model.IGraphNodeLegendInfo;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.ez.workspace.model.segments.EZSourceTransactionIDSg;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graphicaldrawing.TSEEdge;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.graphicaldrawing.awt.TSEColor;
import com.tomsawyer.graphicaldrawing.awt.TSESVGImage;
import com.tomsawyer.graphicaldrawing.builder.TSEdgeBuilder;
import com.tomsawyer.graphicaldrawing.builder.TSNodeBuilder;
import images.LoadSVGImages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrossMainframeGraphModel
extends AbstractAnalysisGraphModel {
    private static final Logger L = LoggerFactory.getLogger(CrossMainframeGraphModel.class);
    private CrossMainframeGraphAnalysis analysis;
    private Map<String, TSENode> transactionTSNodes = new HashMap<String, TSENode>();
    private Map<String, TSENode> prjTSNodes = new HashMap<String, TSENode>();

    public CrossMainframeGraphModel(AnalysisGraphManager graphManager, AbstractSharedAnalysis analysis) {
        this.graphManager = graphManager;
        this.analysis = (CrossMainframeGraphAnalysis)analysis;
        this.initialize();
    }

    private void initialize() {
        if (!TSESVGImage.isBatikInitialized()) {
            TSESVGImage.initBatik();
        }
        this.graph = (TSEGraph)((AnalysisGraphManager)this.graphManager).addGraph();
    }

    private void initGraph() {
        this.graph = (TSEGraph)((AnalysisGraphManager)this.graphManager).addGraph();
        this.outForGISV.clear();
        this.transactionTSNodes.clear();
        this.prjTSNodes.clear();
        ArrayList<Class<ExportAsCSV>> impl = new ArrayList<Class<ExportAsCSV>>();
        impl.add(ExportAsCSV.class);
        this.graphManager.setAttribute("extraExportListImplementors", impl);
        this.graphManager.setAttribute("IS_CROSS_ANALYSIS_GRAPH", (Object)Boolean.TRUE);
    }

    public void loadGraph(IProgressMonitor monitor) {
        SubMonitor pmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)200);
        pmonitor.setTaskName(Messages.getString(CrossMainframeGraphModel.class, (String)"loading.graph"));
        this.initGraph();
        TSNodeBuilder nodeBuilder = this.graphManager.getNodeBuilder();
        nodeBuilder.setResizability(3);
        TSEdgeBuilder edgeBuilder = this.graphManager.getEdgeBuilder();
        this.graphManager.startBatchProcessing(true);
        SharedResourcesNodeLegendInfo nodeTypeInfo = SharedResourcesNodeLegendInfo.PROJECT;
        TSESVGImage svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)nodeTypeInfo.getGraphImagePath());
        Map resultsMap = (Map)this.analysis.getContextValue("TRANS_RESULTS_FOR_END_PROJECTS");
        if (resultsMap != null && !resultsMap.isEmpty()) {
            Boolean isBackward = (Boolean)this.analysis.getContextValue("IsBackward");
            for (ProjectInfo pi : resultsMap.keySet()) {
                String[][] transactionResults = (String[][])resultsMap.get(pi);
                if (transactionResults == null) continue;
                String[][] stringArray = transactionResults;
                int n = transactionResults.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] res = stringArray[n2];
                    String tranName = res[0];
                    TSENode tranNode = this.getOrMakeTranNode(tranName, pi);
                    TSENode prjNode = this.getOrMakePrjNode(pi, (IGraphNodeLegendInfo)nodeTypeInfo, svgimage, false);
                    if (isBackward.booleanValue()) {
                        edgeBuilder.addEdge(this.graphManager, prjNode, tranNode);
                    } else {
                        TSEEdge edge = edgeBuilder.addEdge(this.graphManager, tranNode, prjNode);
                        edge.setAttribute("Color", (Object)CallgraphEdgeUtils.EDGE_TRANSACTION_TO_MAPPED_PROGRAM);
                    }
                    ++n2;
                }
            }
            Map inpResultsMap = (Map)this.analysis.getContextValue("TRANS_RESULTS_FOR_INPUT_PROJECTS");
            ArrayList<TSENode> inputPrjList = new ArrayList<TSENode>();
            for (ProjectInfo pi : inpResultsMap.keySet()) {
                TSENode prjNode = this.getOrMakePrjNode(pi, (IGraphNodeLegendInfo)nodeTypeInfo, svgimage, true);
                String[][] transactionResults = (String[][])inpResultsMap.get(pi);
                if (transactionResults == null) continue;
                String[][] stringArray = transactionResults;
                int n = transactionResults.length;
                int n3 = 0;
                while (n3 < n) {
                    String[] res = stringArray[n3];
                    String tranName = res[0];
                    TSENode tranNode = this.transactionTSNodes.get(tranName);
                    if (tranNode != null) {
                        this.createAppInputType(tranName, tranNode, pi);
                        if (tranNode != null && !this.graph.hasEdge((TSNode)prjNode, (TSNode)tranNode)) {
                            if (isBackward.booleanValue()) {
                                TSEEdge edge = edgeBuilder.addEdge(this.graphManager, tranNode, prjNode);
                                edge.setAttribute("Color", (Object)CallgraphEdgeUtils.EDGE_TRANSACTION_TO_MAPPED_PROGRAM);
                            } else {
                                edgeBuilder.addEdge(this.graphManager, prjNode, tranNode);
                            }
                        }
                    }
                    ++n3;
                }
                inputPrjList.add(prjNode);
            }
            this.graphManager.setAttribute("inputNode", inputPrjList);
            this.graphManager.setAttribute("isBackward", (Object)isBackward);
        } else {
            TSENode node = (TSENode)this.graph.addNode();
            node.setName((Object)NO_RESULTS_NODE_LABEL);
        }
        pmonitor.worked(50);
        this.graphManager.endBatchProcessing();
        pmonitor.setWorkRemaining(0);
    }

    private TSENode getOrMakeTranNode(String tranName, ProjectInfo pi) {
        TSENode tranNode = this.transactionTSNodes.get(tranName);
        if (tranNode == null) {
            tranNode = this.graphManager.getNodeBuilder().addNode(this.graph);
            this.transactionTSNodes.put(tranName, tranNode);
            tranNode.setName((Object)tranName);
            tranNode.setTooltipText(tranName);
            CallgraphNodeLegendInfo nodeTypeInfo = CallgraphNodeLegendInfo.TRANSACTION;
            tranNode.setAttribute("class_name", (Object)nodeTypeInfo.getNodeTypeClass());
            TSESVGImage svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)nodeTypeInfo.getGraphImagePath());
            this.createAppInputType(tranName, tranNode, pi);
            this.setNodeUI(tranNode, svgimage, nodeTypeInfo.getTSEColor(), TSEColor.white);
            this.putEntryInGraphInventory(nodeTypeInfo.getLegendLabel(), tranNode);
        } else {
            this.createAppInputType(tranName, tranNode, pi);
        }
        return tranNode;
    }

    private void createAppInputType(String tranName, TSENode tranNode, ProjectInfo pi) {
        EZSourceProjectIDSg prjIdSg;
        HashSet<EZSourceProjectIDSg> prjSgs = (HashSet<EZSourceProjectIDSg>)tranNode.getAttributeValue("project sgs to start all available analysis for each project");
        if (prjSgs == null) {
            prjSgs = new HashSet<EZSourceProjectIDSg>();
            tranNode.setAttribute("project sgs to start all available analysis for each project", prjSgs);
        }
        if (!prjSgs.contains(prjIdSg = new EZSourceProjectIDSg(pi))) {
            prjSgs.add(prjIdSg);
            EZEntityID entity = new EZEntityID();
            entity.addSegment((EZSegment)prjIdSg);
            EZSourceTransactionIDSg trIdSg = new EZSourceTransactionIDSg(tranName);
            entity.addSegment((EZSegment)trIdSg);
            EZObjectType inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(14), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
            inputType.setName(tranName);
            inputType.setEntID(entity);
            tranNode.setAttribute("APPLICABLE_INPUT".concat(pi.getName()), (Object)inputType);
        }
    }

    private TSENode getOrMakePrjNode(ProjectInfo pi, IGraphNodeLegendInfo nodeTypeInfo, TSESVGImage svgimage, boolean isInput) {
        TSENode prjNode = this.prjTSNodes.get(pi.getName());
        if (prjNode == null) {
            prjNode = this.graphManager.getNodeBuilder().addNode(this.graph);
            this.prjTSNodes.put(pi.getName(), prjNode);
            prjNode.setName((Object)pi.getName());
            prjNode.setTooltipText(pi.getName());
            prjNode.setAttribute("class_name", (Object)nodeTypeInfo.getNodeTypeClass());
            if (isInput) {
                prjNode.setAttribute("node is input for callgraph", (Object)Boolean.TRUE);
            }
            this.createProjectInputType(pi, prjNode);
            this.setNodeUI(prjNode, svgimage, nodeTypeInfo.getTSEColor(), TSEColor.white);
            this.putEntryInGraphInventory(nodeTypeInfo.getLegendLabel(), prjNode);
        }
        return prjNode;
    }

    private void createProjectInputType(ProjectInfo pi, TSENode prjNode) {
        EZSourceProjectInputType prjInputType = new EZSourceProjectInputType();
        prjInputType.setName(pi.getName());
        prjInputType.addProperty("PROJECT_INFO", (Object)pi);
        EZEntityID entID = new EZEntityID();
        entID.addSegment((EZSegment)new EZSourceProjectIDSg(pi));
        prjInputType.setEntID(entID);
        prjNode.setAttribute("APPLICABLE_INPUT", (Object)prjInputType);
    }

    public void setNodeUI(TSENode node) {
        TSESVGImage img = (TSESVGImage)node.getAttributeValue("uiImage");
        if (this.uiStyle == 2 && img != null) {
            node.setAttribute("uiStyle", (Object)"svg");
            node.setAttribute("Text_Color", (Object)TSEColor.black);
        } else {
            node.setAttribute("uiStyle", (Object)"!svg");
        }
        if (node.hasAttribute("node is input for callgraph")) {
            node.setAttribute("Text_Color", (Object)TSEColor.blue);
        }
    }

    public void setNodeUI(TSENode node, TSESVGImage svgImage, TSEColor fillColor, TSEColor textColor) {
        node.setAttribute("Fill_Color", (Object)fillColor);
        node.setAttribute("uiImage", (Object)svgImage);
        if (textColor != null) {
            node.setAttribute("Color", (Object)textColor);
            if ("!svg".equals(node.getAttributeValue("uiStyle"))) {
                node.setAttribute("Text_Color", (Object)textColor);
            }
        }
        this.setNodeUI(node);
    }

    public void updateDrawing() {
        TSDGraph hide;
        super.updateDrawing();
        List nodes = this.graph.nodes();
        if (nodes != null) {
            for (TSENode node : nodes) {
                this.setNodeUI(node);
            }
        }
        if ((hide = this.graph.hideOrHideFromGraph) != null && (nodes = hide.nodes()) != null) {
            for (TSENode node : nodes) {
                this.setNodeUI(node);
            }
        }
    }

    private void putEntryInGraphInventory(String lbl, TSENode node) {
        HashSet<TSENode> nodes = (HashSet<TSENode>)this.outForGISV.get(lbl);
        if (nodes == null) {
            nodes = new HashSet<TSENode>();
            this.outForGISV.put(lbl, nodes);
        }
        nodes.add(node);
    }

    public EZObjectType getApplicableInputType(TSNode gNode) {
        EZObjectType objType = null;
        if (gNode != null && gNode.hasAttribute("APPLICABLE_INPUT")) {
            objType = (EZObjectType)gNode.getAttributeValue("APPLICABLE_INPUT");
        }
        return objType;
    }
}

