/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.cross;

import com.ez.cobol.callgraph.CallgraphNodeLegendInfo;
import com.ez.cobol.callgraph.MainframeMouseActionsHook;
import com.ez.cobol.callgraph.nodes.MainframeProjectNode;
import com.ez.cobol.callgraph.nodes.TransactionNode;
import com.ez.cobol.callgraph.utils.Utils;
import com.ez.ezdao.api.EZSourceDataType;
import com.ez.graphs.internal.Messages;
import com.ez.graphs.mainframe.MainframeMenuMouseActionHook;
import com.ez.graphs.sharedresources.SharedResourcesNodeLegendInfo;
import com.ez.graphs.viewer.Activator;
import com.ez.graphs.viewer.cross.CrossEdgeLegendInfo;
import com.ez.graphs.viewer.cross.CrossMainframeGraphModel;
import com.ez.internal.graphmodel.CloseHook;
import com.ez.internal.id.EZEntityID;
import com.ez.mainframe.gui.graphs.ContentProvider;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.analysis.graph.gui.ComponentBuilderInterface;
import com.ez.workspace.analysis.graph.gui.LegendPanel;
import com.ez.workspace.analysis.graph.job.GraphAnalysisJob;
import com.ez.workspace.analysis.graph.model.AbstractAnalysisGraphModel;
import com.ez.workspace.analysis.graph.model.GraphFilterInfo;
import com.ez.workspace.analysis.graph.model.GraphInfo;
import com.ez.workspace.analysis.graph.model.GraphInfoAdapter;
import com.ez.workspace.analysis.graph.model.StructureContentProvider;
import com.ez.workspace.analysis.graph.mouseHook.EZMouseTool;
import com.ez.workspace.analysis.graph.mouseHook.MouseActionsHook;
import com.tomsawyer.interactive.swing.overview.TSEOverviewComponent;
import com.tomsawyer.interactive.tool.TSToolInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.ISelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrossMainframeGraphAnalysisJob
extends GraphAnalysisJob {
    private static final Logger L = LoggerFactory.getLogger(CrossMainframeGraphAnalysisJob.class);
    public static final String START_PRJS_TRAN_RESULTS = "TRANS_RESULTS_FOR_INPUT_PROJECTS";
    public static final String END_PRJS_TRAN_RESULTS = "TRANS_RESULTS_FOR_END_PROJECTS";
    public static final String STARTING_PROJECTS = "START";
    public static final String IS_BACKWARD = "IsBackward";
    private MainframeMouseActionsHook mouseActionsHook = null;

    public CrossMainframeGraphAnalysisJob(EZEntityID id) {
        super(id);
        this.mouseActionsHook = new MainframeMenuMouseActionHook(id);
        this.initGraphDetails();
    }

    protected void initGraphDetails() {
        this.graphInfo = new CrossGraphInfo(this.id);
        this.graphInfo.setCloseHook((CloseHook)this);
        this.gfi = new GraphFilterInfo();
        this.graphInfo.setGraphFilterInfo(this.gfi);
        this.addFilters(this.gfi);
        this.graphModel = new CrossMainframeGraphModel(new AnalysisGraphManager(), this.analysis);
        if (this.graphInfo.getContentProviders() == null) {
            ContentProvider icp = new ContentProvider((MouseActionsHook)this.mouseActionsHook);
            icp.setHasExport(true);
            this.graphInfo.setContentProvider((StructureContentProvider)icp);
        }
        super.initGraphDetails();
    }

    public void buildComponents(Composite composite) {
        super.buildComponents(composite);
        this.canvas.getToolManager().register("mouse", (TSToolInterface)new EZMouseTool((MouseActionsHook)this.mouseActionsHook));
        this.canvas.getToolManager().setDefaultTool(this.canvas.getToolManager().getTool("mouse"));
        this.mouseActionsHook.setAnalysis(this.analysis);
        this.mouseActionsHook.setSelectJob(this.selectJob);
        this.mouseActionsHook.setGraphInfo((GraphInfo)this.graphInfo);
        this.mouseActionsHook.setGraphModel(this.graphModel);
    }

    protected void computeResults(AbstractAnalysisGraphModel graphModel, IProgressMonitor pmonitor) {
        String[][] results;
        L.debug("cross mainframe graph - computeResults");
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(CrossMainframeGraphAnalysisJob.class, (String)"collectingData.taskName"));
        Boolean isBackward = (Boolean)this.analysis.getContextValue(IS_BACKWARD);
        List startPrjs = this.analysis.getContextListValue(STARTING_PROJECTS);
        List allPrjs = this.analysis.getContextListValue("input_list");
        HashMap<ProjectInfo, String[][]> startMap = new HashMap<ProjectInfo, String[][]>();
        this.analysis.addContextValue(START_PRJS_TRAN_RESULTS, startMap);
        HashMap<ProjectInfo, String[][]> endMap = new HashMap<ProjectInfo, String[][]>();
        this.analysis.addContextValue(END_PRJS_TRAN_RESULTS, endMap);
        String firstProcName = isBackward != false ? "EZViewer_MappedTransaction" : "EZViewer_UsedTransaction";
        String secondProcName = isBackward != false ? "EZViewer_UsedTransaction_Selective" : "EZViewer_MappedTransaction_Selective";
        HashSet<String> trNames = new HashSet<String>();
        for (ProjectInfo prjInfo : startPrjs) {
            results = Utils.runProc((String)firstProcName, null, null, (String)prjInfo.getName());
            if (results == null || results.length <= 0) continue;
            String[][] stringArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                String[] trResults = stringArray[n2];
                trNames.add(trResults[0]);
                ++n2;
            }
            startMap.put(prjInfo, results);
        }
        if (!trNames.isEmpty()) {
            for (ProjectInfo prjInfo : allPrjs) {
                if (startPrjs.contains(prjInfo) || prjInfo.isEclipse() || (results = Utils.runProc((String)secondProcName, trNames, (EZSourceDataType)EZSourceDataType.String, (String)prjInfo.getName())) == null || results.length <= 0) continue;
                endMap.put(prjInfo, results);
            }
        }
        monitor.setWorkRemaining(0);
    }

    protected IStatus finalTSGraphOperations(IProgressMonitor monitor, IStatus result) {
        SubMonitor pmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        monitor.setTaskName(Messages.getString(CrossMainframeGraphAnalysisJob.class, (String)"dolayout.taskName"));
        IStatus statusResult = super.finalTSGraphOperations((IProgressMonitor)pmonitor.newChild(50), result);
        if (this.gfi != null) {
            this.gfi.registerFilterType(MainframeProjectNode.class);
            this.gfi.registerFilterType(TransactionNode.class);
            HashSet allNodes = new HashSet();
            Collection nodesSetsList = this.graphModel.getOutForStructView().values();
            for (Set nodesSet : nodesSetsList) {
                allNodes.addAll(nodesSet);
            }
            this.gfi.initFilters(this.graphManager, this.graphModel.getGraph(), this.canvas, (TSEOverviewComponent)this.graphInfo.getOverviewComponent(), allNodes);
        }
        pmonitor.setWorkRemaining(0);
        return statusResult;
    }

    public void makeGraphActions() {
        super.makeGraphActions();
        this.createEdgesActions();
        this.createIconActions();
    }

    public List getMenuItems() {
        List menus = super.getMenuItems();
        this.contributeEdgesEntries(menus);
        this.contributeIconEntries(menus);
        return menus;
    }

    public List getToolBarItems() {
        List defaultTools = super.getToolBarItems();
        ArrayList<Separator> toolbars = new ArrayList<Separator>();
        this.contributeEdgesEntries(toolbars);
        this.contributeIconEntries(toolbars);
        toolbars.add(new Separator());
        toolbars.addAll(defaultTools);
        return toolbars;
    }

    public void changeActionsState(boolean state) {
        super.changeActionsState(state);
        this.changeEdgesActionsState();
        this.changeIconsActionsState(state);
    }

    private void addFilters(GraphFilterInfo gfi) {
    }

    class CrossGraphInfo
    extends GraphInfoAdapter {
        GraphFilterInfo gfi;
        String tabName;

        public CrossGraphInfo(EZEntityID id) {
            super(id);
            this.gfi = null;
        }

        public Image getImage() {
            if (this.image == null) {
                this.image = Activator.getImageDescriptor((String)"icons/programcall.png").createImage();
            }
            return this.image;
        }

        public String getText() {
            return this.getText(true);
        }

        public String getText(boolean truncate) {
            StringBuilder inputSb = new StringBuilder();
            Boolean isBack = (Boolean)CrossMainframeGraphAnalysisJob.this.analysis.getContextValue(CrossMainframeGraphAnalysisJob.IS_BACKWARD);
            String text = "";
            int nr = 0;
            List inputPrjs = CrossMainframeGraphAnalysisJob.this.analysis.getContextListValue(CrossMainframeGraphAnalysisJob.STARTING_PROJECTS);
            int idx = 0;
            int inptsSize = inputPrjs.size();
            boolean cut = false;
            for (ProjectInfo pi : inputPrjs) {
                if (truncate && idx >= 3) {
                    nr = inptsSize - idx;
                    cut = true;
                    break;
                }
                if (idx > 0) {
                    inputSb.append(", ");
                }
                inputSb.append(pi.getName());
                ++idx;
            }
            boolean endPrjsListCut = false;
            StringBuilder endSb = new StringBuilder();
            int endnr = 0;
            if (!cut) {
                List endPrjs = CrossMainframeGraphAnalysisJob.this.analysis.getContextListValue("input_list");
                idx = 0;
                int endSize = endPrjs.size() - inptsSize;
                for (ProjectInfo pi : endPrjs) {
                    if (inputPrjs.contains(pi)) continue;
                    if (truncate && idx >= 3) {
                        endPrjsListCut = true;
                        endnr = endSize - idx;
                        break;
                    }
                    if (idx > 0) {
                        endSb.append(", ");
                    }
                    endSb.append(pi.getName());
                    ++idx;
                }
            }
            text = isBack.booleanValue() ? (!cut ? (!endPrjsListCut ? Messages.getString(CrossMainframeGraphAnalysisJob.class, (String)"bw.tab.label", (Object[])new String[]{inputSb.toString(), endSb.toString()}) : Messages.getString(CrossMainframeGraphAnalysisJob.class, (String)"bw.last.more.tab.label", (Object[])new String[]{inputSb.toString(), endSb.toString(), String.valueOf(endnr)})) : Messages.getString(CrossMainframeGraphAnalysisJob.class, (String)"bw.input.more.tab.label", (Object[])new String[]{inputSb.toString(), String.valueOf(nr)})) : (!cut ? (!endPrjsListCut ? Messages.getString(CrossMainframeGraphAnalysisJob.class, (String)"fw.tab.label", (Object[])new String[]{inputSb.toString(), endSb.toString()}) : Messages.getString(CrossMainframeGraphAnalysisJob.class, (String)"fw.last.more.tab.label", (Object[])new String[]{inputSb.toString(), endSb.toString(), String.valueOf(endnr)})) : Messages.getString(CrossMainframeGraphAnalysisJob.class, (String)"fw.input.more.tab.label", (Object[])new String[]{inputSb.toString(), String.valueOf(nr)}));
            return text;
        }

        public String getTooltip() {
            return this.getText(false);
        }

        public ISelectionListener getSelectionListener() {
            return null;
        }

        public ComponentBuilderInterface getLegendControl() {
            return new ComponentBuilderInterface(){

                public Composite buildComponent(Composite parent) {
                    ScrolledComposite sc = new ScrolledComposite(parent, 768);
                    CrossMainframeGraphAnalysisJob.this.legend = new LegendPanel((Composite)sc, 0);
                    if (CrossMainframeGraphAnalysisJob.this.legend != null) {
                        CrossMainframeGraphAnalysisJob.this.legend.setFilters(CrossGraphInfo.this.gfi);
                    }
                    Utils.setImageProvider((LegendPanel)CrossMainframeGraphAnalysisJob.this.legend);
                    int uiStyle = CrossMainframeGraphAnalysisJob.this.graphModel.getUIStyle();
                    String legendImagePath = null;
                    legendImagePath = uiStyle == 2 ? SharedResourcesNodeLegendInfo.PROJECT.getLegendImagePath() : SharedResourcesNodeLegendInfo.PROJECT.getColorboxImagePath();
                    CrossMainframeGraphAnalysisJob.this.legend.placeLegendEntry(SharedResourcesNodeLegendInfo.PROJECT.getNodeTypeClass(), legendImagePath, SharedResourcesNodeLegendInfo.PROJECT.getLegendLabel());
                    legendImagePath = uiStyle == 2 ? CallgraphNodeLegendInfo.TRANSACTION.getLegendImagePath() : CallgraphNodeLegendInfo.TRANSACTION.getColorboxImagePath();
                    CrossMainframeGraphAnalysisJob.this.legend.placeLegendEntry(CallgraphNodeLegendInfo.TRANSACTION.getNodeTypeClass(), legendImagePath, CallgraphNodeLegendInfo.TRANSACTION.getLegendLabel());
                    CrossMainframeGraphAnalysisJob.this.legend.placeLegendEntry(CrossEdgeLegendInfo.INVOKES.getLegendImagePath(), CrossEdgeLegendInfo.INVOKES.getLegendLabel());
                    CrossMainframeGraphAnalysisJob.this.legend.placeLegendEntry(CrossEdgeLegendInfo.TRANSACTION_TO_MAPPED_PROGRAM.getLegendImagePath(), CrossEdgeLegendInfo.TRANSACTION_TO_MAPPED_PROGRAM.getLegendLabel());
                    sc.setContent((Control)CrossMainframeGraphAnalysisJob.this.legend);
                    sc.setExpandHorizontal(true);
                    sc.setExpandVertical(true);
                    CrossMainframeGraphAnalysisJob.this.legend.pack();
                    sc.setMinSize(CrossMainframeGraphAnalysisJob.this.legend.getSize());
                    return sc;
                }

                public int getPercent() {
                    int legendW = ((CrossMainframeGraphAnalysisJob)((CrossGraphInfo)CrossGraphInfo.this).CrossMainframeGraphAnalysisJob.this).legend.getSize().x;
                    int x = ((CrossMainframeGraphAnalysisJob)((CrossGraphInfo)CrossGraphInfo.this).CrossMainframeGraphAnalysisJob.this).legend.getParent().getParent().getSize().x;
                    int percent = 100 * (x - legendW) / x;
                    return percent;
                }
            };
        }

        public boolean hasLegend() {
            return true;
        }

        public void setGraphFilterInfo(GraphFilterInfo gfi) {
            this.gfi = gfi;
        }

        public GraphFilterInfo getGraphFilterInfo() {
            return this.gfi;
        }
    }
}

