/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.cross;

import com.ez.graphs.MainframeGraphAnalysis;
import com.ez.graphs.viewer.cross.CrossMainframeGraphAnalysisJob;
import com.ez.graphs.viewer.cross.MFProjectChooserDialog;
import com.ez.internal.analysis.AnalysisType;
import com.ez.internal.analysis.config.inputs.EZSourceProjectInputType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.filters.InputsFilter;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.analysis.AbstractAnalysis;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.analysis.EZAnalysis;
import com.ez.workspace.analysis.job.AbstractAnalysisJob;
import com.ez.workspace.model.EZWorkspace;
import com.ez.workspace.model.segments.AnalysisIDSegment;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrossMainframeGraphAnalysis
extends MainframeGraphAnalysis {
    private static final Logger L = LoggerFactory.getLogger(CrossMainframeGraphAnalysis.class);
    private CrossMainframeGraphAnalysisJob job;

    protected AbstractAnalysisJob getJob(EZEntityID id) {
        if (this.job == null) {
            EZWorkspace wk = EZWorkspace.getInstance();
            this.job = (CrossMainframeGraphAnalysisJob)wk.getJob(id, CrossMainframeGraphAnalysisJob.class);
        }
        this.job.setAnalysis((AbstractSharedAnalysis)this);
        return this.job;
    }

    public void setInputs(List inputs) {
        ArrayList<ProjectInfo> list = new ArrayList<ProjectInfo>();
        for (Object inpObj : inputs) {
            if (!(inpObj instanceof EZSourceProjectInputType)) continue;
            EZSourceProjectInputType prjInputType = (EZSourceProjectInputType)inpObj;
            EZSourceProjectIDSg prjSg = (EZSourceProjectIDSg)prjInputType.getEntID().getSegment(EZSourceProjectIDSg.class);
            list.add(prjSg.getProjectInfo());
        }
        if (!list.isEmpty()) {
            this.addContextValue("input_list", list);
        } else {
            L.warn("Mainframe cross analysis without valid input");
        }
    }

    public boolean equals(Object obj) {
        List inputs2;
        List inputs1;
        Boolean isBack2;
        Boolean isBack1;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractAnalysis)) {
            return false;
        }
        AbstractAnalysis a2 = (AbstractAnalysis)obj;
        boolean ret = this.type.equals((Object)a2.getType());
        if (ret && (ret = (isBack1 = (Boolean)this.getContextValue("IsBackward")).equals(isBack2 = (Boolean)a2.getContextValue("IsBackward"))) && (ret = (inputs1 = this.getContextListValue("START")).equals(inputs2 = a2.getContextListValue("START")))) {
            List start1 = this.getContextListValue("input_list");
            List start2 = a2.getContextListValue("input_list");
            ret = start1.equals(start2);
        }
        return ret;
    }

    public boolean filterInputs() {
        final List inputPrjs = this.getContextListValue("input_list");
        final boolean[] ok = new boolean[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MFProjectChooserDialog dialog = new MFProjectChooserDialog(Display.getDefault().getActiveShell(), inputPrjs, CrossMainframeGraphAnalysis.this.getLabelType());
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    CrossMainframeGraphAnalysis.this.addContextValue("START", dialog.getSelectedPrjs());
                    CrossMainframeGraphAnalysis.this.addContextValue("AUDIT_PROJ_NAMES", dialog.getSelectedPrjs().stream().map(ProjectInfo::getName).collect(Collectors.toList()));
                    CrossMainframeGraphAnalysis.this.addContextValue("IsBackward", dialog.isBackward());
                } else {
                    ok[0] = true;
                }
            }
        });
        return ok[0];
    }

    public String getLabelType() {
        return this.getType().getName();
    }

    protected EZEntityID makeID() {
        EZEntityID id = new EZEntityID();
        AnalysisIDSegment sg = new AnalysisIDSegment((EZAnalysis)this);
        id.addSegment((EZSegment)sg);
        return id;
    }

    protected AnalysisType getAnalysisType() {
        return AnalysisType.CROSS_APPS_CALL_GRAPH;
    }

    protected InputsFilter getInputsFilter() {
        InputsFilter iFilter = null;
        return iFilter;
    }
}

