/*
 * Decompiled with CFR 0.152.
 */
package com.ez.eclient.logging.preferences.internal;

import com.ez.eclient.logging.preferences.PreferenceConstants;
import com.ez.eclient.logging.preferences.PreferenceUtils;
import com.ez.eclient.logging.preferences.TracingStartupMonitor;
import java.net.URL;
import java.util.Hashtable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.impl.Log4jContextFactory;
import org.apache.logging.log4j.core.osgi.BundleContextSelector;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.apache.logging.log4j.spi.LoggerContextFactory;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.osgi.service.runnable.StartupMonitor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Activator
extends Plugin {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String PLUGIN_ID = "com.ez.eclient.logging.preferences";
    ServiceRegistration<StartupMonitor> serv;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        TracingStartupMonitor startupMonitor = new TracingStartupMonitor();
        this.serv = context.registerService(StartupMonitor.class, (Object)startupMonitor, new Hashtable(1));
        startupMonitor.registerListener(new LogApplicationRunningListener());
    }

    public void stop(BundleContext context) throws Exception {
        if (this.serv != null) {
            context.ungetService(this.serv.getReference());
        }
        super.stop(context);
    }

    private void log(String msg) {
        System.out.println(String.format("%s: %s", Activator.class, msg));
    }

    private class LogApplicationRunningListener
    implements TracingStartupMonitor.ApplicationRunningListener {
        private LogApplicationRunningListener() {
        }

        @Override
        public void applicationRunning() {
            String logDir;
            Activator.this.log(String.format("workspace is set; try to initialize logging", new Object[0]));
            LogManager.setFactory((LoggerContextFactory)new Log4jContextFactory((ContextSelector)new BundleContextSelector()));
            PreferenceConstants.OLD_LOGGING_PATH = logDir = PreferenceUtils.getLogDirectory(true);
            Activator.this.log("--------------->" + logDir);
            URL logurl = Activator.class.getResource("conf/log4j2.xml");
            if (logurl != null) {
                System.setProperty("log4j.dir", logDir);
                Activator.this.log("---------------> use default log4j2.xml warning level");
                System.setProperty("log4j.configurationFile", logurl.toString());
            }
        }
    }
}

