/*
 * Decompiled with CFR 0.152.
 */
package com.ez.eclient.logging.preferences;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.osgi.service.runnable.StartupMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TracingStartupMonitor
implements StartupMonitor {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    static final Logger L = LoggerFactory.getLogger(TracingStartupMonitor.class);
    Set<ApplicationRunningListener> listeners;

    public void update() {
    }

    public void applicationRunning() {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            L.debug("::app running; notify listeners");
            for (ApplicationRunningListener l : this.listeners) {
                l.applicationRunning();
            }
        } else {
            L.info("no listeners to be notified!");
        }
    }

    public void registerListener(ApplicationRunningListener lst) {
        if (this.listeners == null) {
            this.listeners = new HashSet<ApplicationRunningListener>();
        }
        this.listeners.add(lst);
    }

    public static interface ApplicationRunningListener {
        public void applicationRunning();
    }
}

