/*
 * Decompiled with CFR 0.152.
 */
package com.ez.eclient.logging.preferences;

import com.ez.internal.utils.Utils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferenceUtils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    public static String getLogDirectory() {
        return PreferenceUtils.getLogDirectory(false);
    }

    public static String getLogDirectory(boolean silentLog) {
        Logger L = LoggerFactory.getLogger(PreferenceUtils.class);
        String logFolder = null;
        boolean wkspSet = Platform.getInstanceLocation().isSet();
        boolean isRunning = Platform.isRunning();
        try {
            IPreferencesService preferencesService = Platform.getPreferencesService();
            wkspSet = Platform.getInstanceLocation().isSet();
            isRunning = Platform.isRunning();
            L.debug("1.wkspSet={}", (Object)wkspSet);
            L.debug("1.platform.isRunning={}", (Object)isRunning);
            if (!wkspSet) {
                L.warn("instance location is not set when trying to get logging directory!");
            } else {
                logFolder = preferencesService.getString("com.ez.eclient.logging.preferences", "logPathPreference", null, null);
            }
        }
        catch (Exception ex) {
            if (silentLog) {
                L.error("Error", (Throwable)ex);
            }
            L.error("", (Throwable)ex);
        }
        if (logFolder == null) {
            if (silentLog) {
                System.out.println(String.format("Preference not found: %s:%s", "com.ez.eclient.logging.preferences", "logPathPreference"));
            } else {
                L.info(String.format("Preference not found: %s:%s", "com.ez.eclient.logging.preferences", "logPathPreference"));
            }
            try {
                logFolder = (String)PreferenceUtils.getDefaultValue("logPathPreference");
            }
            catch (Exception ex) {
                if (silentLog) {
                    L.error("Error", (Throwable)ex);
                }
                L.error("", (Throwable)ex);
            }
            wkspSet = Platform.getInstanceLocation().isSet();
            isRunning = Platform.isRunning();
            L.debug("2.wkspSet={}", (Object)wkspSet);
            L.debug("2.platform.isRunning={}", (Object)isRunning);
        }
        return logFolder;
    }

    public static final Object getDefaultValue(String preference) {
        if (preference != null && preference.equalsIgnoreCase("logPathPreference")) {
            return PreferenceUtils.getLogPath();
        }
        return null;
    }

    private static final String getLogPath() {
        String filePath = Utils.getApplicationDefaultPath().concat(Utils.SYSTEM_FILE_SEPARATOR_PROPERTY).concat("log");
        return filePath;
    }
}

